/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Responses {

    public static class ReadObjectVariableResponse
    extends ReadVariableResponse<Object> {
        public ReadObjectVariableResponse(String commandName, String variableName, Models.CoreInfo coreInfo, Object result) {
            super(commandName, variableName, coreInfo, result);
        }
    }

    public static class ReadStringVariableResponse
    extends ReadVariableResponse<String> {
        public ReadStringVariableResponse(String commandName, String variableName, Models.CoreInfo coreInfo, String result) {
            super(commandName, variableName, coreInfo, result);
        }
    }

    public static class ReadDoubleVariableResponse
    extends ReadVariableResponse<Double> {
        public ReadDoubleVariableResponse(String commandName, String variableName, Models.CoreInfo coreInfo, Double result) {
            super(commandName, variableName, coreInfo, result);
        }
    }

    public static class ReadIntVariableResponse
    extends ReadVariableResponse<Integer> {
        public ReadIntVariableResponse(String commandName, String variableName, Models.CoreInfo coreInfo, Integer result) {
            super(commandName, variableName, coreInfo, result);
        }
    }

    public static abstract class ReadVariableResponse<T> {
        @SerializedName(value="cmd")
        public final String commandName;
        @SerializedName(value="name")
        public final String variableName;
        public final T result;
        public final Models.CoreInfo coreInfo;

        public ReadVariableResponse(String commandName, String variableName, Models.CoreInfo coreInfo, T result) {
            this.commandName = commandName;
            this.variableName = variableName;
            this.result = result;
            this.coreInfo = coreInfo;
        }
    }

    public static class ClaimCodeResponse {
        @SerializedName(value="claim_code")
        public final String claimCode;
        @SerializedName(value="device_ids")
        public final String[] deviceIds;

        public ClaimCodeResponse(String claimCode, String[] deviceIds) {
            this.claimCode = claimCode;
            this.deviceIds = deviceIds;
        }
    }

    public static class SimpleResponse {
        public final boolean ok;
        public final String error;

        public SimpleResponse(boolean ok, String error) {
            this.ok = ok;
            this.error = error;
        }

        public String toString() {
            return "SimpleResponse [ok=" + this.ok + ", error=" + this.error + "]";
        }
    }

    public static class LogInResponse {
        @SerializedName(value="expires_in")
        public final long expiresInSeconds;
        @SerializedName(value="access_token")
        public final String accessToken;
        @SerializedName(value="refresh_token")
        public final String refreshToken;
        @SerializedName(value="token_type")
        public final String tokenType;

        public LogInResponse(long expiresInSeconds, String accessToken, String refreshToken, String tokenType) {
            this.expiresInSeconds = expiresInSeconds;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.tokenType = tokenType;
        }
    }

    public static class CallFunctionResponse {
        @SerializedName(value="id")
        public final String deviceId;
        @SerializedName(value="name")
        public final String deviceName;
        public final boolean connected;
        @SerializedName(value="return_value")
        public final int returnValue;

        public CallFunctionResponse(String deviceId, String deviceName, boolean connected, int returnValue) {
            this.deviceId = deviceId;
            this.deviceName = deviceName;
            this.connected = connected;
            this.returnValue = returnValue;
        }
    }

    public static class TokenResponse {
        public final String token;

        public TokenResponse(String token) {
            this.token = token;
        }
    }

    static class Models {
        Models() {
        }

        class CompleteDevice {
            @SerializedName(value="id")
            public final String deviceId;
            public final String name;
            public final boolean cellular;
            public final String imei;
            @SerializedName(value="last_iccid")
            public final String lastIccid;
            @SerializedName(value="current_build_target")
            public final String currentBuild;
            @SerializedName(value="default_build_target")
            public final String defaultBuild;
            @SerializedName(value="connected")
            public final boolean isConnected;
            public final Map<String, String> variables;
            public final List<String> functions;
            @SerializedName(value="cc3000_patch_version")
            public final String version;
            @SerializedName(value="product_id")
            public final int productId;
            @SerializedName(value="platform_id")
            public final int platformId;
            @SerializedName(value="last_ip_address")
            public final String ipAddress;
            @SerializedName(value="last_app")
            public final String lastAppName;
            @SerializedName(value="status")
            public final String status;
            @SerializedName(value="device_needs_update")
            public final boolean requiresUpdate;
            @SerializedName(value="last_heard")
            public final Date lastHeard;

            CompleteDevice(String deviceId, String name, boolean isConnected, boolean cellular, String imei, String lastIccid, String currentBuild, String defaultBuild, Map<String, String> variables, List<String> functions, String version, int productId, int platformId, String ipAddress, String lastAppName, String status, boolean requiresUpdate, Date lastHeard) {
                this.deviceId = deviceId;
                this.name = name;
                this.isConnected = isConnected;
                this.cellular = cellular;
                this.imei = imei;
                this.lastIccid = lastIccid;
                this.currentBuild = currentBuild;
                this.defaultBuild = defaultBuild;
                this.variables = variables;
                this.functions = functions;
                this.version = version;
                this.productId = productId;
                this.platformId = platformId;
                this.ipAddress = ipAddress;
                this.lastAppName = lastAppName;
                this.status = status;
                this.requiresUpdate = requiresUpdate;
                this.lastHeard = lastHeard;
            }
        }

        public static class SimpleDevice {
            public final String id;
            public final String name;
            public final boolean cellular;
            public final String imei;
            @SerializedName(value="last_iccid")
            public final String lastIccid;
            @SerializedName(value="current_build_target")
            public final String currentBuild;
            @SerializedName(value="default_build_target")
            public final String defaultBuild;
            @SerializedName(value="connected")
            public final boolean isConnected;
            @SerializedName(value="product_id")
            public final int productId;
            @SerializedName(value="platform_id")
            public final int platformId;
            @SerializedName(value="last_ip_address")
            public final String ipAddress;
            @SerializedName(value="status")
            public final String status;
            @SerializedName(value="last_heard")
            public final Date lastHeard;

            public SimpleDevice(String id, String name, boolean isConnected, boolean cellular, String imei, String lastIccid, String currentBuild, String defaultBuild, int platformId, int productId, String ipAddress, String status, Date lastHeard) {
                this.id = id;
                this.name = name;
                this.isConnected = isConnected;
                this.cellular = cellular;
                this.imei = imei;
                this.lastIccid = lastIccid;
                this.currentBuild = currentBuild;
                this.defaultBuild = defaultBuild;
                this.platformId = platformId;
                this.productId = productId;
                this.ipAddress = ipAddress;
                this.status = status;
                this.lastHeard = lastHeard;
            }
        }

        public static class CoreInfo {
            @SerializedName(value="last_app")
            public final String lastApp;
            @SerializedName(value="last_heard")
            public final Date lastHeard;
            public final boolean connected;
            public final String deviceId;

            public CoreInfo(String lastApp, Date lastHeard, boolean connected, String deviceId) {
                this.lastApp = lastApp;
                this.lastHeard = lastHeard;
                this.connected = connected;
                this.deviceId = deviceId;
            }
        }
    }
}

