/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.utils.Parcelables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class DeviceState
implements Parcelable {
    final String deviceId;
    @Nullable
    final Integer platformId;
    @Nullable
    final Integer productId;
    @Nullable
    final String ipAddress;
    @Nullable
    final String lastAppName;
    @Nullable
    final String status;
    @Nullable
    final String name;
    @Nullable
    final Boolean isConnected;
    @Nullable
    final Boolean cellular;
    @Nullable
    final String imei;
    @Nullable
    final String lastIccid;
    @Nullable
    final String currentBuild;
    @Nullable
    final String defaultBuild;
    final Set<String> functions;
    final Map<String, ParticleDevice.VariableType> variables;
    @Nullable
    final String version;
    @Nullable
    final ParticleDevice.ParticleDeviceType deviceType;
    @Nullable
    final Boolean requiresUpdate;
    @Nullable
    final Date lastHeard;
    public static final Parcelable.Creator<DeviceState> CREATOR = new Parcelable.Creator<DeviceState>(){

        public DeviceState createFromParcel(Parcel in) {
            return new DeviceState(in);
        }

        public DeviceState[] newArray(int size) {
            return new DeviceState[size];
        }
    };

    DeviceState(DeviceStateBuilder deviceStateBuilder) {
        this.deviceId = deviceStateBuilder.deviceId;
        this.name = deviceStateBuilder.name;
        this.isConnected = deviceStateBuilder.isConnected;
        this.cellular = deviceStateBuilder.cellular;
        this.imei = deviceStateBuilder.imei;
        this.lastIccid = deviceStateBuilder.lastIccid;
        this.currentBuild = deviceStateBuilder.currentBuild;
        this.defaultBuild = deviceStateBuilder.defaultBuild;
        this.functions = deviceStateBuilder.functions;
        this.variables = deviceStateBuilder.variables;
        this.version = deviceStateBuilder.version == null ? "" : deviceStateBuilder.version;
        this.deviceType = deviceStateBuilder.deviceType;
        this.platformId = deviceStateBuilder.platformId;
        this.productId = deviceStateBuilder.productId;
        this.ipAddress = deviceStateBuilder.ipAddress;
        this.lastAppName = deviceStateBuilder.lastAppName;
        this.status = deviceStateBuilder.status;
        this.requiresUpdate = deviceStateBuilder.requiresUpdate;
        this.lastHeard = deviceStateBuilder.lastHeard;
    }

    static DeviceState withNewName(DeviceState other, String newName) {
        return new DeviceStateBuilder(other.deviceId, other.functions, other.variables).name(newName).cellular(other.cellular).connected(other.isConnected).version(other.version).deviceType(other.deviceType).platformId(other.platformId).productId(other.productId).imei(other.imei).iccid(other.lastIccid).currentBuild(other.currentBuild).defaultBuild(other.defaultBuild).ipAddress(other.ipAddress).lastAppName(other.lastAppName).status(other.status).requiresUpdate(other.requiresUpdate).lastHeard(other.lastHeard).build();
    }

    static DeviceState withNewConnectedState(DeviceState other, boolean newConnectedState) {
        return new DeviceStateBuilder(other.deviceId, other.functions, other.variables).name(other.name).cellular(other.cellular).connected(newConnectedState).version(other.version).deviceType(other.deviceType).platformId(other.platformId).productId(other.productId).imei(other.imei).iccid(other.lastIccid).currentBuild(other.currentBuild).defaultBuild(other.defaultBuild).ipAddress(other.ipAddress).lastAppName(other.lastAppName).status(other.status).requiresUpdate(other.requiresUpdate).lastHeard(other.lastHeard).build();
    }

    private DeviceState(Parcel in) {
        this.deviceId = in.readString();
        this.name = (String)in.readValue(String.class.getClassLoader());
        this.isConnected = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.functions = new HashSet<String>(Parcelables.readStringList(in));
        this.variables = Parcelables.readSerializableMap(in);
        this.version = (String)in.readValue(String.class.getClassLoader());
        this.deviceType = ParticleDevice.ParticleDeviceType.valueOf((String)in.readValue(String.class.getClassLoader()));
        this.platformId = (Integer)in.readValue(Integer.class.getClassLoader());
        this.productId = (Integer)in.readValue(Integer.class.getClassLoader());
        this.cellular = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.imei = (String)in.readValue(String.class.getClassLoader());
        this.lastIccid = (String)in.readValue(String.class.getClassLoader());
        this.currentBuild = (String)in.readValue(String.class.getClassLoader());
        this.defaultBuild = (String)in.readValue(String.class.getClassLoader());
        this.ipAddress = (String)in.readValue(String.class.getClassLoader());
        this.lastAppName = (String)in.readValue(String.class.getClassLoader());
        this.status = (String)in.readValue(String.class.getClassLoader());
        this.requiresUpdate = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.lastHeard = new Date((Long)in.readValue(Long.class.getClassLoader()));
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceId);
        dest.writeValue((Object)this.name);
        dest.writeValue((Object)this.isConnected);
        dest.writeStringList(new ArrayList<String>(this.functions));
        Parcelables.writeSerializableMap(dest, this.variables);
        dest.writeValue((Object)this.version);
        dest.writeValue(this.deviceType != null ? this.deviceType.name() : null);
        dest.writeValue((Object)this.platformId);
        dest.writeValue((Object)this.productId);
        dest.writeValue((Object)this.cellular);
        dest.writeValue((Object)this.imei);
        dest.writeValue((Object)this.lastIccid);
        dest.writeValue((Object)this.currentBuild);
        dest.writeValue((Object)this.defaultBuild);
        dest.writeValue((Object)this.ipAddress);
        dest.writeValue((Object)this.lastAppName);
        dest.writeValue((Object)this.status);
        dest.writeValue((Object)this.requiresUpdate);
        dest.writeValue((Object)(this.lastHeard != null ? this.lastHeard.getTime() : 0L));
    }

    public int describeContents() {
        return 0;
    }

    public static class DeviceStateBuilder {
        private final String deviceId;
        @Nullable
        private Integer platformId;
        @Nullable
        private Integer productId;
        @Nullable
        private String ipAddress;
        @Nullable
        private String lastAppName;
        @Nullable
        private String status;
        @Nullable
        private String name;
        @Nullable
        private Boolean isConnected;
        @Nullable
        private Boolean cellular;
        @Nullable
        private String imei;
        @Nullable
        private String lastIccid;
        @Nullable
        private String currentBuild;
        @Nullable
        private String defaultBuild;
        private final Set<String> functions;
        private final Map<String, ParticleDevice.VariableType> variables;
        @Nullable
        String version;
        @Nullable
        ParticleDevice.ParticleDeviceType deviceType;
        @Nullable
        Boolean requiresUpdate;
        @Nullable
        Date lastHeard;

        DeviceStateBuilder(String deviceId, Set<String> functions, Map<String, ParticleDevice.VariableType> variables) {
            this.deviceId = deviceId;
            this.functions = functions;
            this.variables = variables;
            this.version = this.version == null ? "" : this.version;
        }

        public DeviceStateBuilder platformId(@Nullable Integer platformId) {
            this.platformId = platformId;
            return this;
        }

        public DeviceStateBuilder productId(@Nullable Integer productId) {
            this.productId = productId;
            return this;
        }

        public DeviceStateBuilder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public DeviceStateBuilder lastAppName(@Nullable String lastAppName) {
            this.lastAppName = lastAppName;
            return this;
        }

        public DeviceStateBuilder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public DeviceStateBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public DeviceStateBuilder connected(@Nullable Boolean connected) {
            this.isConnected = connected;
            return this;
        }

        public DeviceStateBuilder cellular(@Nullable Boolean cellular) {
            this.cellular = cellular;
            return this;
        }

        public DeviceStateBuilder imei(@Nullable String imei) {
            this.imei = imei;
            return this;
        }

        public DeviceStateBuilder iccid(@Nullable String iccid) {
            this.lastIccid = iccid;
            return this;
        }

        public DeviceStateBuilder currentBuild(@Nullable String currentBuild) {
            this.currentBuild = currentBuild;
            return this;
        }

        public DeviceStateBuilder defaultBuild(@Nullable String defaultBuild) {
            this.defaultBuild = defaultBuild;
            return this;
        }

        public DeviceStateBuilder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public DeviceStateBuilder deviceType(@Nullable ParticleDevice.ParticleDeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DeviceStateBuilder requiresUpdate(@Nullable Boolean requiresUpdate) {
            this.requiresUpdate = requiresUpdate;
            return this;
        }

        public DeviceStateBuilder lastHeard(@Nullable Date lastHeard) {
            this.lastHeard = lastHeard;
            return this;
        }

        public DeviceState build() {
            return new DeviceState(this);
        }
    }
}

