/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.http;

import java.net.URI;
import java.util.Comparator;

public enum HttpRedirectPolicy implements Comparator<URI>
{
    NEVER{

        @Override
        public int compare(URI current, URI redirect) {
            if (current == null || redirect == null) {
                String s = "Null URI passed in to compare()";
                throw new IllegalArgumentException(s);
            }
            return -1;
        }

        @Override
        public String toString() {
            return "HttpRedirectOption.NEVER";
        }
    }
    ,
    ALWAYS{

        @Override
        public int compare(URI current, URI redirect) {
            if (current == null || redirect == null) {
                String s = "Null URI passed in to compare()";
                throw new IllegalArgumentException(s);
            }
            return 0;
        }

        @Override
        public String toString() {
            return "HttpRedirectOption.ALWAYS";
        }
    }
    ,
    SAME_ORIGIN{

        @Override
        public int compare(URI current, URI redirect) {
            if (current == null || redirect == null) {
                String s = "Null URI passed in to compare()";
                throw new IllegalArgumentException(s);
            }
            if (current.getScheme().equalsIgnoreCase(redirect.getScheme()) && current.getAuthority().equalsIgnoreCase(redirect.getAuthority())) {
                return 0;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "HttpRedirectOption.SAME_ORIGIN";
        }
    }
    ,
    SAME_DOMAIN{

        @Override
        public int compare(URI current, URI redirect) {
            String newHost;
            String currHost;
            if (SAME_ORIGIN.compare(current, redirect) == 0) {
                return 0;
            }
            if (current == null || redirect == null) {
                String s = "Null URI passed in to compare()";
                throw new IllegalArgumentException(s);
            }
            String currScheme = current.getScheme();
            String newScheme = redirect.getScheme();
            if ((newScheme.equalsIgnoreCase(currScheme) || newScheme.contains(currScheme)) && (currHost = current.getHost()).equalsIgnoreCase(newHost = redirect.getHost())) {
                return 0;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "HttpRedirectOption.SAME_DOMAIN";
        }
    }
    ,
    PEER_DOMAIN{

        @Override
        public int compare(URI current, URI redirect) {
            if (SAME_DOMAIN.compare(current, redirect) == 0) {
                return 0;
            }
            if (current == null || redirect == null) {
                String s = "Null URI passed in to compare()";
                throw new IllegalArgumentException(s);
            }
            String currScheme = current.getScheme();
            String newScheme = redirect.getScheme();
            if (newScheme.equalsIgnoreCase(currScheme) || newScheme.contains(currScheme)) {
                String currHost = current.getHost();
                String redirectHost = redirect.getHost();
                String currBaseDomain = this.getBaseDomain(currHost);
                String redirectBaseDomain = this.getBaseDomain(redirectHost);
                if (currHost.endsWith(redirectBaseDomain) && redirectHost.endsWith(currBaseDomain)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public String toString() {
            return "HttpRedirectOption.PEER_DOMAIN";
        }

        private String getBaseDomain(String hostname) {
            String[] tokens = hostname.split("\\.");
            if (tokens.length <= 2) {
                return hostname;
            }
            StringBuilder baseDomain = new StringBuilder();
            for (int i = 1; i < tokens.length; ++i) {
                baseDomain.append(".").append(tokens[i]);
            }
            return baseDomain.toString();
        }
    }
    ,
    SUB_DOMAIN{

        @Override
        public int compare(URI current, URI redirect) {
            if (SAME_DOMAIN.compare(current, redirect) == 0) {
                return 0;
            }
            if (current == null || redirect == null) {
                String s = "Null URI passed in to compare()";
                throw new IllegalArgumentException(s);
            }
            String currScheme = current.getScheme();
            String newScheme = redirect.getScheme();
            if (newScheme.equalsIgnoreCase(currScheme) || newScheme.contains(currScheme)) {
                String currHost = current.getHost();
                String newHost = redirect.getHost();
                if (newHost.length() < currHost.length()) {
                    return -1;
                }
                if (newHost.endsWith("." + currHost)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public String toString() {
            return "HttpRedirectOption.SUB_DOMAIN";
        }
    };


    @Override
    public abstract int compare(URI var1, URI var2);

    public abstract String toString();
}

