/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wsn;

import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.EncoderOutput;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeEncoder;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeEncoderImpl;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketNativeCodec
extends WebSocketHandlerAdapter {
    private WebSocketNativeEncoder encoder = new WebSocketNativeEncoderImpl();
    private EncoderOutput<WebSocketChannel> out;

    @Override
    public void processBinaryMessage(WebSocketChannel channel, WrappedByteBuffer message) {
        this.encoder.encodeBinaryMessage(channel, message, this.out);
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String message) {
        this.encoder.encodeTextMessage(channel, message, this.out);
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        super.setNextHandler(handler);
        this.out = handler::processBinaryMessage;
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeCodec.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeCodec.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeCodec.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
                WebSocketNativeCodec.this.listener.binaryMessageReceived(channel, buf);
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketNativeCodec.this.listener.textMessageReceived(channel, message);
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
                WebSocketNativeCodec.this.listener.commandMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketNativeCodec.this.listener.connectionClosed(channel, wasClean, code, reason);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeCodec.this.listener.connectionClosed(channel, ex);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeCodec.this.listener.connectionFailed(channel, ex);
            }
        });
    }
}

