/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wseb;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestAuthenticationHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestRedirectHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestTransportHandler;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedChannel;
import org.kaazing.gateway.client.impl.wseb.CreateChannel;
import org.kaazing.gateway.client.impl.wseb.CreateHandler;
import org.kaazing.gateway.client.impl.wseb.CreateHandlerFactory;
import org.kaazing.gateway.client.impl.wseb.CreateHandlerListener;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedHandler;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

class CreateHandlerImpl
implements CreateHandler {
    private static final String CLASS_NAME = CreateHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static CreateHandlerFactory FACTORY = CreateHandlerImpl::new;
    private static final String HEADER_WEBSOCKET_PROTOCOL = "X-WebSocket-Protocol";
    private static final String HEADER_SEC_EXTENSIONS = "X-WebSocket-Extensions";
    private static final String HEADER_WEBSOCKET_VERSION = "X-WebSocket-Version";
    private static final String HEADER_ACCEPT_COMMANDS = "X-Accept-Commands";
    private static final String WEBSOCKET_VERSION = "wseb-1.0";
    HttpRequestHandler nextHandler;
    CreateHandlerListener listener;
    HttpRequestAuthenticationHandler authHandler = new HttpRequestAuthenticationHandler();
    HttpRequestRedirectHandler redirectHandler = new HttpRequestRedirectHandler();
    HttpRequestHandler transportHandler = HttpRequestTransportHandler.DEFAULT_FACTORY.createHandler();

    public CreateHandlerImpl() {
        this.setNextHandler(this.authHandler);
        this.authHandler.setNextHandler(this.redirectHandler);
        this.redirectHandler.setNextHandler(this.transportHandler);
    }

    @Override
    public void processOpen(CreateChannel channel, HttpURI location) {
        HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.GET, location, false);
        if (channel.getProtocols() != null && channel.getProtocols().length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String p : channel.getProtocols()) {
                sb.append(p);
                sb.append(',');
            }
            request.getHeaders().put(HEADER_WEBSOCKET_PROTOCOL, sb.substring(0, sb.length() - 1));
        }
        request.getHeaders().put(HEADER_SEC_EXTENSIONS, this.getEnabledExtensions(channel));
        request.getHeaders().put(HEADER_WEBSOCKET_VERSION, WEBSOCKET_VERSION);
        request.getHeaders().put(HEADER_ACCEPT_COMMANDS, "ping");
        request.getHeaders().put("X-Sequence-No", Long.toString(channel.nextSequence()));
        request.parent = channel;
        channel.setRequest(request);
        this.nextHandler.processOpen(request);
    }

    @Override
    public void processClose(CreateChannel channel) {
        HttpRequest request = channel.getRequest();
        if (request != null) {
            this.nextHandler.processAbort(request);
        }
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
            }

            @Override
            public void requestOpened(HttpRequest request) {
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer data) {
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                WebSocketEmulatedHandler.LOG.entering(WebSocketEmulatedHandler.CLASS_NAME, "requestLoaded");
                CreateChannel channel = (CreateChannel)request.parent;
                try {
                    channel.cookie = response.getHeader("Set-Cookie");
                    String protocol = response.getHeader(CreateHandlerImpl.HEADER_WEBSOCKET_PROTOCOL);
                    ((WebSocketChannel)channel.getParent()).setProtocol(protocol);
                    String extensionsHeader = response.getHeader(CreateHandlerImpl.HEADER_SEC_EXTENSIONS);
                    ((WebSocketChannel)channel.getParent()).setNegotiatedExtensions(extensionsHeader);
                    if (extensionsHeader != null && extensionsHeader.length() > 0) {
                        String[] extensions;
                        for (String extension : extensions = extensionsHeader.split(",")) {
                            String escape;
                            String[] tmp = extension.split(";");
                            if (tmp.length <= 1 || (escape = tmp[1].trim()).length() != 8) continue;
                            try {
                                int escapeKey = Integer.parseInt(escape, 16);
                                channel.controlFrames.put(escapeKey, tmp[0].trim());
                            }
                            catch (NumberFormatException e) {
                                LOG.log(Level.FINE, e.getMessage(), e);
                            }
                        }
                    }
                    WrappedByteBuffer responseBody = response.getBody();
                    String urls = responseBody.getString(WebSocketEmulatedHandler.UTF_8);
                    String[] parts = urls.split("\n");
                    HttpURI upstreamUri = new HttpURI(parts[0]);
                    HttpURI downstreamUri = new HttpURI(parts.length == 2 ? parts[1] : parts[0]);
                    CreateHandlerImpl.this.listener.createCompleted(channel, upstreamUri, downstreamUri, null);
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                    CreateHandlerImpl.this.listener.createFailed(channel, e);
                    throw new IllegalStateException("WebSocketEmulation failed", e);
                }
            }

            @Override
            public void requestAborted(HttpRequest request) {
                CreateChannel channel = (CreateChannel)request.parent;
                channel.setRequest(null);
            }

            @Override
            public void requestClosed(HttpRequest request) {
                CreateChannel channel = (CreateChannel)request.parent;
                channel.setRequest(null);
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                CreateChannel createChannel = (CreateChannel)request.parent;
                CreateHandlerImpl.this.listener.createFailed(createChannel, exception);
            }
        });
    }

    @Override
    public void setListener(CreateHandlerListener listener) {
        this.listener = listener;
    }

    private String getEnabledExtensions(CreateChannel channel) {
        WebSocketSelectedChannel selChannel = (WebSocketSelectedChannel)channel.getParent();
        WebSocketCompositeChannel compChannel = (WebSocketCompositeChannel)selChannel.getParent();
        return compChannel.getEnabledExtensions();
    }
}

