/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandlerAdapter;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedChannel;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.StringUtils;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.http.HttpRedirectPolicy;

public class HttpRequestRedirectHandler
extends HttpRequestHandlerAdapter {
    private static final String CLASS_NAME = HttpRequestRedirectHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        super.setNextHandler(handler);
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestReady(request);
            }

            @Override
            public void requestOpened(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestOpened(request);
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
                HttpRequestRedirectHandler.this.listener.requestProgressed(request, payload);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                int responseCode = response.getStatusCode();
                switch (responseCode) {
                    case 301: 
                    case 302: 
                    case 307: {
                        String redirectedLocation = response.getHeader("Location");
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("redirectedLocation = " + StringUtils.stripControlCharacters(redirectedLocation));
                        }
                        if (redirectedLocation == null) {
                            throw new IllegalStateException("Redirect response missing location header: " + responseCode);
                        }
                        try {
                            HttpURI uri = new HttpURI(redirectedLocation);
                            HttpRequest redirectRequest = new HttpRequest(request.getMethod(), uri, request.isAsync());
                            redirectRequest.parent = request.parent;
                            WebSocketEmulatedChannel channel = (WebSocketEmulatedChannel)request.parent.getParent();
                            channel.redirectUri = uri;
                            WebSocketCompositeChannel compChannel = (WebSocketCompositeChannel)channel.getParent();
                            HttpRedirectPolicy policy = compChannel.getFollowRedirect();
                            URI currentURI = channel.getLocation().getURI();
                            URI redirectURI = uri.getURI();
                            String normalizedRedirectScheme = redirectURI.getScheme().toLowerCase().replace("http", "ws");
                            URI normalizedRedirectURI = new URI(normalizedRedirectScheme, redirectURI.getSchemeSpecificPart(), null);
                            if (policy != null && policy.compare(currentURI, normalizedRedirectURI) != 0) {
                                String s = String.format("%s: Cannot redirect from '%s' to '%s'", policy, currentURI, normalizedRedirectURI);
                                channel.preventFallback = true;
                                throw new IllegalStateException(s);
                            }
                            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                                redirectRequest.setHeader(entry.getKey(), entry.getValue());
                            }
                            HttpRequestRedirectHandler.this.nextHandler.processOpen(redirectRequest);
                            break;
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, e.getMessage(), e);
                            throw new IllegalStateException("Redirect to a malformed URL: " + redirectedLocation, e);
                        }
                    }
                    default: {
                        HttpRequestRedirectHandler.this.listener.requestLoaded(request, response);
                    }
                }
            }

            @Override
            public void requestClosed(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestClosed(request);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                HttpRequestRedirectHandler.this.listener.requestAborted(request);
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                HttpRequestRedirectHandler.this.listener.errorOccurred(request, exception);
            }
        });
    }
}

