/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.support.v4.util.ArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;

public class Py {
    public static boolean truthy(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            return !((Collection)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length > 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue() != 0L;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() > 0;
        }
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).length() > 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof long[]) {
            return ((long[])obj).length > 0;
        }
        if (obj instanceof int[]) {
            return ((int[])obj).length > 0;
        }
        if (obj instanceof short[]) {
            return ((short[])obj).length > 0;
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj).length > 0;
        }
        if (obj instanceof char[]) {
            return ((char[])obj).length > 0;
        }
        if (obj instanceof boolean[]) {
            return ((boolean[])obj).length > 0;
        }
        if (obj instanceof float[]) {
            return ((float[])obj).length > 0;
        }
        if (obj instanceof double[]) {
            return ((double[])obj).length > 0;
        }
        return true;
    }

    public static boolean all(Object ... objects) {
        if (!Py.truthy(objects)) {
            return false;
        }
        for (Object obj : objects) {
            if (Py.truthy(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean any(Object ... objects) {
        if (!Py.truthy(objects)) {
            return false;
        }
        for (Object obj : objects) {
            if (!Py.truthy(obj)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... objects) {
        return new ArrayList<T>(Arrays.asList(objects));
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> List<T> list(Collection<T> someCollection) {
        return new ArrayList<T>(someCollection);
    }

    public static <T> List<T> list(Iterable<T> things) {
        return Py.list(things.iterator());
    }

    public static <T> List<T> list(Iterator<T> things) {
        ArrayList<T> result = new ArrayList<T>();
        while (things.hasNext()) {
            result.add(things.next());
        }
        return result;
    }

    @SafeVarargs
    public static <T> PySet<T> set(T ... objects) {
        return Py.set(Arrays.asList(objects));
    }

    public static <T> PySet<T> set(Collection<T> someCollection) {
        return new PySet<T>(someCollection);
    }

    @SafeVarargs
    public static <T> List<T> tuple(T ... objects) {
        return Collections.unmodifiableList(Py.list(objects));
    }

    public static <T> List<T> tuple(List<T> someList) {
        return Collections.unmodifiableList(someList);
    }

    @SafeVarargs
    public static <T> Set<T> frozenset(T ... objects) {
        return Collections.unmodifiableSet(Py.set(objects));
    }

    public static <T> Set<T> frozenset(Set<T> someSet) {
        return Collections.unmodifiableSet(someSet);
    }

    public static <K, V> Map<K, V> map(List<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("key and value lists MUST be the same size!");
        }
        Map<K, V> newMap = Py.map();
        for (int i = 0; i < keys.size(); ++i) {
            newMap.put(keys.get(i), values.get(i));
        }
        return newMap;
    }

    public static <K, V> Map<K, V> map() {
        return new ArrayMap();
    }

    public static <K, V> Map<K, V> frozenmap(List<K> keys, List<V> values) {
        return Collections.unmodifiableMap(Py.map(keys, values));
    }

    public static <K, V> Map<K, V> frozenmap() {
        return Collections.unmodifiableMap(new ArrayMap());
    }

    public static class PySet<T>
    extends LinkedHashSet<T> {
        private static final long serialVersionUID = 2423791518942099628L;

        public PySet(Collection<T> other) {
            super(other);
        }

        @SafeVarargs
        public final PySet<T> getUnion(Collection<T> ... others) {
            PySet newCopy = Py.set(this);
            for (Collection<T> other : others) {
                newCopy.addAll(other);
            }
            return newCopy;
        }

        public PySet<T> getIntersection(Collection<T> other) {
            PySet newCopy = Py.set(this);
            newCopy.retainAll(other);
            return newCopy;
        }

        @SafeVarargs
        public final PySet<T> getIntersection(Collection<T> ... others) {
            PySet newCopy = Py.set(this);
            for (Collection<T> other : others) {
                newCopy.retainAll(other);
            }
            return newCopy;
        }

        public PySet<T> getDifference(Collection<T> other) {
            PySet newCopy = Py.set(this);
            newCopy.removeAll(other);
            return newCopy;
        }

        @SafeVarargs
        public final PySet<T> getDifference(Collection<T> ... others) {
            PySet newCopy = Py.set(this);
            for (Collection<T> other : others) {
                newCopy.removeAll(other);
            }
            return newCopy;
        }

        @SafeVarargs
        public final PySet<T> getSymmetricDifference(Collection<T> ... others) {
            PySet union = Py.set(this);
            for (Collection<T> other : others) {
                union.addAll(other);
            }
            PySet<T> intersection = Py.set(this);
            for (Collection<T> other : others) {
                if (intersection.isEmpty()) break;
                intersection = intersection.getIntersection(other);
            }
            return union.getDifference((Collection<T>)intersection);
        }
    }
}

