/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Funcy {
    private static final Predicate<?> alwaysTrue = testTarget -> true;
    private static final Predicate<?> alwaysFalse = testTarget -> false;
    private static final Predicate<?> notNull = testTarget -> testTarget != null;
    private static final CollectionFactory<List> listFactory = new CollectionFactory<List>(){

        @Override
        public List<?> newWithCapacity(int size) {
            return new ArrayList(size);
        }

        @Override
        public List<?> emptyCollection() {
            return Collections.emptyList();
        }
    };
    private static final CollectionFactory<Set> setFactory = new CollectionFactory<Set>(){

        @Override
        public Set<?> newWithCapacity(int size) {
            return new HashSet(size);
        }

        @Override
        public Set<?> emptyCollection() {
            return Collections.emptySet();
        }
    };

    public static <T> Predicate<T> alwaysTrue() {
        return alwaysTrue;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return alwaysFalse;
    }

    public static <T> Predicate<T> notNull() {
        return notNull;
    }

    public static <In, Out> List<Out> transformList(@Nullable List<In> sourceList, Func<In, Out> transformFunc) {
        return Funcy.transformList(sourceList, null, transformFunc, null);
    }

    public static <In, Out> List<Out> transformList(@Nullable List<In> sourceList, Predicate<In> inTypeInclusionFilter, Func<In, Out> transformFunc) {
        return Funcy.transformList(sourceList, inTypeInclusionFilter, transformFunc, null);
    }

    public static <In, Out> List<Out> transformList(@Nullable List<In> sourceList, Func<In, Out> transformFunc, Predicate<Out> outTypeInclusionFilter) {
        return Funcy.transformList(sourceList, null, transformFunc, outTypeInclusionFilter);
    }

    public static <In, Out> List<Out> transformList(@Nullable List<In> sourceList, @Nullable Predicate<In> inTypeInclusionFilter, Func<In, Out> transformFunc, @Nullable Predicate<Out> outTypeInclusionFilter) {
        return (List)Funcy.transformCollection(sourceList, inTypeInclusionFilter, transformFunc, outTypeInclusionFilter, listFactory);
    }

    public static <In, Out> Set<Out> transformSet(@Nullable Set<In> sourceSet, Func<In, Out> transformFunc) {
        return Funcy.transformSet(sourceSet, null, transformFunc, null);
    }

    public static <In, Out> Set<Out> transformSet(@Nullable Set<In> sourceSet, Predicate<In> inTypeInclusionFilter, Func<In, Out> transformFunc) {
        return Funcy.transformSet(sourceSet, inTypeInclusionFilter, transformFunc, null);
    }

    public static <In, Out> Set<Out> transformSet(@Nullable Set<In> sourceSet, Func<In, Out> transformFunc, Predicate<Out> outTypeInclusionFilter) {
        return Funcy.transformSet(sourceSet, null, transformFunc, outTypeInclusionFilter);
    }

    public static <In, Out> Set<Out> transformSet(@Nullable Set<In> sourceSet, @Nullable Predicate<In> inTypeInclusionFilter, Func<In, Out> transformFunc, @Nullable Predicate<Out> outTypeInclusionFilter) {
        return (Set)Funcy.transformCollection(sourceSet, inTypeInclusionFilter, transformFunc, outTypeInclusionFilter, setFactory);
    }

    public static <T> List<T> filter(@Nullable List<T> toFilter, Predicate<T> predicate) {
        return (List)Funcy.filterCollection(toFilter, predicate, listFactory);
    }

    public static <T> Set<T> filter(@Nullable Set<T> toFilter, Predicate<T> predicate) {
        return (Set)Funcy.filterCollection(toFilter, predicate, setFactory);
    }

    @Nullable
    public static <T> T findFirstMatch(Collection<T> items, Predicate<T> predicate) {
        for (T item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    private static <In, Out, C extends Collection> Collection<Out> transformCollection(@Nullable Collection<In> source, @Nullable Predicate<In> inTypeInclusionFilter, Func<In, Out> transformFunc, @Nullable Predicate<Out> outTypeInclusionFilter, CollectionFactory<C> collectionFactory) {
        if (source == null || source.isEmpty()) {
            return collectionFactory.emptyCollection();
        }
        C result = collectionFactory.newWithCapacity(source.size());
        for (In fromItem : source) {
            if (inTypeInclusionFilter != null && !inTypeInclusionFilter.test(fromItem)) continue;
            Out transformed = transformFunc.apply(fromItem);
            if (outTypeInclusionFilter != null && !outTypeInclusionFilter.test(transformed)) continue;
            result.add(transformed);
        }
        return result;
    }

    private static <T, C extends Collection> Collection<T> filterCollection(@Nullable Collection<T> toFilter, Predicate<T> predicate, CollectionFactory<C> collectionFactory) {
        if (toFilter == null || toFilter.isEmpty()) {
            return collectionFactory.emptyCollection();
        }
        C result = collectionFactory.newWithCapacity(toFilter.size());
        for (T item : toFilter) {
            if (!predicate.test(item)) continue;
            result.add(item);
        }
        return result;
    }

    private static interface CollectionFactory<C extends Collection> {
        public C newWithCapacity(int var1);

        public C emptyCollection();
    }

    public static interface Func<In, Out> {
        public Out apply(In var1);
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

