/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.util.ArrayMap;
import com.google.gson.Gson;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.DeviceState;
import io.particle.android.sdk.cloud.EventsDelegate;
import io.particle.android.sdk.cloud.ParallelDeviceFetcher;
import io.particle.android.sdk.cloud.ParticleAccessToken;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.cloud.ParticleEventHandler;
import io.particle.android.sdk.cloud.ParticleUser;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SimpleParticleEventHandler;
import io.particle.android.sdk.cloud.models.DeviceStateChange;
import io.particle.android.sdk.cloud.models.SignUpInfo;
import io.particle.android.sdk.persistance.AppDataStorage;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;

@ParametersAreNonnullByDefault
public class ParticleCloud {
    private static final TLog log = TLog.get(ParticleCloud.class);
    private final ApiDefs.CloudApi mainApi;
    private final ApiDefs.IdentityApi identityApi;
    private final ApiDefs.CloudApi deviceFastTimeoutApi;
    private final AppDataStorage appDataStorage;
    private final TokenDelegate tokenDelegate = new TokenDelegate();
    private final LocalBroadcastManager broadcastManager;
    private final EventsDelegate eventsDelegate;
    private final ParallelDeviceFetcher parallelDeviceFetcher;
    private final Map<String, ParticleDevice> devices = new ArrayMap();
    private volatile ParticleAccessToken token;
    private volatile ParticleUser user;
    private static final Funcy.Func<Responses.Models.SimpleDevice, String> toDeviceId = input -> input.id;
    private static Funcy.Func<String, ParticleDevice.VariableType> toVariableType = value -> {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "int32": {
                return ParticleDevice.VariableType.INT;
            }
            case "double": {
                return ParticleDevice.VariableType.DOUBLE;
            }
            case "string": {
                return ParticleDevice.VariableType.STRING;
            }
        }
        return null;
    };

    @Deprecated
    public static synchronized ParticleCloud get(Context context) {
        log.w("ParticleCloud.get() is deprecated and will be removed before the 1.0 release. Use ParticleCloudSDK.getCloud() instead!");
        if (!ParticleCloudSDK.isInitialized()) {
            ParticleCloudSDK.init(context);
        }
        return ParticleCloudSDK.getCloud();
    }

    ParticleCloud(Uri schemeAndHostname, ApiDefs.CloudApi mainApi, ApiDefs.IdentityApi identityApi, ApiDefs.CloudApi perDeviceFastTimeoutApi, AppDataStorage appDataStorage, LocalBroadcastManager broadcastManager, Gson gson, ExecutorService executor) {
        this.mainApi = mainApi;
        this.identityApi = identityApi;
        this.deviceFastTimeoutApi = perDeviceFastTimeoutApi;
        this.appDataStorage = appDataStorage;
        this.broadcastManager = broadcastManager;
        this.user = ParticleUser.fromSavedSession();
        this.token = ParticleAccessToken.fromSavedSession();
        if (this.token != null) {
            this.token.setDelegate(new TokenDelegate());
        }
        this.eventsDelegate = new EventsDelegate(mainApi, schemeAndHostname, gson, executor, this);
        this.parallelDeviceFetcher = ParallelDeviceFetcher.newFetcherUsingExecutor(executor);
    }

    @Nullable
    public String getAccessToken() {
        return this.token == null ? null : this.token.getAccessToken();
    }

    public void setAccessToken(String tokenString) {
        Calendar distantFuture = Calendar.getInstance();
        distantFuture.add(1, 20);
        this.setAccessToken(tokenString, distantFuture.getTime(), null);
    }

    public void setAccessToken(String tokenString, Date expirationDate) {
        this.setAccessToken(tokenString, expirationDate, null);
    }

    public void setAccessToken(String tokenString, Date expirationDate, @Nullable String refreshToken) {
        ParticleAccessToken.removeSession();
        this.token = ParticleAccessToken.fromTokenData(expirationDate, tokenString, refreshToken);
        this.token.setDelegate(this.tokenDelegate);
    }

    @Nullable
    public String getLoggedInUsername() {
        return Py.all(this.token, this.user) ? this.user.getUser() : null;
    }

    public boolean isLoggedIn() {
        return this.getLoggedInUsername() != null;
    }

    @WorkerThread
    public void logIn(String user, String password) throws ParticleCloudException {
        try {
            Responses.LogInResponse response = this.identityApi.logIn("password", user, password);
            this.onLogIn(response, user, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void signUpWithUser(String user, String password) throws ParticleCloudException {
        this.signUpWithUser(new SignUpInfo(user, password));
    }

    @WorkerThread
    public void signUpWithUser(SignUpInfo signUpInfo) throws ParticleCloudException {
        try {
            Response response = this.identityApi.signUp(signUpInfo);
            String bodyString = new String(((TypedByteArray)response.getBody()).getBytes());
            JSONObject obj = new JSONObject(bodyString);
            if (obj.has("ok") && !obj.getBoolean("ok")) {
                JSONArray arrJson = obj.getJSONArray("errors");
                String[] arr = new String[arrJson.length()];
                for (int i = 0; i < arrJson.length(); ++i) {
                    arr[i] = arrJson.getString(i);
                }
                if (arr.length > 0) {
                    throw new ParticleCloudException(new Exception(arr[0]));
                }
            }
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @WorkerThread
    public void signUpAndLogInWithCustomer(String email, String password, Integer productId) throws ParticleCloudException {
        try {
            this.signUpAndLogInWithCustomer(new SignUpInfo(email, password), productId);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void signUpAndLogInWithCustomer(SignUpInfo signUpInfo, Integer productId) throws ParticleCloudException {
        if (!Py.all(signUpInfo.getUsername(), signUpInfo.getPassword(), productId)) {
            throw new IllegalArgumentException("Email, password, and product id must all be specified");
        }
        signUpInfo.setGrantType("client_credentials");
        try {
            Responses.LogInResponse response = this.identityApi.signUpAndLogInWithCustomer(signUpInfo, productId);
            this.onLogIn(response, signUpInfo.getUsername(), signUpInfo.getPassword());
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @Deprecated
    @WorkerThread
    public void signUpAndLogInWithCustomer(String email, String password, String orgSlug) throws ParticleCloudException {
        try {
            log.w("Use product id instead of organization slug.");
            this.signUpAndLogInWithCustomer(new SignUpInfo(email, password), orgSlug);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @Deprecated
    @WorkerThread
    public void signUpAndLogInWithCustomer(SignUpInfo signUpInfo, String orgSlug) throws ParticleCloudException {
        if (!Py.all(signUpInfo.getUsername(), signUpInfo.getPassword(), orgSlug)) {
            throw new IllegalArgumentException("Email, password, and organization must all be specified");
        }
        signUpInfo.setGrantType("client_credentials");
        try {
            Responses.LogInResponse response = this.identityApi.signUpAndLogInWithCustomer(signUpInfo, orgSlug);
            this.onLogIn(response, signUpInfo.getUsername(), signUpInfo.getPassword());
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    public void logOut() {
        if (this.token != null) {
            this.token.cancelExpiration();
        }
        ParticleUser.removeSession();
        ParticleAccessToken.removeSession();
        this.token = null;
        this.user = null;
    }

    @WorkerThread
    public List<ParticleDevice> getDevices() throws ParticleCloudException {
        try {
            List<Responses.Models.SimpleDevice> simpleDevices = this.mainApi.getDevices();
            this.appDataStorage.saveUserHasClaimedDevices(Py.truthy(simpleDevices));
            List<ParticleDevice> result = Py.list();
            for (Responses.Models.SimpleDevice simpleDevice : simpleDevices) {
                ParticleDevice device = simpleDevice.isConnected ? this.getDevice(simpleDevice.id, false) : this.getOfflineDevice(simpleDevice);
                result.add(device);
            }
            this.pruneDeviceMap(simpleDevices);
            return result;
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    List<ParticleDevice> getDevicesParallel(boolean useShortTimeout) throws PartialDeviceListResultException, ParticleCloudException {
        try {
            List<Responses.Models.SimpleDevice> simpleDevices = this.mainApi.getDevices();
            this.appDataStorage.saveUserHasClaimedDevices(Py.truthy(simpleDevices));
            List<Responses.Models.SimpleDevice> offlineDevices = Py.list();
            List<Responses.Models.SimpleDevice> onlineDevices = Py.list();
            for (Responses.Models.SimpleDevice simpleDevice : simpleDevices) {
                List<Object> targetList = simpleDevice.isConnected ? onlineDevices : offlineDevices;
                targetList.add(simpleDevice);
            }
            List<ParticleDevice> result = Py.list();
            for (Responses.Models.SimpleDevice offlineDevice : offlineDevices) {
                result.add(this.getOfflineDevice(offlineDevice));
            }
            ApiDefs.CloudApi cloudApi = useShortTimeout ? this.deviceFastTimeoutApi : this.mainApi;
            int timeoutInSecs = useShortTimeout ? 5 : 35;
            Collection<ParallelDeviceFetcher.DeviceFetchResult> results = this.parallelDeviceFetcher.fetchDevicesInParallel(onlineDevices, cloudApi, timeoutInSecs);
            boolean shouldThrowIncompleteException = false;
            for (ParallelDeviceFetcher.DeviceFetchResult fetchResult : results) {
                if (fetchResult == null || fetchResult.fetchedDevice == null) {
                    shouldThrowIncompleteException = true;
                    continue;
                }
                result.add(this.getDevice(fetchResult.fetchedDevice, false));
            }
            this.pruneDeviceMap(simpleDevices);
            if (shouldThrowIncompleteException) {
                throw new PartialDeviceListResultException(result);
            }
            return result;
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public ParticleDevice getDevice(String deviceID) throws ParticleCloudException {
        return this.getDevice(deviceID, true);
    }

    @WorkerThread
    public void claimDevice(String deviceID) throws ParticleCloudException {
        try {
            this.mainApi.claimDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCode() throws ParticleCloudException {
        try {
            return this.mainApi.generateClaimCode("okhttp_appeasement");
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCode(Integer productId) throws ParticleCloudException {
        try {
            return this.mainApi.generateClaimCodeForOrg("okhttp_appeasement", productId);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @Deprecated
    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCodeForOrg(String organizationSlug, String productSlug) throws ParticleCloudException {
        try {
            log.w("Use product id instead of organization slug.");
            return this.mainApi.generateClaimCodeForOrg("okhttp_appeasement", organizationSlug, productSlug);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void requestPasswordReset(String email) throws ParticleCloudException {
        try {
            this.identityApi.requestPasswordReset(email);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void requestPasswordResetForCustomer(String email, Integer productId) throws ParticleCloudException {
        try {
            this.identityApi.requestPasswordResetForCustomer(email, productId);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @Deprecated
    @WorkerThread
    public void requestPasswordResetForCustomer(String email, String organizationSlug) throws ParticleCloudException {
        try {
            log.w("Use product id instead of organization slug.");
            this.identityApi.requestPasswordResetForCustomer(email, organizationSlug);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void publishEvent(String eventName, String event, int eventVisibility, int timeToLive) throws ParticleCloudException {
        this.eventsDelegate.publishEvent(eventName, event, eventVisibility, timeToLive);
    }

    @WorkerThread
    public long subscribeToAllEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.eventsDelegate.subscribeToAllEvents(eventNamePrefix, handler);
    }

    @WorkerThread
    public long subscribeToMyDevicesEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.eventsDelegate.subscribeToMyDevicesEvents(eventNamePrefix, handler);
    }

    @WorkerThread
    public long subscribeToDeviceEvents(@Nullable String eventNamePrefix, String deviceID, ParticleEventHandler eventHandler) throws IOException {
        return this.eventsDelegate.subscribeToDeviceEvents(eventNamePrefix, deviceID, eventHandler);
    }

    @WorkerThread
    public void unsubscribeFromEventWithID(long eventListenerID) throws ParticleCloudException {
        this.eventsDelegate.unsubscribeFromEventWithID(eventListenerID);
    }

    @WorkerThread
    void unsubscribeFromEventWithHandler(SimpleParticleEventHandler handler) throws ParticleCloudException {
        this.eventsDelegate.unsubscribeFromEventWithHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void unclaimDevice(String deviceId) {
        this.mainApi.unclaimDevice(deviceId);
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            this.devices.remove(deviceId);
        }
        this.sendUpdateBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void rename(String deviceId, String newName) throws ParticleCloudException {
        ParticleDevice particleDevice;
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            particleDevice = this.devices.get(deviceId);
        }
        DeviceState originalDeviceState = particleDevice.deviceState;
        DeviceState stateWithNewName = DeviceState.withNewName(originalDeviceState, newName);
        this.updateDeviceState(stateWithNewName, true);
        try {
            this.mainApi.nameDevice(originalDeviceState.deviceId, newName);
        }
        catch (RetrofitError e) {
            this.updateDeviceState(originalDeviceState, true);
            throw new ParticleCloudException(e);
        }
    }

    @Deprecated
    @WorkerThread
    void changeDeviceName(String deviceId, String newName) throws ParticleCloudException {
        this.rename(deviceId, newName);
    }

    @WorkerThread
    void onDeviceNotConnected(DeviceState deviceState) {
        DeviceState newState = DeviceState.withNewConnectedState(deviceState, false);
        this.updateDeviceState(newState, true);
    }

    void notifyDeviceChanged() {
        this.sendUpdateBroadcast();
    }

    void sendSystemEventBroadcast(DeviceStateChange stateChange) {
        Intent intent = new Intent("BROADCAST_SYSTEM_EVENT");
        intent.putExtra("event", (Parcelable)stateChange);
        this.broadcastManager.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParticleDevice getDeviceFromState(DeviceState deviceState) {
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            if (this.devices.containsKey(deviceState.deviceId)) {
                return this.devices.get(deviceState.deviceId);
            }
            ParticleDevice device = new ParticleDevice(this.mainApi, this, deviceState);
            this.devices.put(deviceState.deviceId, device);
            return device;
        }
    }

    @WorkerThread
    private ParticleDevice getDevice(String deviceID, boolean sendUpdate) throws ParticleCloudException {
        Responses.Models.CompleteDevice deviceCloudModel;
        try {
            deviceCloudModel = this.mainApi.getDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
        return this.getDevice(deviceCloudModel, sendUpdate);
    }

    private ParticleDevice getDevice(Responses.Models.CompleteDevice deviceModel, boolean sendUpdate) {
        DeviceState newDeviceState = this.fromCompleteDevice(deviceModel);
        ParticleDevice device = this.getDeviceFromState(newDeviceState);
        this.updateDeviceState(newDeviceState, sendUpdate);
        return device;
    }

    private ParticleDevice getOfflineDevice(Responses.Models.SimpleDevice offlineDevice) {
        DeviceState newDeviceState = this.fromSimpleDeviceModel(offlineDevice);
        ParticleDevice device = this.getDeviceFromState(newDeviceState);
        this.updateDeviceState(newDeviceState, false);
        return device;
    }

    private void updateDeviceState(DeviceState newState, boolean sendUpdateBroadcast) {
        ParticleDevice device = this.getDeviceFromState(newState);
        device.deviceState = newState;
        if (sendUpdateBroadcast) {
            this.sendUpdateBroadcast();
        }
    }

    private void sendUpdateBroadcast() {
        this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
    }

    private void onLogIn(Responses.LogInResponse response, String user, String password) {
        ParticleAccessToken.removeSession();
        this.token = ParticleAccessToken.fromNewSession(response);
        this.token.setDelegate(this.tokenDelegate);
        this.user = ParticleUser.fromNewCredentials(user, password);
    }

    private DeviceState fromCompleteDevice(Responses.Models.CompleteDevice completeDevice) {
        Py.PySet<String> functions = Py.set(Funcy.filter(completeDevice.functions, Funcy.notNull()));
        Map<String, ParticleDevice.VariableType> variables = ParticleCloud.transformVariables(completeDevice);
        return new DeviceState.DeviceStateBuilder(completeDevice.deviceId, functions, variables).name(completeDevice.name).cellular(completeDevice.cellular).connected(completeDevice.isConnected).version(completeDevice.version).deviceType(ParticleDevice.ParticleDeviceType.fromInt(completeDevice.productId)).platformId(completeDevice.platformId).productId(completeDevice.productId).imei(completeDevice.imei).iccid(completeDevice.lastIccid).currentBuild(completeDevice.currentBuild).defaultBuild(completeDevice.defaultBuild).ipAddress(completeDevice.ipAddress).lastAppName(completeDevice.lastAppName).status(completeDevice.status).requiresUpdate(completeDevice.requiresUpdate).lastHeard(completeDevice.lastHeard).build();
    }

    private DeviceState fromSimpleDeviceModel(Responses.Models.SimpleDevice offlineDevice) {
        HashSet<String> functions = new HashSet<String>();
        ArrayMap variables = new ArrayMap();
        return new DeviceState.DeviceStateBuilder(offlineDevice.id, functions, (Map<String, ParticleDevice.VariableType>)variables).name(offlineDevice.name).cellular(offlineDevice.cellular).connected(offlineDevice.isConnected).version("").deviceType(ParticleDevice.ParticleDeviceType.fromInt(offlineDevice.productId)).platformId(offlineDevice.platformId).productId(offlineDevice.productId).imei(offlineDevice.imei).iccid(offlineDevice.lastIccid).currentBuild(offlineDevice.currentBuild).defaultBuild(offlineDevice.defaultBuild).ipAddress(offlineDevice.ipAddress).lastAppName("").status(offlineDevice.status).requiresUpdate(false).lastHeard(offlineDevice.lastHeard).build();
    }

    private static Map<String, ParticleDevice.VariableType> transformVariables(Responses.Models.CompleteDevice completeDevice) {
        if (completeDevice.variables == null) {
            return Collections.emptyMap();
        }
        ArrayMap variables = new ArrayMap();
        for (Map.Entry<String, String> entry : completeDevice.variables.entrySet()) {
            if (!Py.all(entry.getKey(), entry.getValue())) {
                log.w(String.format("Found null key and/or value for variable in device $1%s.  key=$2%s, value=$3%s", completeDevice.name, entry.getKey(), entry.getValue()));
                continue;
            }
            ParticleDevice.VariableType variableType = toVariableType.apply(entry.getValue());
            if (variableType == null) {
                log.w(String.format("Unknown variable type for device $1%s: '$2%s'", completeDevice.name, entry.getKey()));
                continue;
            }
            variables.put(entry.getKey(), variableType);
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeviceMap(List<Responses.Models.SimpleDevice> latestCloudDeviceList) {
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            Py.PySet<String> currentDeviceIds = Py.set(this.devices.keySet());
            Py.PySet<String> newDeviceIds = Py.set(Funcy.transformList(latestCloudDeviceList, toDeviceId));
            Py.PySet<String> toRemove = currentDeviceIds.getDifference((Collection<String>)newDeviceIds);
            for (String deviceId : toRemove) {
                this.devices.remove(deviceId);
            }
        }
    }

    @WorkerThread
    private void refreshAccessToken(String refreshToken) throws ParticleCloudException {
        try {
            Responses.LogInResponse response = this.identityApi.logIn("refresh_token", refreshToken);
            ParticleAccessToken.removeSession();
            this.token = ParticleAccessToken.fromNewSession(response);
            this.token.setDelegate(this.tokenDelegate);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    public static class PartialDeviceListResultException
    extends Exception {
        final List<ParticleDevice> devices;

        public PartialDeviceListResultException(List<ParticleDevice> devices, Exception cause) {
            super(cause);
            this.devices = devices;
        }

        public PartialDeviceListResultException(List<ParticleDevice> devices, RetrofitError error) {
            super(error);
            this.devices = devices;
        }

        public PartialDeviceListResultException(List<ParticleDevice> devices) {
            super("Undefined error while fetching devices");
            this.devices = devices;
        }
    }

    private class TokenDelegate
    implements ParticleAccessToken.ParticleAccessTokenDelegate {
        private TokenDelegate() {
        }

        @Override
        public void accessTokenExpiredAt(ParticleAccessToken accessToken, Date expirationDate) {
            String refreshToken = accessToken.getRefreshToken();
            if (refreshToken != null) {
                try {
                    ParticleCloud.this.refreshAccessToken(refreshToken);
                    return;
                }
                catch (ParticleCloudException e) {
                    log.e("Error while trying to refresh token: ", e);
                }
            }
            ParticleAccessToken.removeSession();
            ParticleCloud.this.token = null;
        }
    }
}

