/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.ws;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedHandler;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedHandlerImpl;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedChannel;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedHandler;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeChannel;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeHandler;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketCompositeHandler
implements WebSocketHandler {
    private static final String CLASS_NAME = WebSocketCompositeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private WebSocketHandlerListener handlerListener = this.createListener();
    static WebSocketSelectedHandlerImpl.WebSocketSelectedHandlerFactory WEBSOCKET_NATIVE_HANDLER_FACTORY = new WebSocketSelectedHandlerImpl.WebSocketSelectedHandlerFactory(){

        @Override
        public WebSocketSelectedHandler createSelectedHandler() {
            WebSocketSelectedHandlerImpl selectedHandler = new WebSocketSelectedHandlerImpl();
            WebSocketNativeHandler nativeHandler = new WebSocketNativeHandler();
            selectedHandler.setNextHandler(nativeHandler);
            return selectedHandler;
        }
    };
    static WebSocketSelectedHandlerImpl.WebSocketSelectedHandlerFactory WEBSOCKET_EMULATED_HANDLER_FACTORY = new WebSocketSelectedHandlerImpl.WebSocketSelectedHandlerFactory(){

        @Override
        public WebSocketSelectedHandler createSelectedHandler() {
            WebSocketSelectedHandlerImpl selectedHandler = new WebSocketSelectedHandlerImpl();
            WebSocketEmulatedHandler emulatedHandler = new WebSocketEmulatedHandler();
            selectedHandler.setNextHandler(emulatedHandler);
            return selectedHandler;
        }
    };
    private final WebSocketSelectedChannelFactory WEBSOCKET_NATIVE_CHANNEL_FACTORY = new WebSocketSelectedChannelFactory(){

        @Override
        public WebSocketSelectedChannel createChannel(WSURI location) {
            return new WebSocketNativeChannel(location);
        }
    };
    private final WebSocketSelectedChannelFactory WEBSOCKET_EMULATED_CHANNEL_FACTORY = new WebSocketSelectedChannelFactory(){

        @Override
        public WebSocketSelectedChannel createChannel(WSURI location) {
            return new WebSocketEmulatedChannel(location);
        }
    };
    public static final WebSocketCompositeHandler COMPOSITE_HANDLER = new WebSocketCompositeHandler();
    final Map<String, String[]> strategyChoices = new HashMap<String, String[]>();
    final Map<String, WebSocketStrategy> strategyMap = new HashMap<String, WebSocketStrategy>();
    private WebSocketHandlerListener listener;

    public WebSocketCompositeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
        WebSocketSelectedHandler nativeHandler = WEBSOCKET_NATIVE_HANDLER_FACTORY.createSelectedHandler();
        nativeHandler.setListener(this.handlerListener);
        WebSocketSelectedHandler emulatedHandler = WEBSOCKET_EMULATED_HANDLER_FACTORY.createSelectedHandler();
        emulatedHandler.setListener(this.handlerListener);
        this.strategyChoices.put("ws", new String[]{"java:ws", "java:wse"});
        this.strategyChoices.put("wss", new String[]{"java:wss", "java:wse+ssl"});
        this.strategyChoices.put("wsn", new String[]{"java:ws"});
        this.strategyChoices.put("wssn", new String[]{"java:wsn"});
        this.strategyChoices.put("wse", new String[]{"java:wse"});
        this.strategyChoices.put("wse+ssl", new String[]{"java:wse+ssl"});
        this.strategyMap.put("java:ws", new WebSocketStrategy("ws", nativeHandler, this.WEBSOCKET_NATIVE_CHANNEL_FACTORY));
        this.strategyMap.put("java:wss", new WebSocketStrategy("wss", nativeHandler, this.WEBSOCKET_NATIVE_CHANNEL_FACTORY));
        this.strategyMap.put("java:wse", new WebSocketStrategy("ws", emulatedHandler, this.WEBSOCKET_EMULATED_CHANNEL_FACTORY));
        this.strategyMap.put("java:wse+ssl", new WebSocketStrategy("wss", emulatedHandler, this.WEBSOCKET_EMULATED_CHANNEL_FACTORY));
        this.strategyMap.put("java:wsn", new WebSocketStrategy("wss", nativeHandler, this.WEBSOCKET_NATIVE_CHANNEL_FACTORY));
    }

    @Override
    public void processConnect(WebSocketChannel channel, WSURI location, String[] protocols) {
        LOG.entering(CLASS_NAME, "connect", channel);
        WebSocketCompositeChannel compositeChannel = (WebSocketCompositeChannel)channel;
        if (compositeChannel.readyState != ReadyState.CLOSED) {
            LOG.warning("Attempt to reconnect an existing open WebSocket to a different location");
            throw new IllegalStateException("Attempt to reconnect an existing open WebSocket to a different location");
        }
        compositeChannel.readyState = ReadyState.CONNECTING;
        compositeChannel.requestedProtocols = protocols;
        String scheme = compositeChannel.getCompositeScheme();
        if (scheme.indexOf(":") >= 0) {
            WebSocketStrategy strategy = this.strategyMap.get(scheme);
            if (strategy == null) {
                throw new IllegalArgumentException("Invalid connection scheme: " + scheme);
            }
            LOG.finest("Turning off fallback since the URL is prefixed with java:");
            compositeChannel.connectionStrategies.add(scheme);
        } else {
            String[] connectionStrategies = this.strategyChoices.get(scheme);
            if (connectionStrategies != null) {
                for (String each : connectionStrategies) {
                    compositeChannel.connectionStrategies.add(each);
                }
            } else {
                throw new IllegalArgumentException("Invalid connection scheme: " + scheme);
            }
        }
        this.fallbackNext(compositeChannel, null);
    }

    private void fallbackNext(WebSocketCompositeChannel channel, Exception exception) {
        LOG.entering(CLASS_NAME, "fallbackNext");
        try {
            String strategyName = channel.getNextStrategy();
            if (strategyName == null) {
                if (exception == null) {
                    this.doClose(channel, false, 1006, null);
                } else {
                    this.doClose(channel, exception);
                }
            } else {
                this.initDelegate(channel, strategyName);
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void initDelegate(WebSocketCompositeChannel channel, String strategyName) {
        WebSocketSelectedChannel selectedChannel;
        WebSocketStrategy strategy = this.strategyMap.get(strategyName);
        WebSocketSelectedChannelFactory channelFactory = strategy.channelFactory;
        WSURI location = channel.getLocation();
        channel.selectedChannel = selectedChannel = channelFactory.createChannel(location);
        selectedChannel.setParent(channel);
        selectedChannel.handler = (WebSocketSelectedHandler)strategy.handler;
        selectedChannel.requestedProtocols = channel.requestedProtocols;
        selectedChannel.handler.processConnect(channel.selectedChannel, location, channel.requestedProtocols);
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String message) {
        LOG.entering(CLASS_NAME, "send", message);
        WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel;
        if (parent.readyState != ReadyState.OPEN) {
            LOG.warning("Attempt to post message on unopened or closed web socket");
            throw new IllegalStateException("Attempt to post message on unopened or closed web socket");
        }
        WebSocketSelectedChannel selectedChannel = parent.selectedChannel;
        selectedChannel.handler.processTextMessage(selectedChannel, message);
    }

    @Override
    public void processBinaryMessage(WebSocketChannel channel, WrappedByteBuffer message) {
        LOG.entering(CLASS_NAME, "send", message);
        WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel;
        if (parent.readyState != ReadyState.OPEN) {
            LOG.warning("Attempt to post message on unopened or closed web socket");
            throw new IllegalStateException("Attempt to post message on unopened or closed web socket");
        }
        WebSocketSelectedChannel selectedChannel = parent.selectedChannel;
        selectedChannel.handler.processBinaryMessage(selectedChannel, message);
    }

    @Override
    public void processAuthorize(WebSocketChannel channel, String authorizeToken) {
    }

    @Override
    public void setIdleTimeout(WebSocketChannel channel, int timeout) {
    }

    @Override
    public void processClose(WebSocketChannel channel, int code, String reason) {
        LOG.entering(CLASS_NAME, "close");
        WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel;
        if (!parent.closing) {
            parent.closing = true;
            parent.readyState = ReadyState.CLOSING;
            try {
                WebSocketSelectedChannel selectedChannel = parent.selectedChannel;
                selectedChannel.handler.processClose(selectedChannel, code, reason);
            }
            catch (Exception e) {
                this.doClose(parent, false, 1006, e.getMessage());
            }
        }
    }

    private WebSocketHandlerListener createListener() {
        return new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                parent.setProtocol(protocol);
                WebSocketCompositeHandler.this.doOpen(parent);
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                WebSocketCompositeHandler.this.listener.textMessageReceived(parent, message);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                WebSocketCompositeHandler.this.listener.binaryMessageReceived(parent, buf);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                if (parent.readyState == ReadyState.CONNECTING && !channel.authenticationReceived && !channel.preventFallback) {
                    WebSocketCompositeHandler.this.fallbackNext(parent, null);
                } else {
                    WebSocketCompositeHandler.this.doClose(parent, wasClean, code, reason);
                }
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                if (parent.readyState == ReadyState.CONNECTING && !channel.authenticationReceived && !channel.preventFallback) {
                    WebSocketCompositeHandler.this.fallbackNext(parent, ex);
                } else if (ex == null) {
                    WebSocketCompositeHandler.this.doClose(parent, false, 1006, null);
                } else {
                    WebSocketCompositeHandler.this.doClose(parent, ex);
                }
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                if (parent.readyState == ReadyState.CONNECTING && !channel.authenticationReceived && !channel.preventFallback) {
                    WebSocketCompositeHandler.this.fallbackNext(parent, ex);
                } else if (ex == null) {
                    WebSocketCompositeHandler.this.doClose(parent, false, 1006, null);
                } else {
                    WebSocketCompositeHandler.this.doClose(parent, ex);
                }
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
            }
        };
    }

    private void doOpen(WebSocketCompositeChannel channel) {
        if (channel.readyState == ReadyState.CONNECTING) {
            channel.readyState = ReadyState.OPEN;
            this.listener.connectionOpened(channel, channel.getProtocol());
        }
    }

    public void doClose(WebSocketCompositeChannel channel, boolean wasClean, int code, String reason) {
        if (channel.readyState == ReadyState.CONNECTING || channel.readyState == ReadyState.CLOSING || channel.readyState == ReadyState.OPEN) {
            channel.readyState = ReadyState.CLOSED;
            this.listener.connectionClosed(channel, wasClean, code, reason);
        }
    }

    public void doClose(WebSocketCompositeChannel channel, Exception ex) {
        if (channel.readyState == ReadyState.CONNECTING || channel.readyState == ReadyState.CLOSING || channel.readyState == ReadyState.OPEN) {
            channel.readyState = ReadyState.CLOSED;
            this.listener.connectionClosed(channel, ex);
        }
    }

    @Override
    public void setListener(WebSocketHandlerListener listener) {
        this.listener = listener;
    }

    static class WebSocketStrategy {
        String nativeEquivalent;
        WebSocketHandler handler;
        WebSocketSelectedChannelFactory channelFactory;

        WebSocketStrategy(String nativeEquivalent, WebSocketHandler handler, WebSocketSelectedChannelFactory channelFactory) {
            this.nativeEquivalent = nativeEquivalent;
            this.handler = handler;
            this.channelFactory = channelFactory;
        }
    }

    static interface WebSocketSelectedChannelFactory {
        public WebSocketSelectedChannel createChannel(WSURI var1);
    }
}

