/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.persistance.SensitiveDataStorage;
import io.particle.android.sdk.utils.Preconditions;
import io.particle.android.sdk.utils.Py;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ParticleUser {
    private final String user;
    private final String password;

    public static synchronized ParticleUser fromNewCredentials(String user, String password) {
        Preconditions.checkArgument(Py.truthy(user), "Username cannot be empty or null");
        Preconditions.checkArgument(Py.truthy(password), "Password cannot be empty or null");
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.saveUser(user);
        sensitiveDataStorage.savePassword(password);
        return new ParticleUser(user, password);
    }

    public static synchronized ParticleUser fromSavedSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        String user = sensitiveDataStorage.getUser();
        String password = sensitiveDataStorage.getPassword();
        if (Py.truthy(user) && Py.truthy(password)) {
            return new ParticleUser(user, password);
        }
        return null;
    }

    public static void removeSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.resetPassword();
        sensitiveDataStorage.resetUser();
    }

    private ParticleUser(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }
}

