/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketMessageWriter;
import org.kaazing.net.ws.impl.WebSocketImpl;

public class WsMessageWriterImpl
extends WebSocketMessageWriter {
    private WebSocketImpl _webSocket;
    private boolean _closed = false;

    public WsMessageWriterImpl(WebSocketImpl webSocket) {
        this._webSocket = webSocket;
    }

    @Override
    public void writeText(CharSequence src) throws IOException {
        if (this.isClosed()) {
            String s = "Cannot write as the MessageWriter is closed";
            throw new WebSocketException(s);
        }
        try {
            src.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String s = "The platform must support UTF-8 encoded text per RFC 6455";
            throw new IOException(s);
        }
        this._webSocket.send(src.toString());
    }

    @Override
    public void writeBinary(ByteBuffer src) throws IOException {
        if (this.isClosed()) {
            String s = "Cannot write as the MessageWriter is closed";
            throw new WebSocketException(s);
        }
        this._webSocket.send(src);
    }

    public void close() {
        this._closed = true;
        this._webSocket = null;
    }

    public boolean isClosed() {
        return this._closed;
    }
}

