/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl.url;

import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.kaazing.net.URLStreamHandlerFactorySpi;
import org.kaazing.net.sse.impl.url.SseURLStreamHandlerImpl;

public class SseURLStreamHandlerFactorySpiImpl
extends URLStreamHandlerFactorySpi {
    private static final Collection<String> _supportedProtocols = Collections.unmodifiableList(Arrays.asList("sse"));

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (!_supportedProtocols.contains(protocol)) {
            String s = String.format("Protocol not supported '%s'", protocol);
            throw new IllegalArgumentException(s);
        }
        return new SseURLStreamHandlerImpl(protocol);
    }

    @Override
    public Collection<String> getSupportedProtocols() {
        return _supportedProtocols;
    }
}

