/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wseb;

import org.kaazing.gateway.client.impl.EncoderOutput;
import org.kaazing.gateway.client.impl.util.WebSocketUtil;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedEncoder;
import org.kaazing.gateway.client.util.StringUtils;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketEmulatedEncoderImpl<C>
implements WebSocketEmulatedEncoder<C> {
    private static final byte WS_BINARY_FRAME_START = -128;
    private static final byte WS_SPECIFIED_LENGTH_TEXT_FRAME_START = -127;

    @Override
    public void encodeBinaryMessage(C channel, WrappedByteBuffer message, EncoderOutput<C> out) {
        int length = message.remaining();
        WrappedByteBuffer frame = WrappedByteBuffer.allocate(length + 6);
        frame.put((byte)-128);
        WebSocketUtil.encodeLength(frame, length);
        frame.putBuffer(message.duplicate());
        frame.flip();
        out.write(channel, frame);
    }

    @Override
    public void encodeTextMessage(C channel, String message, EncoderOutput<C> out) {
        byte[] payload = StringUtils.getUtf8Bytes(message);
        int length = payload.length;
        WrappedByteBuffer frame = WrappedByteBuffer.allocate(length + 6);
        frame.put((byte)-127);
        WebSocketUtil.encodeLength(frame, length);
        frame.putBytes(payload);
        frame.flip();
        out.write(channel, frame);
    }
}

