/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.persistance;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Date;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SensitiveDataStorage {
    private static final String KEY_USERNAME = "KEY_USERNAME";
    private static final String KEY_PASSWORD = "KEY_PASSWORD";
    private static final String KEY_TOKEN = "KEY_TOKEN";
    private static final String KEY_TOKEN_EXPIRATION_DATE = "KEY_TOKEN_EXPIRATION_DATE";
    private static final String KEY_REFRESH_TOKEN = "KEY_REFRESH_TOKEN";
    private final SharedPreferences sharedPrefs;

    public SensitiveDataStorage(Context ctx) {
        ctx = ctx.getApplicationContext();
        this.sharedPrefs = ctx.getSharedPreferences("spark_sdk_sensitive_data", 0);
    }

    public void saveUser(String user) {
        this.sharedPrefs.edit().putString(KEY_USERNAME, user).apply();
    }

    public String getUser() {
        return this.sharedPrefs.getString(KEY_USERNAME, null);
    }

    public void resetUser() {
        this.sharedPrefs.edit().remove(KEY_USERNAME).apply();
    }

    public void savePassword(String password) {
        this.sharedPrefs.edit().putString(KEY_PASSWORD, password).apply();
    }

    public String getPassword() {
        return this.sharedPrefs.getString(KEY_PASSWORD, null);
    }

    public void resetPassword() {
        this.sharedPrefs.edit().remove(KEY_PASSWORD).apply();
    }

    public void saveToken(String token) {
        this.sharedPrefs.edit().putString(KEY_TOKEN, token).apply();
    }

    public String getToken() {
        return this.sharedPrefs.getString(KEY_TOKEN, null);
    }

    public void resetToken() {
        this.sharedPrefs.edit().remove(KEY_TOKEN).apply();
    }

    public void resetRefreshToken() {
        this.sharedPrefs.edit().remove(KEY_REFRESH_TOKEN).apply();
    }

    public void saveRefreshToken(@Nullable String token) {
        this.sharedPrefs.edit().putString(KEY_REFRESH_TOKEN, token).apply();
    }

    @Nullable
    public String getRefreshToken() {
        return this.sharedPrefs.getString(KEY_REFRESH_TOKEN, null);
    }

    public void saveTokenExpirationDate(Date expirationDate) {
        this.sharedPrefs.edit().putLong(KEY_TOKEN_EXPIRATION_DATE, expirationDate.getTime()).apply();
    }

    public Date getTokenExpirationDate() {
        long expirationTs = this.sharedPrefs.getLong(KEY_TOKEN_EXPIRATION_DATE, -1L);
        return expirationTs == -1L ? null : new Date(expirationTs);
    }

    public void resetTokenExpirationDate() {
        this.sharedPrefs.edit().remove(KEY_TOKEN_EXPIRATION_DATE).apply();
    }
}

