/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketMessageType;
import org.kaazing.net.ws.impl.io.WsMessageReaderAdapter;

public class WsInputStreamImpl
extends InputStream {
    private WsMessageReaderAdapter _adapter;
    private WrappedByteBuffer _buffer;
    private boolean _closed = false;

    public WsInputStreamImpl(WsMessageReaderAdapter adapter) throws IOException {
        this._adapter = adapter;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkStreamClosed();
        if (this._buffer == null) {
            return 0;
        }
        return this._buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this._closed) {
            return;
        }
        if (this._buffer != null) {
            this._buffer.clear();
        }
        this._buffer = null;
        this._closed = true;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkStreamClosed();
        try {
            this.prepareBuffer();
        }
        catch (IOException ex) {
            WebSocketMessageType type = this._adapter.getType();
            if (type == WebSocketMessageType.EOS || type == null) {
                return -1;
            }
            String s = "InvalidMessageType: InputStream must be used to only receive binary messages";
            throw new WebSocketException(s, ex);
        }
        return this._buffer.get();
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkStreamClosed();
        try {
            this.prepareBuffer();
        }
        catch (IOException ex) {
            WebSocketMessageType type = this._adapter.getType();
            if (type == WebSocketMessageType.EOS || type == null) {
                return -1;
            }
            String s = "InvalidMessageType: InputStream must be used to only receive binary messages";
            throw new WebSocketException(s, ex);
        }
        int remaining = this._buffer.remaining();
        int retval = remaining < len ? remaining : len;
        this._buffer.get(b, off, retval);
        return retval;
    }

    @Override
    public void reset() throws IOException {
        this.checkStreamClosed();
        this._buffer.clear();
        this._buffer = null;
    }

    public boolean isClosed() {
        return this._closed;
    }

    private void checkStreamClosed() throws IOException {
        if (!this._closed) {
            return;
        }
        String s = "Cannot perform the operation as the InputStream is closed";
        throw new WebSocketException(s);
    }

    private void prepareBuffer() throws IOException {
        if (this._buffer == null || !this._buffer.hasRemaining()) {
            ByteBuffer byteBuf = this._adapter.readBinary();
            if (this._buffer == null) {
                this._buffer = new WrappedByteBuffer(byteBuf);
            } else {
                int pos = this._buffer.position();
                int remaining = byteBuf.remaining();
                byte[] bytes = new byte[remaining];
                byteBuf.get(bytes);
                this._buffer.putBytes(bytes);
                this._buffer.limit(this._buffer.position());
                this._buffer.position(pos);
            }
        }
    }
}

