/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl;

import io.particle.android.sdk.cloud.ParticleCloud;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestAuthenticationHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandlerFactory;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestRedirectHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestTransportHandler;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.sse.impl.AuthenticatedSseEventStream$$Lambda$1;
import org.kaazing.net.sse.impl.SseEventStream;
import org.kaazing.net.sse.impl.SseEventStreamListener;

public class AuthenticatedSseEventStream
extends SseEventStream {
    private static final String MESSAGE = "message";
    private static final String CLASS_NAME = AuthenticatedSseEventStream.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final StringBuffer dataBuffer = new StringBuffer();
    private static final transient Timer timer = new Timer("reconnect", true);
    static final HttpRequestHandlerFactory SSE_HANDLER_FACTORY = AuthenticatedSseEventStream$$Lambda$1.lambdaFactory$();
    private ReadyState readyState = ReadyState.CONNECTING;
    private String lastEventId = "";
    private boolean aborted = false;
    private boolean errored = false;
    private String sseLocation;
    private long retry = 3000L;
    private boolean immediateReconnect = false;
    private String messageBuffer = "";
    private HttpRequest sseSource;
    private AtomicBoolean progressEventReceived = new AtomicBoolean(false);
    private AtomicBoolean reconnected = new AtomicBoolean(false);
    private HttpRequestHandler sseHandler;
    private SseEventStreamListener listener;
    private final ParticleCloud cloud;
    private String name = "message";

    public AuthenticatedSseEventStream(String sseLoc, ParticleCloud cloud) throws IOException {
        super(sseLoc);
        LOG.entering(CLASS_NAME, "<init>", sseLoc);
        this.cloud = cloud;
        URI.create(sseLoc);
        this.sseLocation = sseLoc;
        this.sseHandler = SSE_HANDLER_FACTORY.createHandler();
        this.sseHandler.setListener(new EventStreamHttpRequestListener());
    }

    @Override
    public ReadyState getReadyState() {
        return this.readyState;
    }

    @Override
    public void stop() {
        LOG.entering(CLASS_NAME, "stop");
        this.readyState = ReadyState.CLOSED;
        this.sseHandler.processAbort(this.sseSource);
        this.aborted = true;
    }

    @Override
    public void connect() throws IOException {
        LOG.entering(CLASS_NAME, "connect");
        if (this.lastEventId != null && this.lastEventId.length() > 0) {
            this.sseLocation = this.sseLocation + (!this.sseLocation.contains("?") ? "?" : "&") + ".ka=" + this.lastEventId;
        }
        try {
            HttpURI uri = new HttpURI(this.sseLocation);
            this.sseSource = new HttpRequest(HttpRequest.Method.GET, uri, true);
            this.sseSource.setHeader("Authorization", "Bearer " + this.cloud.getAccessToken());
            this.sseHandler.processOpen(this.sseSource);
            if (!this.reconnected.get()) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                    }
                };
                Timer timer = new Timer();
                timer.schedule(timerTask, 3000L);
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            this.doError(e);
        }
    }

    @Override
    public long getRetryTimeout() {
        return this.retry;
    }

    @Override
    public void setRetryTimeout(long millis) {
        this.retry = millis;
    }

    private synchronized void reconnect() {
        LOG.entering(CLASS_NAME, "reconnect");
        if (this.readyState != ReadyState.CLOSED) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        AuthenticatedSseEventStream.this.connect();
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                }
            };
            timer.schedule(task, this.retry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processProgressEvent(String message) {
        LOG.entering(CLASS_NAME, "processProgressEvent", message);
        try {
            String line;
            this.messageBuffer = this.messageBuffer + message;
            this.immediateReconnect = false;
            while (!this.aborted && !this.errored && (line = this.fetchLineFromBuffer()) != null) {
                String value;
                String field;
                int colonAt;
                if (line.length() == 0 && this.dataBuffer.length() > 0) {
                    StringBuffer stringBuffer = this.dataBuffer;
                    synchronized (stringBuffer) {
                        int dataBufferlength = this.dataBuffer.length();
                        if (this.dataBuffer.charAt(dataBufferlength - 1) == '\n') {
                            this.dataBuffer.replace(dataBufferlength - 1, dataBufferlength, "");
                        }
                        this.doMessage(this.name, this.dataBuffer.toString());
                        this.dataBuffer.setLength(0);
                    }
                }
                if ((colonAt = line.indexOf(58)) == -1) {
                    field = line;
                    value = "";
                } else {
                    if (colonAt == 0) continue;
                    field = line.substring(0, colonAt);
                    int valueAt = colonAt + 1;
                    if (line.length() > valueAt && line.charAt(valueAt) == ' ') {
                        ++valueAt;
                    }
                    value = line.substring(valueAt);
                }
                String string2 = field;
                int n = -1;
                switch (string2.hashCode()) {
                    case 96891546: {
                        if (!string2.equals("event")) break;
                        n = 0;
                        break;
                    }
                    case 3355: {
                        if (!string2.equals("id")) break;
                        n = 1;
                        break;
                    }
                    case 108405416: {
                        if (!string2.equals("retry")) break;
                        n = 2;
                        break;
                    }
                    case 3076010: {
                        if (!string2.equals("data")) break;
                        n = 3;
                        break;
                    }
                    case 1901043637: {
                        if (!string2.equals("location")) break;
                        n = 4;
                        break;
                    }
                    case 990157655: {
                        if (!string2.equals("reconnect")) break;
                        n = 5;
                    }
                }
                switch (n) {
                    case 0: {
                        this.name = value;
                        break;
                    }
                    case 1: {
                        this.lastEventId = value;
                        break;
                    }
                    case 2: {
                        this.retry = Integer.parseInt(value);
                        break;
                    }
                    case 3: {
                        if (this.name == null || this.name.length() <= 0 || MESSAGE.equals(this.name)) break;
                        this.dataBuffer.append(value).append("\n");
                        break;
                    }
                    case 4: {
                        if (value.length() <= 0) break;
                        this.sseLocation = value;
                        break;
                    }
                    case 5: {
                        this.immediateReconnect = true;
                    }
                }
            }
            if (this.immediateReconnect) {
                this.retry = 0L;
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            this.doError(e);
        }
    }

    private String fetchLineFromBuffer() {
        LOG.entering(CLASS_NAME, "fetchLineFromBuffer");
        int lf = this.messageBuffer.indexOf("\n");
        if (lf == -1) {
            lf = this.messageBuffer.indexOf("\r");
        }
        if (lf != -1) {
            String ret = this.messageBuffer.substring(0, lf);
            this.messageBuffer = this.messageBuffer.substring(lf + 1);
            return ret;
        }
        return null;
    }

    private void doOpen() {
        if (this.readyState == ReadyState.CONNECTING) {
            this.readyState = ReadyState.OPEN;
            this.listener.streamOpened();
        }
    }

    private void doMessage(String eventName, String data) {
        if (this.getReadyState() != ReadyState.OPEN) {
            LOG.log(Level.INFO, "event message discarded " + this.getReadyState().name());
            return;
        }
        this.listener.messageReceived(eventName, data);
    }

    private void doError(Exception exception) {
        if (this.getReadyState() == ReadyState.CLOSED) {
            LOG.log(Level.INFO, "event error discarded " + this.getReadyState().name());
            return;
        }
        this.errored = true;
        this.listener.streamErrored(exception);
    }

    @Override
    public void setListener(SseEventStreamListener listener) {
        this.listener = listener;
    }

    static /* synthetic */ HttpRequestHandler lambda$static$0() {
        HttpRequestAuthenticationHandler authHandler = new HttpRequestAuthenticationHandler();
        HttpRequestRedirectHandler redirectHandler = new HttpRequestRedirectHandler();
        HttpRequestHandler transportHandler = HttpRequestTransportHandler.DEFAULT_FACTORY.createHandler();
        authHandler.setNextHandler(redirectHandler);
        redirectHandler.setNextHandler(transportHandler);
        return authHandler;
    }

    private class EventStreamHttpRequestListener
    implements HttpRequestListener {
        private final String CLASS_NAME = EventStreamHttpRequestListener.class.getName();
        private final Logger LOG = Logger.getLogger(this.CLASS_NAME);
        boolean reconnectScheduled = false;

        EventStreamHttpRequestListener() {
            this.LOG.entering(this.CLASS_NAME, "<init>");
        }

        @Override
        public void requestReady(HttpRequest request) {
        }

        @Override
        public void requestOpened(HttpRequest request) {
            AuthenticatedSseEventStream.this.doOpen();
        }

        @Override
        public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
            AuthenticatedSseEventStream.this.progressEventReceived.set(true);
            String response = payload.getString(UTF_8);
            AuthenticatedSseEventStream.this.processProgressEvent(response);
        }

        @Override
        public void requestLoaded(HttpRequest request, HttpResponse response) {
            if (AuthenticatedSseEventStream.this.readyState != ReadyState.CLOSED && AuthenticatedSseEventStream.this.immediateReconnect) {
                AuthenticatedSseEventStream.this.retry = 0L;
                if (!this.reconnectScheduled) {
                    AuthenticatedSseEventStream.this.reconnect();
                }
            }
        }

        @Override
        public void requestAborted(HttpRequest request) {
        }

        @Override
        public void requestClosed(HttpRequest request) {
        }

        @Override
        public void errorOccurred(HttpRequest request, Exception exception) {
            AuthenticatedSseEventStream.this.doError(exception);
        }
    }
}

