/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocketFactory;
import org.kaazing.gateway.client.transport.ws.BridgeSocket;

class BridgeSocketImpl
implements BridgeSocket {
    boolean secure;
    Socket socket;

    BridgeSocketImpl(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void connect(InetSocketAddress inetSocketAddress, long timeout) throws IOException {
        this.socket = this.secure ? SSLSocketFactory.getDefault().createSocket() : new Socket();
        assert (timeout >= 0L);
        this.socket.connect(inetSocketAddress, (int)timeout);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setKeepAlive(boolean val) throws SocketException {
        this.socket.setKeepAlive(val);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }
}

