/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wsn;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedChannel;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketNativeHandshakeHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeHandshakeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final byte[] GET_BYTES = "GET".getBytes();
    private static final byte[] HTTP_1_1_BYTES = "HTTP/1.1".getBytes();
    private static final byte[] COLON_BYTES = ":".getBytes();
    private static final byte[] SPACE_BYTES = " ".getBytes();
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_PROTOCOL = "WebSocket-Protocol";
    private static final String HEADER_SEC_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final String HEADER_SEC_EXTENSIONS = "Sec-WebSocket-Extensions";

    @Override
    public void processConnect(WebSocketChannel channel, WSURI uri, String[] protocols) {
        String[] nextProtocols;
        LOG.entering(CLASS_NAME, "connect", new Object[]{uri, protocols});
        if (protocols == null || protocols.length == 0) {
            nextProtocols = new String[]{"x-kaazing-handshake"};
        } else {
            nextProtocols = new String[protocols.length + 1];
            nextProtocols[0] = "x-kaazing-handshake";
            for (int i = 0; i < protocols.length; ++i) {
                nextProtocols[i + 1] = protocols[i];
            }
        }
        this.nextHandler.processConnect(channel, uri, nextProtocols);
    }

    @Override
    public void processAuthorize(WebSocketChannel channel, String authorizeToken) {
        this.sendHandshakePayload(channel, authorizeToken);
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        super.setNextHandler(handler);
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String supportProtocol) {
                if ("x-kaazing-handshake".equals(supportProtocol)) {
                    WebSocketNativeHandshakeHandler.this.sendHandshakePayload(channel, null);
                } else {
                    WebSocketNativeHandshakeHandler.this.listener.connectionOpened(channel, channel.getProtocol());
                }
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeHandshakeHandler.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeHandshakeHandler.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
                WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
                if (selectedChannel.getReadyState() == ReadyState.OPEN) {
                    WebSocketNativeHandshakeHandler.this.listener.binaryMessageReceived(channel, buf);
                } else {
                    WebSocketNativeHandshakeHandler.this.handleHandshakeMessage(channel, buf);
                }
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketNativeHandshakeHandler.this.listener.textMessageReceived(channel, message);
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
                WebSocketNativeHandshakeHandler.this.listener.commandMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketNativeHandshakeHandler.this.listener.connectionClosed(channel, wasClean, code, reason);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeHandshakeHandler.this.listener.connectionClosed(channel, ex);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeHandshakeHandler.this.listener.connectionClosed(channel, false, 0, null);
            }
        });
    }

    protected static String[] getLines(String payload) {
        ArrayList<String> lineList = new ArrayList<String>();
        int i = 0;
        while (i < payload.length()) {
            int endOfLine = payload.indexOf(13, i);
            if (endOfLine >= 0) {
                if (payload.charAt(endOfLine + 1) != '\n') {
                    throw new IllegalArgumentException("Invalid payload");
                }
            } else {
                endOfLine = payload.length();
            }
            String nextLine = payload.substring(i, endOfLine);
            lineList.add(nextLine);
            i = endOfLine + 2;
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    private void handleHandshakeMessage(WebSocketChannel channel, WrappedByteBuffer buf) {
        String s = buf.getString(Charset.forName("UTF-8"));
        this.handleHandshakeMessage(channel, s);
    }

    private void handleHandshakeMessage(WebSocketChannel channel, String message) {
        channel.handshakePayload.append(message);
        if (message.length() > 0) {
            return;
        }
        String[] lines = WebSocketNativeHandshakeHandler.getLines(channel.handshakePayload.toString());
        channel.handshakePayload.setLength(0);
        String httpCode = "";
        for (int i = lines.length - 1; i >= 0; --i) {
            if (!lines[i].startsWith("HTTP/1.1")) continue;
            String[] temp = lines[i].split(" ");
            httpCode = temp[1];
            break;
        }
        if ("101".equals(httpCode)) {
            String extensionsHeader = "";
            String negotiatedextensions = "";
            for (String line : lines) {
                if (line != null && line.startsWith(HEADER_SEC_PROTOCOL)) {
                    String protocol = line.substring(HEADER_SEC_PROTOCOL.length() + 1).trim();
                    channel.setProtocol(protocol);
                }
                if (line == null || !line.startsWith(HEADER_SEC_EXTENSIONS)) continue;
                extensionsHeader = extensionsHeader + (extensionsHeader == "" ? "" : ",") + line.substring(HEADER_SEC_EXTENSIONS.length() + 1).trim();
            }
            if (extensionsHeader.length() > 0) {
                String[] extensions;
                for (String extension : extensions = extensionsHeader.split(",")) {
                    String[] tmp = extension.split(";");
                    String extName = tmp[0].trim();
                    if (extName.equals("x-kaazing-idle-timeout")) {
                        try {
                            int timeout = Integer.parseInt(tmp[1].trim().substring(8));
                            if (timeout <= 0) continue;
                            this.nextHandler.setIdleTimeout(channel, timeout);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Cannot find timeout parameter in x-kaazing-idle-timeout extension: " + extension);
                        }
                    }
                    negotiatedextensions = negotiatedextensions + (negotiatedextensions == "" ? extension : "," + extension);
                }
                if (negotiatedextensions.length() > 0) {
                    channel.setNegotiatedExtensions(negotiatedextensions);
                }
            }
        } else if ("401".equals(httpCode)) {
            String challenge = "";
            for (String line : lines) {
                if (!line.startsWith(HEADER_WWW_AUTHENTICATE)) continue;
                challenge = line.substring(HEADER_WWW_AUTHENTICATE.length() + 1).trim();
                break;
            }
            this.listener.authenticationRequested(channel, channel.getLocation().toString(), challenge);
        } else {
            this.listener.connectionFailed(channel, new IllegalStateException("Error during handshake. HTTP Status Code: " + httpCode));
        }
    }

    private void sendHandshakePayload(WebSocketChannel channel, String authToken) {
        String[] headerNames = new String[4];
        String[] headerValues = new String[4];
        headerNames[0] = HEADER_PROTOCOL;
        headerValues[0] = null;
        headerNames[1] = HEADER_SEC_PROTOCOL;
        headerValues[1] = channel.getProtocol();
        headerNames[2] = HEADER_SEC_EXTENSIONS;
        headerValues[2] = "x-kaazing-idle-timeout";
        String enabledExtensions = ((WebSocketCompositeChannel)channel.getParent()).getEnabledExtensions();
        if (enabledExtensions != null && enabledExtensions.trim().length() != 0) {
            headerValues[2] = headerValues[2] + "," + enabledExtensions;
        }
        headerNames[3] = HEADER_AUTHORIZATION;
        headerValues[3] = authToken;
        byte[] payload = this.encodeGetRequest(channel.getLocation().getURI(), headerNames, headerValues);
        this.nextHandler.processBinaryMessage(channel, new WrappedByteBuffer(payload));
    }

    private byte[] encodeGetRequest(URI requestURI, String[] names, String[] values) {
        LOG.entering(CLASS_NAME, "encodeGetRequest", new Object[]{requestURI, names, values});
        int requestSize = this.getEncodeRequestSize(requestURI, names, values);
        ByteBuffer buf = ByteBuffer.allocate(requestSize);
        buf.put(GET_BYTES);
        buf.put(SPACE_BYTES);
        String path = requestURI.getPath();
        if (path.length() == 0) {
            path = "/";
        }
        if (requestURI.getQuery() != null) {
            path = path + "?" + requestURI.getQuery();
        }
        buf.put(path.getBytes());
        buf.put(SPACE_BYTES);
        buf.put(HTTP_1_1_BYTES);
        buf.put(CRLF_BYTES);
        for (int i = 0; i < names.length; ++i) {
            String headerName = names[i];
            String headerValue = values[i];
            if (headerName == null || headerValue == null) continue;
            buf.put(headerName.getBytes());
            buf.put(COLON_BYTES);
            buf.put(SPACE_BYTES);
            buf.put(headerValue.getBytes());
            buf.put(CRLF_BYTES);
        }
        buf.put(CRLF_BYTES);
        buf.flip();
        return buf.array();
    }

    private int getEncodeRequestSize(URI requestURI, String[] names, String[] values) {
        int size = 0;
        size += GET_BYTES.length;
        size += SPACE_BYTES.length;
        String path = requestURI.getPath();
        if (path.length() == 0) {
            path = "/";
        }
        if (requestURI.getQuery() != null) {
            path = path + "?" + requestURI.getQuery();
        }
        size += path.getBytes().length;
        size += SPACE_BYTES.length;
        size += HTTP_1_1_BYTES.length;
        size += CRLF_BYTES.length;
        for (int i = 0; i < names.length; ++i) {
            String headerName = names[i];
            String headerValue = values[i];
            if (headerName == null || headerValue == null) continue;
            size += headerName.getBytes().length;
            size += COLON_BYTES.length;
            size += SPACE_BYTES.length;
            size += headerValue.getBytes().length;
            size += CRLF_BYTES.length;
        }
        LOG.fine("Returning a request size of " + (size += CRLF_BYTES.length));
        return size;
    }
}

