/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.kaazing.gateway.client.util.GenericURI;
import org.kaazing.gateway.client.util.URIUtils;

public class WSURI
extends GenericURI<WSURI> {
    @Override
    protected boolean isValidScheme(String scheme) {
        return "ws".equals(scheme) || "wss".equals(scheme);
    }

    public WSURI(String location) throws URISyntaxException {
        this(new URI(location));
    }

    public WSURI(URI location) throws URISyntaxException {
        super(location);
    }

    @Override
    protected WSURI duplicate(URI uri) {
        try {
            return new WSURI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static WSURI replaceScheme(URI uri, String scheme) throws URISyntaxException {
        URI wsUri = URIUtils.replaceScheme(uri, scheme);
        return new WSURI(wsUri);
    }

    public boolean isSecure() {
        String scheme = this.getScheme();
        return "wss".equals(scheme);
    }

    public String getHttpEquivalentScheme() {
        return this.uri.getScheme().equals("ws") ? "http" : "https";
    }
}

