/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketMessageWriter;
import org.kaazing.net.ws.impl.io.WsMessageWriterImpl;

public class WsWriterImpl
extends Writer {
    private WsMessageWriterImpl _writer;
    private StringBuffer _stringBuffer;
    private boolean _closed;

    public WsWriterImpl(WebSocketMessageWriter writer) {
        this._writer = (WsMessageWriterImpl)writer;
        this._stringBuffer = new StringBuffer("");
        this._closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        WsWriterImpl wsWriterImpl = this;
        synchronized (wsWriterImpl) {
            if (this.isClosed()) {
                return;
            }
            this._closed = true;
            this._stringBuffer = null;
            this._writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int offset, int length) throws IOException {
        if (cbuf == null) {
            throw new IllegalArgumentException("Null char array passed to write()");
        }
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (offset > cbuf.length - length) {
            throw new StringIndexOutOfBoundsException(offset + length);
        }
        WsWriterImpl wsWriterImpl = this;
        synchronized (wsWriterImpl) {
            this._checkWriterClosed();
            this._stringBuffer.append(cbuf, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        WsWriterImpl wsWriterImpl = this;
        synchronized (wsWriterImpl) {
            this._checkWriterClosed();
            if (this._stringBuffer.length() > 0) {
                try {
                    this._stringBuffer.toString().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    String s = "The platform must support UTF-8 encoded text per RFC 6455";
                    throw new IOException(s);
                }
                this._writer.writeText(this._stringBuffer.toString());
            }
            this._stringBuffer = new StringBuffer("");
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    private void _checkWriterClosed() throws IOException {
        String s = "Cannot perform the operation on the Writer as it is closed";
        if (this._closed) {
            throw new WebSocketException(s);
        }
    }
}

