/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.util.WSCompositeURI;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeHandler;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedChannel;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.http.HttpRedirectPolicy;
import org.kaazing.net.impl.util.BlockingQueueImpl;
import org.kaazing.net.impl.util.ResumableTimer;
import org.kaazing.net.ws.WebSocket;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketExtension;
import org.kaazing.net.ws.WebSocketMessageReader;
import org.kaazing.net.ws.WebSocketMessageWriter;
import org.kaazing.net.ws.impl.WsExtensionParameterValuesSpiImpl;
import org.kaazing.net.ws.impl.io.WsInputStreamImpl;
import org.kaazing.net.ws.impl.io.WsMessageReaderAdapter;
import org.kaazing.net.ws.impl.io.WsMessageReaderImpl;
import org.kaazing.net.ws.impl.io.WsMessageWriterImpl;
import org.kaazing.net.ws.impl.io.WsOutputStreamImpl;
import org.kaazing.net.ws.impl.io.WsReaderImpl;
import org.kaazing.net.ws.impl.io.WsWriterImpl;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionFactorySpi;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionHandlerSpi;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionParameterValuesSpi;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionSpi;

public class WebSocketImpl
extends WebSocket {
    private static final String _CLASS_NAME = WebSocketImpl.class.getName();
    private static final Logger _LOG = Logger.getLogger(_CLASS_NAME);
    private final Map<String, WsExtensionParameterValuesSpiImpl> _enabledParameters;
    private final Map<String, WsExtensionParameterValuesSpiImpl> _negotiatedParameters;
    private final Map<String, WebSocketExtensionFactorySpi> _extensionFactories;
    private final WSURI _location;
    private final WebSocketCompositeHandler _handler;
    private final WebSocketCompositeChannel _channel;
    private Collection<String> _enabledExtensions;
    private Collection<String> _negotiatedExtensions;
    private Collection<String> _supportedExtensions;
    private Collection<String> _enabledProtocols;
    private String _negotiatedProtocol;
    private WsInputStreamImpl _inputStream;
    private WsOutputStreamImpl _outputStream;
    private WsReaderImpl _reader;
    private WsWriterImpl _writer;
    private WsMessageReaderImpl _messageReader;
    private WsMessageWriterImpl _messageWriter;
    private BlockingQueueImpl<Object> _sharedQueue;
    private HttpRedirectPolicy _followRedirect;
    private ChallengeHandler _challengeHandler;
    private int _connectTimeout = 0;
    private ReadyState _readyState;
    private Exception _exception;
    private static final WebSocketHandlerListener handlerListener = new WebSocketHandlerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionOpened(WebSocketChannel channel, String protocol) {
            _LOG.entering(_CLASS_NAME, "connectionOpened");
            WebSocketCompositeChannel cc = (WebSocketCompositeChannel)channel;
            WebSocketImpl webSocket = (WebSocketImpl)cc.getWebSocket();
            WebSocketSelectedChannel selChan = ((WebSocketCompositeChannel)channel).selectedChannel;
            WebSocketImpl webSocketImpl = webSocket;
            synchronized (webSocketImpl) {
                webSocket.connectionOpened(protocol, selChan.getNegotiatedExtensions());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
            WebSocketImpl webSocket;
            _LOG.entering(_CLASS_NAME, "binaryMessageReceived");
            WebSocketCompositeChannel cc = (WebSocketCompositeChannel)channel;
            WebSocketImpl webSocketImpl = webSocket = (WebSocketImpl)cc.getWebSocket();
            synchronized (webSocketImpl) {
                BlockingQueueImpl sharedQueue = webSocket.getSharedQueue();
                if (sharedQueue != null) {
                    BlockingQueueImpl blockingQueueImpl = sharedQueue;
                    synchronized (blockingQueueImpl) {
                        try {
                            ByteBuffer payload = buf.getNioByteBuffer();
                            sharedQueue.put(payload);
                        }
                        catch (InterruptedException ex) {
                            _LOG.log(Level.INFO, ex.getMessage(), ex);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textMessageReceived(WebSocketChannel channel, String text) {
            WebSocketImpl webSocket;
            _LOG.entering(_CLASS_NAME, "textMessageReceived", text);
            WebSocketCompositeChannel cc = (WebSocketCompositeChannel)channel;
            WebSocketImpl webSocketImpl = webSocket = (WebSocketImpl)cc.getWebSocket();
            synchronized (webSocketImpl) {
                BlockingQueueImpl sharedQueue = webSocket.getSharedQueue();
                if (sharedQueue != null) {
                    BlockingQueueImpl blockingQueueImpl = sharedQueue;
                    synchronized (blockingQueueImpl) {
                        try {
                            sharedQueue.put(text);
                        }
                        catch (InterruptedException ex) {
                            _LOG.log(Level.INFO, ex.getMessage(), ex);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
            WebSocketImpl webSocket;
            _LOG.entering(_CLASS_NAME, "connectionClosed");
            WebSocketCompositeChannel cc = (WebSocketCompositeChannel)channel;
            WebSocketImpl webSocketImpl = webSocket = (WebSocketImpl)cc.getWebSocket();
            synchronized (webSocketImpl) {
                webSocket.connectionClosed(wasClean, code, reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(WebSocketChannel channel, Exception ex) {
            WebSocketImpl webSocket;
            _LOG.entering(_CLASS_NAME, "onError");
            WebSocketCompositeChannel cc = (WebSocketCompositeChannel)channel;
            WebSocketImpl webSocketImpl = webSocket = (WebSocketImpl)cc.getWebSocket();
            synchronized (webSocketImpl) {
                webSocket.connectionClosed(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionFailed(WebSocketChannel channel, Exception ex) {
            WebSocketImpl webSocket;
            _LOG.entering(_CLASS_NAME, "onError");
            WebSocketCompositeChannel cc = (WebSocketCompositeChannel)channel;
            WebSocketImpl webSocketImpl = webSocket = (WebSocketImpl)cc.getWebSocket();
            synchronized (webSocketImpl) {
                webSocket.connectionFailed(ex);
            }
        }

        @Override
        public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
        }

        @Override
        public void redirected(WebSocketChannel channel, String location) {
        }

        @Override
        public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
        }
    };

    public WebSocketImpl(URI location, Map<String, WebSocketExtensionFactorySpi> extensionFactories) throws URISyntaxException {
        this(location, extensionFactories, HttpRedirectPolicy.ALWAYS, null, null, new HashMap<String, WsExtensionParameterValuesSpiImpl>(), null, 0);
    }

    public WebSocketImpl(URI location, Map<String, WebSocketExtensionFactorySpi> extensionFactories, HttpRedirectPolicy followRedirect, Collection<String> enabledExtensions, Collection<String> enabledProtocols, Map<String, WsExtensionParameterValuesSpiImpl> enabledParameters, ChallengeHandler challengeHandler, int connectTimeout) throws URISyntaxException {
        WSCompositeURI compUri = new WSCompositeURI(location);
        this._readyState = ReadyState.CLOSED;
        this._location = compUri.getWSEquivalent();
        this._followRedirect = followRedirect;
        this._enabledParameters = enabledParameters;
        this._negotiatedParameters = new HashMap<String, WsExtensionParameterValuesSpiImpl>();
        this._extensionFactories = extensionFactories;
        this._challengeHandler = challengeHandler;
        this._connectTimeout = connectTimeout;
        this._handler = WebSocketCompositeHandler.COMPOSITE_HANDLER;
        this._handler.setListener(handlerListener);
        this._channel = new WebSocketCompositeChannel(compUri);
        this._channel.setWebSocket(this);
        if (this._extensionFactories != null && this._extensionFactories.size() > 0) {
            this._supportedExtensions = new HashSet<String>();
            this._supportedExtensions.addAll(this._extensionFactories.keySet());
        }
        this.setEnabledExtensions(enabledExtensions);
        this.setEnabledProtocols(enabledProtocols);
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(0, null);
    }

    @Override
    public synchronized void close(int code) throws IOException {
        this.close(code, null);
    }

    @Override
    public synchronized void close(int code, String reason) throws IOException {
        Exception exception;
        String args = String.format("code = '%d',  reason = '%s'", code, reason);
        _LOG.entering(_CLASS_NAME, "close", args);
        if (code != 0) {
            if (code != 1000 && (code < 3000 || code > 4999)) {
                throw new IllegalArgumentException("code must equal to 1000 or in range 3000 to 4999");
            }
            if (reason != null && reason.length() > 0) {
                try {
                    byte[] reasonBytes = reason.getBytes("UTF8");
                    if (reasonBytes.length > 123) {
                        throw new IllegalArgumentException("Reason is longer than 123 bytes");
                    }
                    reason = new String(reasonBytes, "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    _LOG.log(Level.FINEST, e.getMessage(), e);
                    throw new IllegalArgumentException("Reason must be encodable to UTF8");
                }
            }
        }
        if (this._readyState == ReadyState.CLOSED || this._readyState == ReadyState.CLOSING) {
            _LOG.log(Level.FINE, "WebSocket is closed or closing");
            return;
        }
        if (this._readyState == ReadyState.CONNECTING) {
            _LOG.log(Level.FINE, "WebSocket is connecting");
            this._readyState = ReadyState.CLOSED;
            this.cleanupAfterClose();
            this.setException(new WebSocketException("Connection Failed"));
            this.notifyAll();
            return;
        }
        this.setException(null);
        this._readyState = ReadyState.CLOSING;
        this._handler.processClose(this._channel, code, reason);
        while (this._readyState != ReadyState.CLOSED && this._exception == null) {
            try {
                this.wait();
                if (this.getException() == null) continue;
                break;
            }
            catch (InterruptedException e) {
                throw new WebSocketException(e);
            }
        }
        if ((exception = this.getException()) != null) {
            throw new WebSocketException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        Exception exception;
        _LOG.entering(_CLASS_NAME, "connect");
        ResumableTimer connectTimer = null;
        String[] enabledProtocols = null;
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._readyState == ReadyState.OPEN) {
                return;
            }
            if (this._readyState == ReadyState.CONNECTING) {
                String s = "WebSocket connection is in progress";
                throw new IllegalStateException(s);
            }
            if (this._readyState == ReadyState.CLOSING) {
                String s = "WebSocket is not in a state to connect at this time";
                throw new IllegalStateException(s);
            }
            this._readyState = ReadyState.CONNECTING;
            this.setException(null);
            int len = this.getEnabledProtocols().size();
            if (len > 0) {
                enabledProtocols = this.getEnabledProtocols().toArray(new String[len]);
            }
            this._sharedQueue = new BlockingQueueImpl();
            this._channel.setChallengeHandler(this._challengeHandler);
            String extensionsHeader = this.rfc3864FormattedString();
            this._channel.setEnabledExtensions(extensionsHeader);
            this._channel.setFollowRedirect(this._followRedirect);
            if (this._connectTimeout > 0) {
                connectTimer = new ResumableTimer(new Runnable(){

                    @Override
                    public void run() {
                        if (WebSocketImpl.this._readyState == ReadyState.CONNECTING) {
                            SocketTimeoutException ex = new SocketTimeoutException("Connection timeout");
                            WebSocketImpl.this._handler.doClose(WebSocketImpl.this._channel, ex);
                            WebSocketImpl.this._handler.processClose(WebSocketImpl.this._channel, 0, "Connection timeout");
                        }
                    }
                }, this._connectTimeout, false);
                this._channel.setConnectTimer(connectTimer);
                connectTimer.start();
            }
        }
        this._handler.processConnect(this._channel, this._location, enabledProtocols);
        webSocketImpl = this;
        synchronized (webSocketImpl) {
            while (this._readyState != ReadyState.OPEN && this._exception == null) {
                try {
                    this.wait();
                    if (this.getException() == null) continue;
                    break;
                }
                catch (InterruptedException e) {
                    throw new WebSocketException(e);
                }
            }
        }
        if (connectTimer != null) {
            connectTimer.cancel();
            this._channel.setConnectTimer(null);
        }
        if ((exception = this.getException()) != null) {
            String s = "Connection failed";
            throw new WebSocketException(s, exception);
        }
    }

    @Override
    public ChallengeHandler getChallengeHandler() {
        return this._challengeHandler;
    }

    @Override
    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public Collection<String> getEnabledExtensions() {
        return this._enabledExtensions == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._enabledExtensions);
    }

    @Override
    public <T> T getEnabledParameter(WebSocketExtension.Parameter<T> parameter) {
        String extName = parameter.extension().name();
        WsExtensionParameterValuesSpiImpl paramValues = this._enabledParameters.get(extName);
        if (paramValues == null) {
            return null;
        }
        return paramValues.getParameterValue(parameter);
    }

    @Override
    public Collection<String> getEnabledProtocols() {
        return this._enabledProtocols == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._enabledProtocols);
    }

    @Override
    public HttpRedirectPolicy getRedirectPolicy() {
        return this._followRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot create InputStream as the WebSocket is not connected";
            throw new IOException(s);
        }
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._inputStream != null && !this._inputStream.isClosed()) {
                return this._inputStream;
            }
            WsMessageReaderAdapter adapter = null;
            adapter = new WsMessageReaderAdapter(this.getMessageReader());
            this._inputStream = new WsInputStreamImpl(adapter);
        }
        return this._inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketMessageReader getMessageReader() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot create MessageReader as the WebSocket is not connected";
            throw new IOException(s);
        }
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._messageReader != null && !this._messageReader.isClosed()) {
                return this._messageReader;
            }
            if (this._sharedQueue == null) {
                this._sharedQueue = new BlockingQueueImpl();
            }
            this._messageReader = new WsMessageReaderImpl(this, this._sharedQueue);
        }
        return this._messageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketMessageWriter getMessageWriter() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot create MessageWriter as the WebSocket is not connected";
            throw new IOException(s);
        }
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._messageWriter != null && !this._messageWriter.isClosed()) {
                return this._messageWriter;
            }
            this._messageWriter = new WsMessageWriterImpl(this);
        }
        return this._messageWriter;
    }

    @Override
    public Collection<String> getNegotiatedExtensions() {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Extensions have not been negotiated as the webSocket is not yet connected";
            throw new IllegalStateException(s);
        }
        return this._negotiatedExtensions == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._negotiatedExtensions);
    }

    @Override
    public <T> T getNegotiatedParameter(WebSocketExtension.Parameter<T> parameter) {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Extensions have not been negotiated as the webSocket is not yet connected";
            throw new IllegalStateException(s);
        }
        String extName = parameter.extension().name();
        WsExtensionParameterValuesSpiImpl paramValues = this._negotiatedParameters.get(extName);
        if (paramValues == null) {
            return null;
        }
        return paramValues.getParameterValue(parameter);
    }

    @Override
    public String getNegotiatedProtocol() {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Protocols have not been negotiated as the webSocket is not yet connected";
            throw new IllegalStateException(s);
        }
        return this._negotiatedProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot get the OutputStream as the WebSocket is not yet connected";
            throw new IOException(s);
        }
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._outputStream != null && !this._outputStream.isClosed()) {
                return this._outputStream;
            }
            this._outputStream = new WsOutputStreamImpl(this.getMessageWriter());
        }
        return this._outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReader() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot create Reader as the WebSocket is not connected";
            throw new IOException(s);
        }
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._reader != null && !this._reader.isClosed()) {
                return this._reader;
            }
            WsMessageReaderAdapter adapter = null;
            adapter = new WsMessageReaderAdapter(this.getMessageReader());
            this._reader = new WsReaderImpl(adapter);
        }
        return this._reader;
    }

    @Override
    public Collection<String> getSupportedExtensions() {
        return this._supportedExtensions == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._supportedExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer getWriter() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot create Writer as the WebSocket is not yet connected";
            throw new IOException(s);
        }
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this._writer != null && !this._writer.isClosed()) {
                return this._writer;
            }
            this._writer = new WsWriterImpl(this.getMessageWriter());
        }
        return this._writer;
    }

    @Override
    public void setChallengeHandler(ChallengeHandler challengeHandler) {
        this._challengeHandler = challengeHandler;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        if (this._readyState != ReadyState.CLOSED) {
            String s = "Connection timeout can be set only when the WebSocket is closed";
            throw new IllegalStateException(s);
        }
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("Connect timeout cannot be negative");
        }
        this._connectTimeout = connectTimeout;
    }

    @Override
    public void setEnabledExtensions(Collection<String> extensions) {
        if (this._readyState != ReadyState.CLOSED) {
            String s = "Extensions can be enabled only when the WebSocket is closed";
            throw new IllegalStateException(s);
        }
        if (extensions == null) {
            this._enabledExtensions = extensions;
            return;
        }
        Collection<String> supportedExtns = this.getSupportedExtensions();
        for (String extension : extensions) {
            if (!supportedExtns.contains(extension)) {
                String s = String.format("'%s' is not a supported extension", extension);
                throw new IllegalStateException(s);
            }
            if (this._enabledExtensions == null) {
                this._enabledExtensions = new ArrayList<String>();
            }
            this._enabledExtensions.add(extension);
        }
    }

    @Override
    public <T> void setEnabledParameter(WebSocketExtension.Parameter<T> parameter, T value) {
        if (this._readyState != ReadyState.CLOSED) {
            String s = "Parameters can be set only when the WebSocket is closed";
            throw new IllegalStateException(s);
        }
        String extensionName = parameter.extension().name();
        WsExtensionParameterValuesSpiImpl parameterValues = this._enabledParameters.get(extensionName);
        if (parameterValues == null) {
            parameterValues = new WsExtensionParameterValuesSpiImpl();
            this._enabledParameters.put(extensionName, parameterValues);
        }
        parameterValues.setParameterValue(parameter, value);
    }

    @Override
    public void setEnabledProtocols(Collection<String> protocols) {
        if (this._readyState != ReadyState.CLOSED) {
            String s = "Protocols can be enabled only when the WebSocket is closed";
            throw new IllegalStateException(s);
        }
        if (protocols == null || protocols.isEmpty()) {
            this._enabledProtocols = protocols;
            return;
        }
        this._enabledProtocols = new ArrayList<String>();
        for (String protocol : protocols) {
            this._enabledProtocols.add(protocol);
        }
    }

    @Override
    public void setRedirectPolicy(HttpRedirectPolicy option) {
        this._followRedirect = option;
    }

    public WebSocketCompositeChannel getCompositeChannel() {
        return this._channel;
    }

    public boolean isConnected() {
        return this._readyState == ReadyState.OPEN;
    }

    public boolean isDisconnected() {
        return this._readyState == ReadyState.CLOSED;
    }

    public Exception getException() {
        return this._exception;
    }

    public void setException(Exception exception) {
        this._exception = exception;
    }

    public synchronized void send(ByteBuffer buf) throws IOException {
        _LOG.entering(_CLASS_NAME, "send", buf);
        if (this._readyState != ReadyState.OPEN) {
            String s = "Messages can be sent only when the WebSocket is connected";
            throw new WebSocketException(s);
        }
        this._handler.processBinaryMessage(this._channel, new WrappedByteBuffer(buf));
    }

    public synchronized void send(String message) throws IOException {
        _LOG.entering(_CLASS_NAME, "send", message);
        if (this._readyState != ReadyState.OPEN) {
            String s = "Messages can be sent only when the WebSocket is connected";
            throw new WebSocketException(s);
        }
        this._handler.processTextMessage(this._channel, message);
    }

    private synchronized void connectionOpened(String protocol, String extensionsHeader) {
        this.setNegotiatedProtocol(protocol);
        this.setNegotiatedExtensions(extensionsHeader);
        if (this.getException() == null && this._readyState == ReadyState.CONNECTING) {
            this._readyState = ReadyState.OPEN;
        } else {
            this._readyState = ReadyState.CLOSED;
            this._handler.processClose(this._channel, 0, null);
        }
        this.notifyAll();
    }

    private synchronized void connectionClosed(boolean wasClean, int code, String reason) {
        if (this._readyState == ReadyState.CLOSED) {
            return;
        }
        this._readyState = ReadyState.CLOSED;
        if (!wasClean) {
            if (reason == null) {
                reason = "Connection Failed";
            }
            this.setException(new WebSocketException(code, reason));
        }
        this.cleanupAfterClose();
        this.notifyAll();
    }

    private synchronized void connectionClosed(Exception ex) {
        if (this._readyState == ReadyState.CLOSED) {
            return;
        }
        this.setException(ex);
        this._readyState = ReadyState.CLOSED;
        this.cleanupAfterClose();
        this.notifyAll();
    }

    private synchronized void connectionFailed(Exception ex) {
        if (this._readyState == ReadyState.CLOSED) {
            return;
        }
        if (ex == null) {
            ex = new WebSocketException("Connection Failed");
        }
        this.setException(ex);
        this._readyState = ReadyState.CLOSED;
        this.cleanupAfterClose();
        this.notifyAll();
    }

    private synchronized void cleanupAfterClose() {
        this.setNegotiatedExtensions(null);
        this.setNegotiatedProtocol(null);
        this._negotiatedParameters.clear();
        if (this._messageReader != null) {
            try {
                this._messageReader.close();
            }
            catch (IOException ex) {
                _LOG.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        if (this._sharedQueue != null) {
            this._sharedQueue.done();
        }
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (Exception ex) {
                _LOG.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        if (this._outputStream != null) {
            try {
                this._outputStream.close();
            }
            catch (Exception ex) {
                _LOG.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        if (this._reader != null) {
            try {
                this._reader.close();
            }
            catch (Exception ex) {
                _LOG.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        if (this._writer != null) {
            try {
                this._writer.close();
            }
            catch (Exception ex) {
                _LOG.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        this._messageReader = null;
        this._sharedQueue = null;
        this._messageWriter = null;
        this._inputStream = null;
        this._outputStream = null;
        this._reader = null;
        this._writer = null;
    }

    private String formattedExtension(String extensionName, WebSocketExtensionParameterValuesSpi paramValues) {
        if (extensionName == null) {
            return "";
        }
        WebSocketExtension extension = WebSocketExtension.getWebSocketExtension(extensionName);
        Collection<WebSocketExtension.Parameter<?>> extnParameters = extension.getParameters();
        StringBuffer buffer = new StringBuffer(extension.name());
        for (WebSocketExtension.Parameter<?> param : extnParameters) {
            Object value;
            if (param.required()) {
                String s = String.format("Extension '%s': Required parameter '%s' must be set", extension.name(), param.name());
                if (paramValues == null || paramValues.getParameterValue(param) == null) {
                    throw new IllegalStateException(s);
                }
            }
            if (paramValues == null || (value = paramValues.getParameterValue(param)) == null || param.temporal()) continue;
            if (param.anonymous()) {
                buffer.append(";").append(value);
                continue;
            }
            buffer.append(";").append(param.name()).append("=").append(value);
        }
        return buffer.toString();
    }

    private BlockingQueueImpl<Object> getSharedQueue() {
        return this._sharedQueue;
    }

    private String rfc3864FormattedString() {
        StringBuffer extensionsHeader = new StringBuffer("");
        HashMap<String, WebSocketExtensionHandlerSpi> handlers = new HashMap<String, WebSocketExtensionHandlerSpi>();
        for (String extensionName : this.getEnabledExtensions()) {
            WebSocketExtensionFactorySpi extensionFactory = this._extensionFactories.get(extensionName);
            WebSocketExtensionParameterValuesSpi paramValues = this._enabledParameters.get(extensionName);
            WebSocketExtensionSpi extension = extensionFactory.createWsExtension(paramValues);
            WebSocketExtensionHandlerSpi extHandler = extension.createHandler();
            handlers.put(extensionName, extHandler);
            String formatted = this.formattedExtension(extensionName, paramValues);
            if (formatted.length() <= 0) continue;
            if (extensionsHeader.length() > 0) {
                extensionsHeader.append(",");
            }
            extensionsHeader.append(formatted);
        }
        return extensionsHeader.toString();
    }

    private void setNegotiatedExtensions(String extensionsHeader) {
        if (extensionsHeader == null || extensionsHeader.trim().length() == 0) {
            this._negotiatedExtensions = null;
            return;
        }
        String[] extns = extensionsHeader.split(",");
        ArrayList<String> extnNames = new ArrayList<String>();
        for (String extn : extns) {
            String[] properties = extn.split(";");
            String extnName = properties[0].trim();
            if (!this.getEnabledExtensions().contains(extnName)) {
                String s = String.format("Extension '%s' is not an enabled extension so it should not have been negotiated", extnName);
                this.setException(new WebSocketException(s));
                return;
            }
            WebSocketExtension extension = WebSocketExtension.getWebSocketExtension(extnName);
            WsExtensionParameterValuesSpiImpl paramValues = this._negotiatedParameters.get(extnName);
            Collection<WebSocketExtension.Parameter<?>> anonymousParams = extension.getParameters(WebSocketExtension.Parameter.Metadata.ANONYMOUS);
            for (int i = 1; i < properties.length; ++i) {
                String property = properties[i].trim();
                String[] pair = property.split("=");
                WebSocketExtension.Parameter<?> parameter = null;
                String paramValue = null;
                if (pair.length == 1) {
                    parameter = anonymousParams.iterator().next();
                    paramValue = pair[0].trim();
                } else {
                    parameter = extension.getParameter(pair[0].trim());
                    paramValue = pair[1].trim();
                }
                if (parameter.type() != String.class) {
                    String paramName = parameter.name();
                    String s = String.format("Negotiated Extension '%s': Type of parameter '%s' should be String", extnName, paramName);
                    this.setException(new WebSocketException(s));
                    return;
                }
                if (paramValues == null) {
                    paramValues = new WsExtensionParameterValuesSpiImpl();
                    this._negotiatedParameters.put(extnName, paramValues);
                }
                paramValues.setParameterValue(parameter, paramValue);
            }
            extnNames.add(extnName);
        }
        HashSet extnsSet = new HashSet(extnNames);
        this._negotiatedExtensions = Collections.unmodifiableCollection(extnsSet);
    }

    private void setNegotiatedProtocol(String protocol) {
        this._negotiatedProtocol = protocol;
    }

    static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

