/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.impl.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

public class ResumableTimer {
    private final Runnable runnable;
    private volatile boolean taskExecuted = false;
    private AtomicLong delay;
    private AtomicLong startTime;
    private Timer timer;
    private boolean updateDelayWhenPaused;

    public ResumableTimer(Runnable runnable, long delay, boolean updateDelayWhenPaused) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("Timer delay cannot be negative");
        }
        this.delay = new AtomicLong(delay);
        this.startTime = new AtomicLong(0L);
        this.runnable = runnable;
        this.updateDelayWhenPaused = updateDelayWhenPaused;
    }

    public synchronized void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.delay.set(-1L);
        this.startTime.set(-1L);
        this.taskExecuted = false;
    }

    public boolean didTaskExecute() {
        return this.taskExecuted;
    }

    public synchronized long getDelay() {
        return this.delay.get();
    }

    public synchronized void pause() {
        long elapsedTime = System.currentTimeMillis() - this.startTime.get();
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
        if (this.updateDelayWhenPaused) {
            assert (elapsedTime < this.delay.get());
            this.delay.compareAndSet(this.delay.get(), this.delay.get() - elapsedTime);
        }
    }

    public synchronized void resume() {
        if (this.timer != null) {
            return;
        }
        if (this.delay.get() < 0L) {
            throw new IllegalStateException("Timer delay cannot be negative");
        }
        this.timer = new Timer("ResumableTimer", true);
        this.startTime.compareAndSet(this.startTime.get(), System.currentTimeMillis());
        this.timer.schedule((TimerTask)new RunnableTask(this.runnable), this.delay.get());
    }

    public synchronized void start() {
        this.resume();
    }

    private synchronized void cleanup() {
        this.taskExecuted = true;
        this.startTime.set(-1L);
        this.timer = null;
    }

    private class RunnableTask
    extends TimerTask {
        private final Runnable runnable;

        public RunnableTask(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("runnable is null");
            }
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
            ResumableTimer.this.cleanup();
        }
    }

    public static enum PauseStrategy {
        UPDATE_DELAY,
        DO_NOT_UPDATE_DELAY;

    }
}

