/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.transport.CloseEvent;
import org.kaazing.gateway.client.transport.ErrorEvent;
import org.kaazing.gateway.client.transport.IoBufferUtil;
import org.kaazing.gateway.client.transport.LoadEvent;
import org.kaazing.gateway.client.transport.OpenEvent;
import org.kaazing.gateway.client.transport.ProgressEvent;
import org.kaazing.gateway.client.transport.ReadyStateChangedEvent;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegate;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegateListener;
import org.kaazing.gateway.client.transport.http.HttpRequestUtil;

public class HttpRequestDelegateImpl
implements HttpRequestDelegate {
    private static final String CLASS_NAME = HttpRequestDelegateImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private State readyState = State.UNSENT;
    private ByteBuffer responseBuffer = ByteBuffer.allocate(5000);
    private ByteBuffer completedResponseBuffer;
    private HttpURLConnection connection = null;
    private HttpRequestDelegateListener listener;
    private int httpResponseCode;
    private StreamReader reader;
    private boolean async;

    public HttpRequestDelegateImpl() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    public final State getReadyState() {
        LOG.exiting(CLASS_NAME, "getReadyState", (Object)this.readyState);
        return this.readyState;
    }

    @Override
    public ByteBuffer getResponseText() {
        LOG.entering(CLASS_NAME, "getResponseText");
        switch (this.readyState) {
            case LOADING: 
            case OPENED: {
                return this.responseBuffer.duplicate();
            }
            case DONE: {
                return this.completedResponseBuffer;
            }
        }
        return null;
    }

    @Override
    public int getStatusCode() {
        LOG.exiting(CLASS_NAME, "getStatusCode", this.httpResponseCode);
        return this.httpResponseCode;
    }

    @Override
    public void processAbort() {
        LOG.entering(CLASS_NAME, "abort");
        if (this.reader != null) {
            this.reader.stop();
            this.reader = null;
        }
    }

    public String getAllResponseHeaders() {
        LOG.entering(CLASS_NAME, "getAllResponseHeaders");
        if (this.readyState == State.LOADING || this.readyState == State.DONE) {
            String headerText = this.connection.getHeaderFields().toString();
            LOG.exiting(CLASS_NAME, "getAllResponseHeaders", headerText);
            return headerText;
        }
        LOG.exiting(CLASS_NAME, "getAllResponseHeaders");
        return null;
    }

    @Override
    public String getResponseHeader(String header) {
        LOG.entering(CLASS_NAME, "getResponseHeader", header);
        if (this.readyState == State.LOADING || this.readyState == State.DONE || this.readyState == State.HEADERS_RECEIVED) {
            String headerText = this.connection.getHeaderField(header);
            LOG.exiting(CLASS_NAME, "getResponseHeader", headerText);
            return headerText;
        }
        LOG.exiting(CLASS_NAME, "getResponseHeader");
        return null;
    }

    @Override
    public void processOpen(String method, URL url, String origin, boolean async, long connectTimeout) throws Exception {
        LOG.entering(CLASS_NAME, "processOpen", new Object[]{method, url, origin, async});
        this.async = async;
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setRequestMethod(method);
        this.connection.setInstanceFollowRedirects(false);
        this.connection.setConnectTimeout((int)connectTimeout);
        if (!origin.equalsIgnoreCase("null") && !origin.startsWith("privileged")) {
            URL originUrl = new URL(origin);
            origin = originUrl.getProtocol() + "://" + originUrl.getAuthority();
        }
        this.connection.addRequestProperty("Origin", origin);
        this.setReadyState(State.OPENED);
        this.listener.opened(new OpenEvent());
    }

    @Override
    public void processSend(ByteBuffer content) {
        LOG.entering(CLASS_NAME, "processSend", content);
        if (this.readyState != State.OPENED && this.readyState != State.HEADERS_RECEIVED) {
            throw new IllegalStateException((Object)((Object)this.readyState) + " HttpRequest must be in an OPEN state before invocation of the send() method");
        }
        try {
            if (!this.async && content != null && content.hasRemaining()) {
                this.connection.setDoOutput(true);
                this.connection.setDoInput(true);
                OutputStream out = this.connection.getOutputStream();
                out.write(content.array(), content.arrayOffset(), content.remaining());
                out.flush();
            }
            this.connection.connect();
            this.reader = new StreamReader();
            Thread t = new Thread((Runnable)this.reader, "HttpRequestDelegate stream reader");
            t.setDaemon(true);
            t.start();
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "While processing http request", e);
            this.listener.errorOccurred(new ErrorEvent(e));
        }
    }

    @Override
    public void setRequestHeader(String header, String value) {
        LOG.entering(CLASS_NAME, "setRequestHeader", new Object[]{header, value});
        HttpRequestUtil.validateHeader(header);
        this.connection.addRequestProperty(header, value);
    }

    protected void reset() {
        LOG.entering(CLASS_NAME, "reset");
        this.responseBuffer = null;
        this.completedResponseBuffer = null;
        this.setStatus(-1);
        this.setReadyState(State.UNSENT);
    }

    private void setReadyState(State state) {
        LOG.entering(CLASS_NAME, "setReadyState", (Object)state);
        this.readyState = state;
    }

    private void setStatus(int status) {
        LOG.entering(CLASS_NAME, "setStatus", status);
        this.httpResponseCode = status;
    }

    @Override
    public void setListener(HttpRequestDelegateListener listener) {
        this.listener = listener;
    }

    private final class StreamReader
    implements Runnable {
        private final String CLASS_NAME = StreamReader.class.getName();
        private AtomicBoolean stopped = new AtomicBoolean(false);
        private AtomicBoolean requestCompleted = new AtomicBoolean(false);

        private StreamReader() {
        }

        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (Exception e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run2() {
            block22: {
                InputStream in;
                LOG.entering(this.CLASS_NAME, "run");
                try {
                    HttpRequestDelegateImpl.this.httpResponseCode = HttpRequestDelegateImpl.this.connection.getResponseCode();
                    if (HttpRequestDelegateImpl.this.httpResponseCode != -1 && (HttpRequestDelegateImpl.this.httpResponseCode < 200 || HttpRequestDelegateImpl.this.httpResponseCode == 400 || HttpRequestDelegateImpl.this.httpResponseCode == 402 || HttpRequestDelegateImpl.this.httpResponseCode == 403 || HttpRequestDelegateImpl.this.httpResponseCode == 404)) {
                        Exception ex = new Exception("Unexpected HTTP response code received: code = " + HttpRequestDelegateImpl.this.httpResponseCode);
                        HttpRequestDelegateImpl.this.listener.errorOccurred(new ErrorEvent(ex));
                        throw ex;
                    }
                    Map<String, List<String>> headers = HttpRequestDelegateImpl.this.connection.getHeaderFields();
                    StringBuilder allHeadersBuffer = new StringBuilder();
                    int numHeaders = headers.size();
                    for (int i = 0; i < numHeaders; ++i) {
                        allHeadersBuffer.append(HttpRequestDelegateImpl.this.connection.getHeaderFieldKey(i));
                        allHeadersBuffer.append(":");
                        allHeadersBuffer.append(HttpRequestDelegateImpl.this.connection.getHeaderField(i));
                        allHeadersBuffer.append("\n");
                    }
                    String allHeaders = allHeadersBuffer.toString();
                    String[] params = new String[]{Integer.toString(State.HEADERS_RECEIVED.ordinal()), Integer.toString(HttpRequestDelegateImpl.this.httpResponseCode), HttpRequestDelegateImpl.this.connection.getResponseMessage() + "", allHeaders};
                    HttpRequestDelegateImpl.this.setReadyState(State.HEADERS_RECEIVED);
                    HttpRequestDelegateImpl.this.listener.readyStateChanged(new ReadyStateChangedEvent(params));
                    if (HttpRequestDelegateImpl.this.httpResponseCode == 401) {
                        HttpRequestDelegateImpl.this.listener.loaded(new LoadEvent(ByteBuffer.allocate(0)));
                        this.requestCompleted.compareAndSet(false, true);
                        HttpRequestDelegateImpl.this.connection.disconnect();
                        return;
                    }
                    in = HttpRequestDelegateImpl.this.connection.getInputStream();
                }
                catch (IOException e) {
                    LOG.severe(e.toString());
                    HttpRequestDelegateImpl.this.listener.errorOccurred(new ErrorEvent(e));
                    return;
                }
                catch (Exception ex) {
                    LOG.log(Level.FINE, ex.getMessage(), ex);
                    HttpRequestDelegateImpl.this.listener.errorOccurred(new ErrorEvent(ex));
                    return;
                }
                try {
                    int numberOfBytesRead;
                    if (in == null && (in = HttpRequestDelegateImpl.this.connection.getInputStream()) == null) {
                        String s = "Input stream not ready";
                        RuntimeException ex = new RuntimeException(s);
                        HttpRequestDelegateImpl.this.listener.errorOccurred(new ErrorEvent(ex));
                        LOG.severe(s);
                        throw ex;
                    }
                    byte[] payloadBuffer = new byte[4096];
                    while (!this.stopped.get() && (numberOfBytesRead = in.read(payloadBuffer, 0, payloadBuffer.length)) != -1) {
                        ByteBuffer payload = ByteBuffer.wrap(payloadBuffer, 0, numberOfBytesRead);
                        if (!HttpRequestDelegateImpl.this.async) {
                            int payloadSize = payload.remaining();
                            if (!IoBufferUtil.canAccomodate(HttpRequestDelegateImpl.this.responseBuffer, payloadSize)) {
                                HttpRequestDelegateImpl.this.responseBuffer = IoBufferUtil.expandBuffer(HttpRequestDelegateImpl.this.responseBuffer, payloadSize);
                            }
                            HttpRequestDelegateImpl.this.responseBuffer.put(payload);
                            payload.flip();
                        }
                        HttpRequestDelegateImpl.this.listener.progressed(new ProgressEvent(payload, 0, 0));
                    }
                    if (this.stopped.get()) break block22;
                    HttpRequestDelegateImpl.this.responseBuffer.flip();
                    HttpRequestDelegateImpl.this.completedResponseBuffer = HttpRequestDelegateImpl.this.responseBuffer.duplicate();
                    HttpRequestDelegateImpl.this.setReadyState(State.DONE);
                    try {
                        HttpRequestDelegateImpl.this.listener.loaded(new LoadEvent(HttpRequestDelegateImpl.this.completedResponseBuffer));
                    }
                    finally {
                        this.requestCompleted.compareAndSet(false, true);
                        try {
                            HttpRequestDelegateImpl.this.connection.disconnect();
                        }
                        finally {
                            HttpRequestDelegateImpl.this.listener.closed(new CloseEvent(1000, true, ""));
                        }
                    }
                }
                catch (IOException e) {
                    LOG.severe(e.toString());
                    if (!this.requestCompleted.get()) {
                        HttpRequestDelegateImpl.this.listener.errorOccurred(new ErrorEvent(e));
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.FINE, ex.getMessage(), ex);
                    HttpRequestDelegateImpl.this.listener.errorOccurred(new ErrorEvent(ex));
                }
            }
        }

        public void stop() {
            LOG.entering(this.CLASS_NAME, "stop");
            this.stopped.set(true);
        }
    }

    private static enum State {
        UNSENT,
        OPENED,
        HEADERS_RECEIVED,
        LOADING,
        DONE;

    }
}

