/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wsn;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.WebSocketHandlerFactory;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.WebSocketLoggingHandler;
import org.kaazing.gateway.client.impl.ws.WebSocketTransportHandler;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeAuthenticationHandler;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeBalancingHandler;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeHandshakeHandler;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketNativeHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    public static WebSocketHandlerFactory TRANSPORT_HANDLER_FACTORY = new WebSocketHandlerFactory(){

        @Override
        public WebSocketHandler createWebSocketHandler() {
            return new WebSocketTransportHandler();
        }
    };
    private WebSocketNativeAuthenticationHandler authHandler = new WebSocketNativeAuthenticationHandler();
    private WebSocketNativeHandshakeHandler handshakeHandler = new WebSocketNativeHandshakeHandler();
    private WebSocketNativeBalancingHandler balancingHandler = new WebSocketNativeBalancingHandler();

    public WebSocketNativeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
        this.authHandler.setNextHandler(this.handshakeHandler);
        this.handshakeHandler.setNextHandler(this.balancingHandler);
        WebSocketHandler transportHandler = TRANSPORT_HANDLER_FACTORY.createWebSocketHandler();
        if (LOG.isLoggable(Level.FINE)) {
            WebSocketLoggingHandler loggingHandler = new WebSocketLoggingHandler();
            loggingHandler.setNextHandler(transportHandler);
            transportHandler = loggingHandler;
        }
        this.balancingHandler.setNextHandler(transportHandler);
        this.nextHandler = this.authHandler;
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeHandler.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
                WebSocketNativeHandler.this.listener.binaryMessageReceived(channel, buf);
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketNativeHandler.this.listener.textMessageReceived(channel, message);
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
                WebSocketNativeHandler.this.listener.commandMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketNativeHandler.this.listener.connectionClosed(channel, wasClean, code, reason);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeHandler.this.listener.connectionClosed(channel, ex);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeHandler.this.listener.connectionFailed(channel, ex);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }
        });
    }

    @Override
    public void processConnect(WebSocketChannel channel, WSURI location, String[] protocols) {
        LOG.entering(CLASS_NAME, "connect", channel);
        this.nextHandler.processConnect(channel, location, protocols);
    }

    public int getBufferedAmount() {
        return 0;
    }
}

