/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import org.kaazing.gateway.client.impl.Channel;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class HttpRequestHandlerAdapter
implements HttpRequestHandler {
    protected HttpRequestHandler nextHandler;
    protected HttpRequestListener listener;

    @Override
    public void processOpen(HttpRequest request) {
        this.nextHandler.processOpen(request);
    }

    @Override
    public void processSend(HttpRequest request, WrappedByteBuffer buffer) {
        this.nextHandler.processSend(request, buffer);
    }

    @Override
    public void processAbort(HttpRequest request) {
        this.nextHandler.processAbort(request);
    }

    @Override
    public void setListener(HttpRequestListener listener) {
        this.listener = listener;
    }

    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
    }

    public Channel getWebSocketChannel(HttpRequest request) {
        if (request.parent != null) {
            return request.parent.getParent();
        }
        return null;
    }

    public boolean isWebSocketClosing(HttpRequest request) {
        WebSocketCompositeChannel parent;
        Channel channel = this.getWebSocketChannel(request);
        if (channel != null && channel.getParent() != null && (parent = (WebSocketCompositeChannel)channel.getParent()) != null) {
            return parent.getReadyState() == ReadyState.CLOSED || parent.getReadyState() == ReadyState.CLOSING;
        }
        return false;
    }
}

