/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import org.kaazing.gateway.client.impl.bridge.HttpRequestBridgeHandler;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestUtil;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedChannel;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeDelegateHandler;
import org.kaazing.gateway.client.transport.CloseEvent;
import org.kaazing.gateway.client.transport.ErrorEvent;
import org.kaazing.gateway.client.transport.LoadEvent;
import org.kaazing.gateway.client.transport.OpenEvent;
import org.kaazing.gateway.client.transport.ProgressEvent;
import org.kaazing.gateway.client.transport.ReadyStateChangedEvent;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegate;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegateImpl;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegateListener;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class HttpRequestDelegateHandler
implements HttpRequestHandler {
    HttpRequestListener listener;

    @Override
    public void processOpen(final HttpRequest request) {
        HttpRequestDelegateImpl delegate = new HttpRequestDelegateImpl();
        try {
            request.setProxy(delegate);
            String origin = "privileged://" + WebSocketNativeDelegateHandler.getCanonicalHostPort(request.getUri().getURI());
            delegate.setListener(new HttpRequestDelegateListener(){

                @Override
                public void readyStateChanged(ReadyStateChangedEvent event) {
                    Object[] params = event.getParams();
                    int state = Integer.parseInt((String)params[0]);
                    if (state == 2) {
                        int responseCode;
                        HttpResponse response = new HttpResponse();
                        request.setResponse(response);
                        if (params.length > 1 && (responseCode = Integer.parseInt((String)params[1])) != 0) {
                            response.setStatusCode(responseCode);
                            response.setMessage((String)params[2]);
                            HttpRequestBridgeHandler.parseResponseHeaders(response, (String)params[3]);
                        }
                        request.setReadyState(HttpRequest.ReadyState.OPENED);
                        HttpRequestDelegateHandler.this.listener.requestOpened(request);
                    }
                }

                @Override
                public void progressed(ProgressEvent progressEvent) {
                    ByteBuffer payload = progressEvent.getPayload();
                    WrappedByteBuffer buffer = WrappedByteBuffer.wrap(payload);
                    request.setReadyState(HttpRequest.ReadyState.LOADING);
                    try {
                        HttpRequestDelegateHandler.this.listener.requestProgressed(request, buffer);
                    }
                    catch (Exception e) {
                        HttpRequestDelegateHandler.this.listener.errorOccurred(request, e);
                    }
                }

                @Override
                public void opened(OpenEvent event) {
                    HttpRequestDelegate delegate = (HttpRequestDelegate)request.getProxy();
                    request.setReadyState(HttpRequest.ReadyState.READY);
                    HttpRequestDelegateHandler.this.listener.requestOpened(request);
                    for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                        String header = entry.getKey();
                        String value = entry.getValue();
                        HttpRequestUtil.validateHeader(header);
                        delegate.setRequestHeader(header, value);
                    }
                    if (request.getMethod() == HttpRequest.Method.POST) {
                        HttpRequestDelegateHandler.this.listener.requestReady(request);
                    } else {
                        HttpRequestDelegateHandler.this.processSend(request, null);
                    }
                }

                @Override
                public void loaded(LoadEvent event) {
                    WrappedByteBuffer responseBuffer = WrappedByteBuffer.wrap(event.getResponseBuffer());
                    request.setReadyState(HttpRequest.ReadyState.LOADED);
                    HttpResponse response = request.getResponse();
                    response.setBody(responseBuffer);
                    try {
                        HttpRequestDelegateHandler.this.listener.requestLoaded(request, response);
                    }
                    catch (Exception e) {
                        HttpRequestDelegateHandler.this.listener.errorOccurred(request, e);
                    }
                }

                @Override
                public void closed(CloseEvent event) {
                    HttpRequestDelegateHandler.this.listener.requestClosed(request);
                }

                @Override
                public void errorOccurred(ErrorEvent event) {
                    HttpRequestDelegateHandler.this.listener.errorOccurred(request, event.getException());
                }
            });
            String method = request.getMethod().toString();
            URL url = request.getUri().getURI().toURL();
            boolean isAsync = request.isAsync();
            int connectTimeout = (int)this.getConnectTimeout(request);
            delegate.processOpen(method, url, origin, isAsync, connectTimeout);
        }
        catch (Exception e) {
            this.listener.errorOccurred(request, e);
        }
    }

    @Override
    public void processSend(HttpRequest request, WrappedByteBuffer content) {
        if (request.getReadyState() != HttpRequest.ReadyState.READY) {
            throw new IllegalStateException("HttpRequest must be in READY state to send");
        }
        request.setReadyState(HttpRequest.ReadyState.SENDING);
        ByteBuffer payload = content == null ? ByteBuffer.allocate(0) : ByteBuffer.wrap(content.array(), content.arrayOffset(), content.remaining());
        HttpRequestDelegate delegate = (HttpRequestDelegate)request.getProxy();
        delegate.processSend(payload);
        request.setReadyState(HttpRequest.ReadyState.SENT);
    }

    @Override
    public void processAbort(HttpRequest request) {
        HttpRequestDelegate delegate = (HttpRequestDelegate)request.getProxy();
        delegate.processAbort();
    }

    @Override
    public void setListener(HttpRequestListener listener) {
        this.listener = listener;
    }

    private long getConnectTimeout(HttpRequest request) {
        WebSocketCompositeChannel compChannel = this.getWebSocketCompositeChannel(request);
        if (compChannel != null && compChannel.getConnectTimer() != null) {
            return compChannel.getConnectTimer().getDelay();
        }
        return 0L;
    }

    private WebSocketCompositeChannel getWebSocketCompositeChannel(HttpRequest request) {
        if (request.parent != null) {
            WebSocketEmulatedChannel emulatedChannel = (WebSocketEmulatedChannel)request.parent.getParent();
            if (emulatedChannel != null) {
                return (WebSocketCompositeChannel)emulatedChannel.getParent();
            }
            return null;
        }
        return null;
    }
}

