/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.impl.auth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.net.auth.ChallengeRequest;

public final class RealmUtils {
    private static final String REALM_REGEX = "(.*)\\s?(?i:realm=)(\"(.*)\")(.*)";
    private static final Pattern REALM_PATTERN = Pattern.compile("(.*)\\s?(?i:realm=)(\"(.*)\")(.*)");

    private RealmUtils() {
    }

    public static String getRealm(ChallengeRequest challengeRequest) {
        String authenticationParameters = challengeRequest.getAuthenticationParameters();
        if (authenticationParameters == null) {
            return null;
        }
        Matcher m = REALM_PATTERN.matcher(authenticationParameters);
        if (m.matches() && m.groupCount() >= 3) {
            return m.group(3);
        }
        return null;
    }
}

