/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.transport.AuthenticateEvent;
import org.kaazing.gateway.client.transport.CloseEvent;
import org.kaazing.gateway.client.transport.ErrorEvent;
import org.kaazing.gateway.client.transport.IoBufferUtil;
import org.kaazing.gateway.client.transport.LoadEvent;
import org.kaazing.gateway.client.transport.MessageEvent;
import org.kaazing.gateway.client.transport.OpenEvent;
import org.kaazing.gateway.client.transport.ProgressEvent;
import org.kaazing.gateway.client.transport.ReadyStateChangedEvent;
import org.kaazing.gateway.client.transport.RedirectEvent;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegate;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegateFactory;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegateImpl;
import org.kaazing.gateway.client.transport.http.HttpRequestDelegateListener;
import org.kaazing.gateway.client.transport.ws.Base64Util;
import org.kaazing.gateway.client.transport.ws.BridgeSocket;
import org.kaazing.gateway.client.transport.ws.BridgeSocketFactory;
import org.kaazing.gateway.client.transport.ws.BridgeSocketImpl;
import org.kaazing.gateway.client.transport.ws.FrameProcessor;
import org.kaazing.gateway.client.transport.ws.FrameProcessorListener;
import org.kaazing.gateway.client.transport.ws.WebSocketDelegate;
import org.kaazing.gateway.client.transport.ws.WebSocketDelegateListener;
import org.kaazing.gateway.client.transport.ws.WsFrameEncodingSupport;
import org.kaazing.gateway.client.transport.ws.WsMessage;

public class WebSocketDelegateImpl
implements WebSocketDelegate {
    private static final String CLASS_NAME = WebSocketDelegateImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final byte[] GET_BYTES = "GET".getBytes();
    private static final String APPLICATION_PREFIX = "Application ";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate: ";
    private static final String HTTP_1_1_START = "HTTP/1.1";
    private static final int HTTP_1_1_START_LEN = "HTTP/1.1".length();
    private static final byte[] HTTP_1_1_START_BYTES = "HTTP/1.1".getBytes();
    private static final String WEBSOCKET_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int CLOSE_NO_STATUS = 1005;
    public static final int CLOSE_ABNORMAL = 1006;
    private static final byte[] HTTP_1_1_BYTES = "HTTP/1.1".getBytes();
    private static final byte[] COLON_BYTES = ":".getBytes();
    private static final byte[] SPACE_BYTES = " ".getBytes();
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    private static final String HEADER_ORIGIN = "Origin";
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_HOST = "Host";
    private static final String HEADER_UPGRADE = "Upgrade";
    private static final String HEADER_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final String HEADER_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    private static final String HEADER_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    private static final String HEADER_VERSION = "13";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_LOCATION = "Location";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String WEB_SOCKET_LOWERCASE = "websocket";
    private static final String HEADER_COOKIE = "Cookie";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private BridgeSocket socket;
    private boolean stopReaderThread;
    private boolean connectionUpgraded = false;
    private URI url;
    private String origin;
    private URI originUri;
    private String[] requestedProtocols;
    private boolean secure;
    private WebSocketDelegateListener listener;
    protected String cookies = null;
    private String authorize = null;
    private AtomicBoolean closed = new AtomicBoolean(false);
    String websocketKey;
    private final long connectTimeout;
    private final AtomicInteger idleTimeout = new AtomicInteger();
    private final AtomicLong lastMessageTimestamp = new AtomicLong();
    private Timer idleTimer = null;
    private ReadyState readyState = ReadyState.CONNECTING;
    int bufferedAmount;
    private String secProtocol;
    private String extensions;
    private boolean wasClean = false;
    private int code = 1006;
    private String reason = "";
    HttpRequestDelegateFactory HTTP_REQUEST_DELEGATE_FACTORY = new HttpRequestDelegateFactory(){

        @Override
        public HttpRequestDelegate createHttpRequestDelegate() {
            return new HttpRequestDelegateImpl();
        }
    };
    BridgeSocketFactory BRIDGE_SOCKET_FACTORY = new BridgeSocketFactory(){

        @Override
        public BridgeSocket createSocket(boolean secure) throws IOException {
            return new BridgeSocketImpl(secure);
        }
    };

    public ReadyState getReadyState() {
        return this.readyState;
    }

    public int getBufferedAmount() {
        return this.bufferedAmount;
    }

    public String getSecProtocol() {
        return this.secProtocol;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public WebSocketDelegateImpl(URI url, URI origin, String[] protocols, long connectTimeout) {
        LOG.entering(CLASS_NAME, "<init>", new Object[]{url, origin, protocols});
        if (origin == null) {
            throw new IllegalArgumentException("Please specify the origin for the WebSocket connection");
        }
        if (url == null) {
            throw new IllegalArgumentException("Please specify the target for the WebSocket connection");
        }
        this.url = url;
        if (origin.getScheme() == null || origin.getHost() == null) {
            this.origin = "null";
        } else {
            String originScheme = origin.getScheme();
            String originHost = origin.getHost();
            int originPort = origin.getPort();
            if (originPort == -1) {
                originPort = originScheme.equals("https") ? 443 : 80;
            }
            this.origin = originScheme + "://" + originHost + ":" + originPort;
        }
        this.requestedProtocols = protocols;
        this.secure = url.getScheme().equalsIgnoreCase("wss");
        this.connectTimeout = connectTimeout;
    }

    private void startIdleTimer(long delayInMilliseconds) {
        LOG.fine("Starting idle timer");
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer = null;
        }
        this.idleTimer = new Timer("IdleTimer", true);
        this.idleTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                WebSocketDelegateImpl.this.idleTimerHandler();
            }
        }, delayInMilliseconds);
    }

    private void idleTimerHandler() {
        LOG.fine("Idle timer scheduled");
        long idleDuration = System.currentTimeMillis() - this.lastMessageTimestamp.get();
        if (idleDuration > (long)this.idleTimeout.get()) {
            String message = "idle duration - " + idleDuration + " exceeded idle timeout - " + this.idleTimeout;
            LOG.fine(message);
            this.handleClose(null);
        } else {
            this.startIdleTimer((long)this.idleTimeout.get() - idleDuration);
        }
    }

    private void stopIdleTimer() {
        LOG.fine("Stopping idle timer");
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer = null;
        }
    }

    @Override
    public void setIdleTimeout(int milliSecond) {
        this.idleTimeout.set(milliSecond);
        if (milliSecond > 0) {
            this.lastMessageTimestamp.set(System.currentTimeMillis());
            this.startIdleTimer(milliSecond);
        } else {
            this.stopIdleTimer();
        }
    }

    @Override
    public void processOpen() {
        LOG.entering(CLASS_NAME, "processOpen");
        String scheme = this.url.getScheme();
        String host = this.url.getHost();
        int port = this.url.getPort();
        String path = this.url.getPath();
        if (port == -1) {
            port = scheme.equals("wss") ? 443 : 80;
        }
        LOG.fine("processOpen: Connecting to " + host + ":" + port);
        String cookiesUri = scheme.replace("ws", "http") + "://" + host + ":" + port + path + "/;e/cookies?.krn=" + Double.toString(Math.random()).substring(2);
        String query = this.url.getQuery();
        if (query != null && query.length() > 0) {
            cookiesUri = cookiesUri + "&" + query;
        }
        final HttpRequestDelegate cookiesRequest = this.HTTP_REQUEST_DELEGATE_FACTORY.createHttpRequestDelegate();
        cookiesRequest.setListener(new HttpRequestDelegateListener(){

            @Override
            public void opened(OpenEvent event) {
            }

            @Override
            public void readyStateChanged(ReadyStateChangedEvent event) {
            }

            @Override
            public void progressed(ProgressEvent progressEvent) {
            }

            @Override
            public void loaded(LoadEvent event) {
                switch (cookiesRequest.getStatusCode()) {
                    case 200: 
                    case 201: {
                        ByteBuffer responseBuf = cookiesRequest.getResponseText();
                        if (responseBuf == null || !responseBuf.hasRemaining()) break;
                        if (WebSocketDelegateImpl.isHTTPResponse(responseBuf)) {
                            try {
                                this.handleWrappedHTTPResponse(responseBuf);
                                return;
                            }
                            catch (Exception e1) {
                                WebSocketDelegateImpl.this.handleClose(e1);
                                throw new IllegalStateException("Handling wrapped HTTP response failed", e1);
                            }
                        }
                        WebSocketDelegateImpl.this.cookies = new String(responseBuf.array(), responseBuf.position(), responseBuf.remaining());
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 307: {
                        String location = cookiesRequest.getResponseHeader(WebSocketDelegateImpl.HEADER_LOCATION);
                        LOG.finest("Redirect to " + location);
                        try {
                            URI uri = new URI(location);
                            String query = uri.getQuery();
                            String newQuery = (query != null ? query + "&" : "") + ".kl=Y";
                            String redirectLocation = uri.getScheme().replace("http", "ws") + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath() + "?" + newQuery;
                            LOG.finest("Redirect as " + redirectLocation);
                            WebSocketDelegateImpl.this.listener.redirected(new RedirectEvent(redirectLocation));
                        }
                        catch (URISyntaxException e) {
                            LOG.severe("Redirect location invalid: " + location);
                        }
                        return;
                    }
                    case 401: {
                        String wwwAuthenticate = cookiesRequest.getResponseHeader(WebSocketDelegateImpl.HEADER_WWW_AUTHENTICATE);
                        WebSocketDelegateImpl.this.listener.authenticationRequested(new AuthenticateEvent(wwwAuthenticate));
                        return;
                    }
                    default: {
                        WebSocketDelegateImpl.this.readyState = ReadyState.CLOSED;
                        String s = "Cookies request: Invalid status code: " + cookiesRequest.getStatusCode();
                        WebSocketDelegateImpl.this.listener.errorOccurred(new ErrorEvent(new IllegalStateException(s)));
                        return;
                    }
                }
                WebSocketDelegateImpl.this.nativeConnect();
            }

            private void handleWrappedHTTPResponse(ByteBuffer responseBody) throws Exception {
                LOG.entering(CLASS_NAME, "cookiesRequest.handleWrappedHTTPResponse");
                String[] lines = WebSocketDelegateImpl.getLines(responseBody);
                int statusCode = Integer.parseInt(lines[0].split(" ")[1]);
                switch (statusCode) {
                    case 401: {
                        String wwwAuthenticate = null;
                        for (int i = 1; i < lines.length; ++i) {
                            if (!lines[i].startsWith(WebSocketDelegateImpl.WWW_AUTHENTICATE)) continue;
                            wwwAuthenticate = lines[i].substring(WebSocketDelegateImpl.WWW_AUTHENTICATE.length());
                            break;
                        }
                        LOG.finest("cookiesRequest.handleWrappedHTTPResponse: WWW-Authenticate: " + wwwAuthenticate);
                        if (wwwAuthenticate == null || "".equals(wwwAuthenticate)) {
                            LOG.severe("Missing authentication challenge in wrapped HTTP 401 response");
                            throw new IllegalStateException("Missing authentication challenge in wrapped HTTP 401 response");
                        }
                        if (!wwwAuthenticate.startsWith(WebSocketDelegateImpl.APPLICATION_PREFIX)) {
                            LOG.severe("Only Application challenges are supported by the client");
                            throw new IllegalStateException("Only Application challenges are supported by the client");
                        }
                        WebSocketDelegateImpl.this.listener.authenticationRequested(new AuthenticateEvent(wwwAuthenticate));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported wrapped response with HTTP status code " + statusCode);
                    }
                }
            }

            @Override
            public void closed(CloseEvent event) {
            }

            @Override
            public void errorOccurred(ErrorEvent event) {
                WebSocketDelegateImpl.this.readyState = ReadyState.CLOSED;
                WebSocketDelegateImpl.this.listener.errorOccurred(new ErrorEvent(event.getException()));
            }
        });
        try {
            URL cookiesUrl = new URL(cookiesUri);
            cookiesRequest.processOpen("GET", cookiesUrl, this.origin, false, this.connectTimeout);
            if (this.authorize != null) {
                cookiesRequest.setRequestHeader(HEADER_AUTHORIZATION, this.authorize);
            }
            this.postProcessOpen(cookiesRequest);
            cookiesRequest.processSend(null);
        }
        catch (Exception e1) {
            LOG.severe(e1.toString());
            this.readyState = ReadyState.CLOSED;
            this.listener.errorOccurred(new ErrorEvent(e1));
        }
    }

    protected void postProcessOpen(HttpRequestDelegate cookiesRequest) {
    }

    private static boolean isHTTPResponse(ByteBuffer buf) {
        boolean isHttpResponse = true;
        if (buf.remaining() >= HTTP_1_1_START_LEN) {
            for (int i = 0; i < HTTP_1_1_START_LEN; ++i) {
                if (buf.get(i) == HTTP_1_1_START_BYTES[i]) continue;
                isHttpResponse = false;
                break;
            }
        }
        return isHttpResponse;
    }

    private static String[] getLines(ByteBuffer buf) {
        ArrayList<String> lineList = new ArrayList<String>();
        while (buf.hasRemaining()) {
            byte next = buf.get();
            ArrayList<Byte> lineText = new ArrayList<Byte>();
            while (next != 13) {
                lineText.add(next);
                if (!buf.hasRemaining()) break;
                next = buf.get();
            }
            if (buf.hasRemaining()) {
                next = buf.get();
            }
            byte[] lineTextBytes = new byte[lineText.size()];
            int i = 0;
            for (Byte text : lineText) {
                lineTextBytes[i] = text;
                ++i;
            }
            try {
                lineList.add(new String(lineTextBytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Unrecognized Encoding from the server", e);
            }
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    protected void nativeConnect() {
        LOG.entering(CLASS_NAME, "nativeConnect");
        String host = this.url.getHost();
        int port = this.url.getPort();
        String scheme = this.url.getScheme();
        if (port == -1) {
            port = scheme.equals("wss") ? 443 : 80;
        }
        try {
            LOG.fine("WebSocketDelegate.nativeConnect(): Connecting to " + host + ":" + port);
            this.socket = this.BRIDGE_SOCKET_FACTORY.createSocket(this.secure);
            this.socket.connect(new InetSocketAddress(host, port), this.connectTimeout);
            this.socket.setKeepAlive(true);
            this.socket.setSoTimeout(0);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "WebSocketDelegateImpl nativeConnect(): " + e.getMessage(), e);
            this.readyState = ReadyState.CLOSED;
            this.listener.errorOccurred(new ErrorEvent(e));
            return;
        }
        this.negotiateWebSocketConnection(this.socket);
    }

    private void negotiateWebSocketConnection(BridgeSocket socket) {
        LOG.entering(CLASS_NAME, "negotiateWebSocketConnection", socket);
        try {
            int headerCount = 9 + (this.cookies == null ? 0 : 1);
            String[] headerNames = new String[headerCount];
            String[] headerValues = new String[headerCount];
            int headerIndex = 0;
            headerNames[headerIndex] = HEADER_UPGRADE;
            headerValues[headerIndex++] = WEB_SOCKET_LOWERCASE;
            headerNames[headerIndex] = HEADER_CONNECTION;
            headerValues[headerIndex++] = HEADER_UPGRADE;
            headerNames[headerIndex] = HEADER_HOST;
            headerValues[headerIndex++] = this.url.getAuthority();
            headerNames[headerIndex] = HEADER_ORIGIN;
            headerValues[headerIndex++] = this.origin;
            headerNames[headerIndex] = HEADER_WEBSOCKET_VERSION;
            headerValues[headerIndex++] = HEADER_VERSION;
            headerNames[headerIndex] = HEADER_WEBSOCKET_KEY;
            if (this.websocketKey == null) {
                this.websocketKey = this.base64Encode(this.randomBytes(16));
            }
            headerValues[headerIndex++] = this.websocketKey;
            if (this.requestedProtocols != null && this.requestedProtocols.length > 0) {
                String value;
                headerNames[headerIndex] = HEADER_PROTOCOL;
                if (this.requestedProtocols.length == 1) {
                    value = this.requestedProtocols[0];
                } else {
                    value = "";
                    for (int i = 0; i < this.requestedProtocols.length; ++i) {
                        if (i > 0) {
                            value = value + ",";
                        }
                        value = value + this.requestedProtocols[i];
                    }
                }
                headerValues[headerIndex++] = value;
            }
            if (this.cookies != null) {
                headerNames[headerIndex] = HEADER_COOKIE;
                headerValues[headerIndex++] = this.cookies;
            }
            if (this.authorize != null) {
                headerNames[headerIndex] = HEADER_AUTHORIZATION;
                headerValues[headerIndex] = this.authorize;
            }
            LOG.finer("Origin: " + this.origin);
            byte[] request = this.encodeGetRequest(this.url, headerNames, headerValues);
            OutputStream out = socket.getOutputStream();
            out.write(request);
            out.flush();
            InputStream in = socket.getInputStream();
            Thread readerThread = new Thread((Runnable)new SocketReader(in), "WebSocketDelegate socket reader");
            readerThread.setDaemon(true);
            readerThread.start();
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            this.handleError(e);
        }
    }

    public byte[] encodeGetRequest(URI requestURI, String[] names, String[] values) {
        LOG.entering(CLASS_NAME, "encodeGetRequest", new Object[]{requestURI, names, values});
        int requestSize = this.getEncodeRequestSize(requestURI, names, values);
        ByteBuffer buf = ByteBuffer.allocate(requestSize);
        buf.put(GET_BYTES);
        buf.put(SPACE_BYTES);
        String path = requestURI.getPath();
        if (requestURI.getQuery() != null) {
            path = path + "?" + requestURI.getQuery();
        }
        buf.put(path.getBytes());
        buf.put(SPACE_BYTES);
        buf.put(HTTP_1_1_BYTES);
        buf.put(CRLF_BYTES);
        for (int i = 0; i < names.length; ++i) {
            String headerName = names[i];
            String headerValue = values[i];
            if (headerName == null || headerValue == null) continue;
            buf.put(headerName.getBytes());
            buf.put(COLON_BYTES);
            buf.put(SPACE_BYTES);
            buf.put(headerValue.getBytes());
            buf.put(CRLF_BYTES);
        }
        buf.put(CRLF_BYTES);
        buf.flip();
        return buf.array();
    }

    private int getEncodeRequestSize(URI requestURI, String[] names, String[] values) {
        int size = 0;
        size += GET_BYTES.length;
        size += SPACE_BYTES.length;
        String path = requestURI.getPath();
        if (requestURI.getQuery() != null) {
            path = path + "?" + requestURI.getQuery();
        }
        size += path.getBytes().length;
        size += SPACE_BYTES.length;
        size += HTTP_1_1_BYTES.length;
        size += CRLF_BYTES.length;
        for (int i = 0; i < names.length; ++i) {
            String headerName = names[i];
            String headerValue = values[i];
            if (headerName == null || headerValue == null) continue;
            size += headerName.getBytes().length;
            size += COLON_BYTES.length;
            size += SPACE_BYTES.length;
            size += headerValue.getBytes().length;
            size += CRLF_BYTES.length;
        }
        LOG.fine("Returning a request size of " + (size += CRLF_BYTES.length));
        return size;
    }

    @Override
    public void processDisconnect() throws IOException {
        this.processDisconnect((short)0, null);
    }

    @Override
    public void processDisconnect(short code, String reason) throws IOException {
        LOG.entering(CLASS_NAME, "disconnect");
        if (this.readyState == ReadyState.OPEN) {
            ByteBuffer data;
            this.readyState = ReadyState.CLOSING;
            if (code == 0) {
                data = ByteBuffer.allocate(0);
            } else {
                Charset cs;
                if (code != 1000 && (code < 3000 || code > 4999)) {
                    throw new IllegalArgumentException("code must equal to 1000 or in range 3000 to 4999");
                }
                Buffer reasonBuf = null;
                if (reason != null && reason.length() > 0 && (reasonBuf = (cs = Charset.forName("UTF-8")).encode(reason)).limit() > 123) {
                    throw new IllegalArgumentException("Reason is longer than 123 bytes");
                }
                data = ByteBuffer.allocate(2 + (reasonBuf == null ? 0 : reasonBuf.remaining()));
                data.putShort(code);
                if (reasonBuf != null) {
                    data.put((ByteBuffer)reasonBuf);
                }
                data.flip();
            }
            this.send(WsFrameEncodingSupport.rfc6455Encode(new WsMessage(data, WsMessage.Kind.CLOSE), new Random().nextInt()));
        } else if (this.readyState == ReadyState.CONNECTING) {
            this.stopReaderThread = true;
            this.handleClose(null);
        }
        Timer t = new Timer("SocketCloseTimer", true);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (WebSocketDelegateImpl.this.readyState != ReadyState.CLOSED) {
                        WebSocketDelegateImpl.this.stopIdleTimer();
                        WebSocketDelegateImpl.this.closeSocket();
                    }
                }
                finally {
                    this.cancel();
                }
            }
        }, 5000L);
    }

    @Override
    public void processAuthorize(String authorize) {
        LOG.entering(CLASS_NAME, "processAuthorize", authorize);
        this.authorize = authorize;
        this.processOpen();
    }

    @Override
    public void processSend(ByteBuffer data) {
        LOG.entering(CLASS_NAME, "processSend", data);
        ByteBuffer frame = WsFrameEncodingSupport.rfc6455Encode(new WsMessage(data, WsMessage.Kind.BINARY), new Random().nextInt());
        this.send(frame);
    }

    @Override
    public void processSend(String data) {
        LOG.entering(CLASS_NAME, "processSend", data);
        ByteBuffer buf = null;
        try {
            buf = ByteBuffer.wrap(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            String s = "The platform should have already been checked to see if UTF-8 encoding is supported";
            throw new IllegalStateException(s);
        }
        ByteBuffer frame = WsFrameEncodingSupport.rfc6455Encode(new WsMessage(buf, WsMessage.Kind.TEXT), new Random().nextInt());
        this.send(frame);
    }

    private void send(ByteBuffer frame) {
        LOG.entering(CLASS_NAME, "send", frame);
        if (this.socket == null) {
            this.handleError(new IllegalStateException("Socket is null"));
        }
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            int offset = frame.position();
            int len = frame.remaining();
            outputStream.write(frame.array(), offset, len);
            outputStream.flush();
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "While sending: " + e.getMessage(), e);
            this.handleError(e);
        }
    }

    protected URI getUrl() {
        LOG.exiting(CLASS_NAME, "getUrl", this.url);
        return this.url;
    }

    protected URI getOrigin() {
        LOG.exiting(CLASS_NAME, "getOrigin", this.originUri);
        return this.originUri;
    }

    private void closeSocket() {
        try {
            LOG.log(Level.FINE, "Closing socket");
            Thread.sleep(100L);
            if (this.socket != null && this.readyState != ReadyState.CLOSED) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "While closing socket: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            LOG.log(Level.FINE, "While closing socket: " + e.getMessage(), e);
        }
        finally {
            this.readyState = ReadyState.CLOSED;
            this.socket = null;
        }
    }

    private void handleClose(Exception ex) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.stopIdleTimer();
                this.closeSocket();
            }
            finally {
                if (ex == null) {
                    this.listener.closed(new CloseEvent(this.code, this.wasClean, this.reason));
                } else {
                    this.listener.closed(new CloseEvent(ex));
                }
            }
        }
    }

    private void handleError(Exception ex) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.closeSocket();
            }
            finally {
                this.listener.errorOccurred(new ErrorEvent(ex));
            }
        }
    }

    private byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        Random r = new Random();
        r.nextBytes(bytes);
        return bytes;
    }

    private String base64Encode(byte[] bytes) {
        return Base64Util.encode(ByteBuffer.wrap(bytes));
    }

    @Override
    public void setListener(WebSocketDelegateListener listener) {
        this.listener = listener;
    }

    class SocketReader
    implements Runnable {
        private final String CLASS_NAME = SocketReader.class.getName();
        private static final String HTTP_101_MESSAGE = "HTTP/1.1 101 Web Socket Protocol Handshake";
        private static final String UPGRADE_HEADER = "Upgrade: ";
        private static final int UPGRADE_HEADER_LENGTH = 9;
        private static final String UPGRADE_VALUE = "websocket";
        private static final String CONNECTION_MESSAGE = "Connection: Upgrade";
        private static final String WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
        private static final String WEBSOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
        private static final String WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
        ConnectionStatus state = ConnectionStatus.START;
        Boolean upgradeReceived = false;
        Boolean connectionReceived = false;
        Boolean websocketAcceptReceived = false;
        InputStream inputStream = null;

        public SocketReader(InputStream inputStream) throws IOException {
            LOG.entering(this.CLASS_NAME, "<init>");
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                LOG.entering(this.CLASS_NAME, "run");
                try {
                    while (!WebSocketDelegateImpl.this.stopReaderThread && !WebSocketDelegateImpl.this.connectionUpgraded) {
                        if (this.state == ConnectionStatus.ERRORED) {
                            throw new IllegalArgumentException("WebSocket Connection upgrade unsuccessful");
                        }
                        String line = this.readLine(this.inputStream);
                        if ((line = line.trim()).startsWith(WEBSOCKET_EXTENSIONS)) {
                            WebSocketDelegateImpl.this.extensions = line.substring(WEBSOCKET_EXTENSIONS.length() + 1).trim();
                            continue;
                        }
                        if (line.startsWith("Sec-WebSocket-Protocol")) {
                            WebSocketDelegateImpl.this.secProtocol = line.substring("Sec-WebSocket-Protocol".length() + 1).trim();
                            continue;
                        }
                        if (this.state != ConnectionStatus.COMPLETED) {
                            this.processLine(line);
                        }
                        if (this.state != ConnectionStatus.COMPLETED) continue;
                        WebSocketDelegateImpl.this.connectionUpgraded = this.websocketAcceptReceived != false && this.upgradeReceived != false && this.connectionReceived != false;
                        if (WebSocketDelegateImpl.this.connectionUpgraded) {
                            WebSocketDelegateImpl.this.readyState = ReadyState.OPEN;
                            WebSocketDelegateImpl.this.listener.opened(new OpenEvent(WebSocketDelegateImpl.this.secProtocol));
                            WebSocketDelegateImpl.this.lastMessageTimestamp.set(System.currentTimeMillis());
                            break;
                        }
                        throw new IllegalArgumentException("WebSocket Connection upgrade unsuccessful");
                    }
                    if (!WebSocketDelegateImpl.this.connectionUpgraded && !WebSocketDelegateImpl.this.stopReaderThread) {
                        throw new IllegalArgumentException("WebSocket Connection upgrade unsuccessful");
                    }
                    FrameProcessor frameProcessor = new FrameProcessor(new FrameProcessorListener(){

                        @Override
                        public void messageReceived(ByteBuffer buffer, String messageType) {
                            WebSocketDelegateImpl.this.lastMessageTimestamp.set(System.currentTimeMillis());
                            if (messageType == "TEXT" || messageType == "BINARY") {
                                if (WebSocketDelegateImpl.this.readyState == ReadyState.OPEN) {
                                    WebSocketDelegateImpl.this.listener.messageReceived(new MessageEvent(buffer, null, null, messageType));
                                }
                            } else if (messageType == "PING") {
                                ByteBuffer frame = WsFrameEncodingSupport.rfc6455Encode(new WsMessage(buffer, WsMessage.Kind.PONG), new Random().nextInt());
                                WebSocketDelegateImpl.this.send(frame);
                            } else if (messageType == "CLOSE") {
                                WebSocketDelegateImpl.this.wasClean = true;
                                if (buffer.remaining() < 2) {
                                    WebSocketDelegateImpl.this.code = 1005;
                                } else {
                                    WebSocketDelegateImpl.this.code = buffer.getShort();
                                    if (buffer.hasRemaining()) {
                                        WebSocketDelegateImpl.this.reason = UTF8.decode(buffer).toString();
                                    }
                                }
                                if (WebSocketDelegateImpl.this.readyState == ReadyState.OPEN) {
                                    WebSocketDelegateImpl.this.readyState = ReadyState.CLOSING;
                                    buffer.flip();
                                    WsMessage message = new WsMessage(buffer, WsMessage.Kind.CLOSE);
                                    ByteBuffer frame = WsFrameEncodingSupport.rfc6455Encode(message, new Random().nextInt());
                                    WebSocketDelegateImpl.this.send(frame);
                                }
                                if (WebSocketDelegateImpl.this.readyState == ReadyState.CONNECTING) {
                                    WebSocketDelegateImpl.this.readyState = ReadyState.CLOSING;
                                }
                            } else {
                                throw new IllegalArgumentException("Unknown message type: " + messageType);
                            }
                        }
                    });
                    Exception exception = null;
                    try {
                        do {
                            if (!WebSocketDelegateImpl.this.stopReaderThread) continue;
                            LOG.fine("SocketReader: Stopping reader thread; closing socket");
                            break block15;
                        } while (frameProcessor.process(this.inputStream));
                        LOG.fine("SocketReader: end of stream");
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                    finally {
                        this.handleClose(exception);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "SocketReader: " + e.getMessage(), e);
                    WebSocketDelegateImpl.this.listener.errorOccurred(new ErrorEvent(e));
                }
            }
        }

        private void handleClose(Exception ex) {
            WebSocketDelegateImpl.this.handleClose(ex);
        }

        private String readLine(InputStream reader) throws Exception {
            int ch;
            ByteBuffer input = ByteBuffer.allocate(512);
            while ((ch = reader.read()) != -1) {
                if (!IoBufferUtil.canAccomodate(input, 1)) {
                    input = IoBufferUtil.expandBuffer(input, 512);
                }
                if (ch == 10) {
                    input.put((byte)0);
                    input.flip();
                    return new String(input.array());
                }
                input.put((byte)ch);
            }
            return "";
        }

        private void processLine(String line) throws Exception {
            LOG.entering(this.CLASS_NAME, "processLine", line);
            switch (this.state) {
                case START: {
                    if (line.equals(HTTP_101_MESSAGE)) {
                        this.state = ConnectionStatus.STATUS_101_READ;
                        break;
                    }
                    String s = "WebSocket upgrade failed: " + line;
                    LOG.severe(s);
                    this.state = ConnectionStatus.ERRORED;
                    WebSocketDelegateImpl.this.listener.errorOccurred(new ErrorEvent(new IllegalStateException(s)));
                    break;
                }
                case STATUS_101_READ: {
                    if (line == null || line.length() == 0) {
                        this.state = ConnectionStatus.COMPLETED;
                        break;
                    }
                    if (line.indexOf(UPGRADE_HEADER) == 0) {
                        this.upgradeReceived = "websocket".equalsIgnoreCase(line.substring(9));
                        break;
                    }
                    if (line.equals(CONNECTION_MESSAGE)) {
                        this.connectionReceived = true;
                        break;
                    }
                    if (line.indexOf(WEBSOCKET_ACCEPT) != 0) break;
                    String hashedKey = this.AcceptHash(WebSocketDelegateImpl.this.websocketKey);
                    this.websocketAcceptReceived = hashedKey.equals(line.substring(WEBSOCKET_ACCEPT.length() + 1).trim());
                    break;
                }
            }
        }

        public String AcceptHash(String key) throws NoSuchAlgorithmException {
            String input = key + WebSocketDelegateImpl.WEBSOCKET_GUID;
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(input.getBytes());
            return Base64Util.encode(ByteBuffer.wrap(hash));
        }
    }

    public static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }

    static enum ConnectionStatus {
        START,
        STATUS_101_READ,
        CONNECTION_UPGRADE_READ,
        COMPLETED,
        ERRORED;

    }
}

