/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.ws;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedHandler;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketSelectedHandlerImpl
extends WebSocketHandlerAdapter
implements WebSocketSelectedHandler {
    private static final String CLASS_NAME = WebSocketSelectedHandlerImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static WebSocketSelectedHandlerFactory FACTORY = new WebSocketSelectedHandlerFactory(){

        @Override
        public WebSocketSelectedHandlerImpl createSelectedHandler() {
            return new WebSocketSelectedHandlerImpl();
        }
    };
    protected WebSocketHandlerListener listener;

    public WebSocketSelectedHandlerImpl() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    @Override
    public void processConnect(WebSocketChannel channel, WSURI uri, String[] protocols) {
        LOG.entering(CLASS_NAME, "connect", channel);
        if (((WebSocketSelectedChannel)channel).readyState == ReadyState.CLOSED) {
            throw new IllegalStateException("WebSocket is already closed");
        }
        this.nextHandler.processConnect(channel, uri, protocols);
    }

    @Override
    public void processClose(WebSocketChannel channel, int code, String reason) {
        LOG.entering(CLASS_NAME, "processDisconnect");
        WebSocketSelectedChannel ch = (WebSocketSelectedChannel)channel;
        if (ch.readyState == ReadyState.OPEN || ch.readyState == ReadyState.CONNECTING) {
            ch.readyState = ReadyState.CLOSING;
            this.nextHandler.processClose(channel, code, reason);
        }
    }

    public void handleConnectionOpened(WebSocketChannel channel, String protocol) {
        LOG.entering(CLASS_NAME, "handleConnectionOpened");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState == ReadyState.CONNECTING) {
            selectedChannel.readyState = ReadyState.OPEN;
            this.listener.connectionOpened(channel, protocol);
        }
    }

    public void handleBinaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer message) {
        LOG.entering(CLASS_NAME, "handleMessageReceived", message);
        if (((WebSocketSelectedChannel)channel).readyState != ReadyState.OPEN) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, message.getHexDump());
        }
        this.listener.binaryMessageReceived(channel, message);
    }

    public void handleTextMessageReceived(WebSocketChannel channel, String message) {
        LOG.entering(CLASS_NAME, "handleTextMessageReceived", message);
        if (((WebSocketSelectedChannel)channel).readyState != ReadyState.OPEN) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, message);
        }
        this.listener.textMessageReceived(channel, message);
    }

    protected void handleConnectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
        LOG.entering(CLASS_NAME, "handleConnectionClosed");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState != ReadyState.CLOSED) {
            selectedChannel.readyState = ReadyState.CLOSED;
            this.listener.connectionClosed(channel, wasClean, code, reason);
        }
    }

    protected void handleConnectionClosed(WebSocketChannel channel, Exception ex) {
        LOG.entering(CLASS_NAME, "handleConnectionClosed");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState != ReadyState.CLOSED) {
            selectedChannel.readyState = ReadyState.CLOSED;
            this.listener.connectionClosed(channel, ex);
        }
    }

    protected void handleConnectionFailed(WebSocketChannel channel, Exception ex) {
        LOG.entering(CLASS_NAME, "connectionFailed");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState != ReadyState.CLOSED) {
            selectedChannel.readyState = ReadyState.CLOSED;
            this.listener.connectionFailed(channel, ex);
        }
    }

    @Override
    public void setNextHandler(WebSocketHandler nextHandler) {
        this.nextHandler = nextHandler;
        nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketSelectedHandlerImpl.this.handleConnectionOpened(channel, protocol);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer message) {
                WebSocketSelectedHandlerImpl.this.handleBinaryMessageReceived(channel, message);
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketSelectedHandlerImpl.this.handleTextMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketSelectedHandlerImpl.this.handleConnectionClosed(channel, wasClean, code, reason);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketSelectedHandlerImpl.this.handleConnectionClosed(channel, ex);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                WebSocketSelectedHandlerImpl.this.handleConnectionFailed(channel, ex);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
            }
        });
    }

    @Override
    public void setListener(WebSocketHandlerListener listener) {
        this.listener = listener;
    }

    public static interface WebSocketSelectedHandlerFactory {
        public WebSocketSelectedHandler createSelectedHandler();
    }
}

