/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import io.particle.android.sdk.cloud.FunctionArgs;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.models.SignUpInfo;
import java.util.List;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.Field;
import retrofit.http.FormUrlEncoded;
import retrofit.http.GET;
import retrofit.http.Multipart;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Part;
import retrofit.http.Path;
import retrofit.mime.TypedOutput;

public class ApiDefs {

    public static interface IdentityApi {
        @POST(value="/v1/users")
        public Response signUp(@Body SignUpInfo var1);

        @POST(value="/v1/products/{productId}/customers")
        public Responses.LogInResponse signUpAndLogInWithCustomer(@Body SignUpInfo var1, @Path(value="productId") Integer var2);

        @FormUrlEncoded
        @POST(value="/oauth/token")
        public Responses.LogInResponse logIn(@Field(value="grant_type") String var1, @Field(value="username") String var2, @Field(value="password") String var3);

        @FormUrlEncoded
        @POST(value="/v1/user/password-reset")
        public Response requestPasswordReset(@Field(value="username") String var1);

        @FormUrlEncoded
        @POST(value="/v1/products/{productId}/customers/reset_password")
        public Response requestPasswordResetForCustomer(@Field(value="email") String var1, @Path(value="productId") Integer var2);
    }

    public static interface CloudApi {
        @GET(value="/v1/devices")
        public List<Responses.Models.SimpleDevice> getDevices();

        @GET(value="/v1/devices/{deviceID}")
        public Responses.Models.CompleteDevice getDevice(@Path(value="deviceID") String var1);

        @FormUrlEncoded
        @PUT(value="/v1/devices/{deviceID}")
        public Response nameDevice(@Path(value="deviceID") String var1, @Field(value="name") String var2);

        @FormUrlEncoded
        @PUT(value="/v1/devices/{deviceID}")
        public Response flashKnownApp(@Path(value="deviceID") String var1, @Field(value="app") String var2);

        @Multipart
        @PUT(value="/v1/devices/{deviceID}")
        public Response flashFile(@Path(value="deviceID") String var1, @Part(value="file") TypedOutput var2);

        @POST(value="/v1/devices/{deviceID}/{function}")
        public Responses.CallFunctionResponse callFunction(@Path(value="deviceID") String var1, @Path(value="function") String var2, @Body FunctionArgs var3);

        @GET(value="/v1/devices/{deviceID}/{variable}")
        public Responses.ReadObjectVariableResponse getVariable(@Path(value="deviceID") String var1, @Path(value="variable") String var2);

        @GET(value="/v1/devices/{deviceID}/{variable}")
        public Responses.ReadIntVariableResponse getIntVariable(@Path(value="deviceID") String var1, @Path(value="variable") String var2);

        @GET(value="/v1/devices/{deviceID}/{variable}")
        public Responses.ReadStringVariableResponse getStringVariable(@Path(value="deviceID") String var1, @Path(value="variable") String var2);

        @GET(value="/v1/devices/{deviceID}/{variable}")
        public Responses.ReadDoubleVariableResponse getDoubleVariable(@Path(value="deviceID") String var1, @Path(value="variable") String var2);

        @FormUrlEncoded
        @POST(value="/v1/devices/events")
        public Responses.SimpleResponse publishEvent(@Field(value="name") String var1, @Field(value="data") String var2, @Field(value="private") boolean var3, @Field(value="ttl") int var4);

        @FormUrlEncoded
        @POST(value="/v1/device_claims")
        public Responses.ClaimCodeResponse generateClaimCode(@Field(value="blank") String var1);

        @FormUrlEncoded
        @POST(value="/v1/products/{productId}/device_claims")
        public Responses.ClaimCodeResponse generateClaimCodeForOrg(@Field(value="blank") String var1, @Path(value="productId") Integer var2);

        @FormUrlEncoded
        @POST(value="/v1/devices")
        public Responses.SimpleResponse claimDevice(@Field(value="id") String var1);

        @DELETE(value="/v1/devices/{deviceID}")
        public Responses.SimpleResponse unclaimDevice(@Path(value="deviceID") String var1);
    }
}

