/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kaazing.net.URLStreamHandlerFactorySpi;

public final class URLFactory {
    private static final Map<String, URLStreamHandlerFactorySpi> _factories;

    private URLFactory() {
    }

    public static URL createURL(String spec) throws MalformedURLException {
        return URLFactory.createURL(null, spec);
    }

    public static URL createURL(URL context, String spec) throws MalformedURLException {
        if (spec == null || spec.trim().length() == 0) {
            return new URL(context, spec);
        }
        String protocol = URI.create(spec).getScheme();
        URLStreamHandlerFactory factory = _factories.get(protocol);
        if (factory == null) {
            return new URL(context, spec);
        }
        URLStreamHandler handler = factory.createURLStreamHandler(protocol);
        return new URL(context, spec, handler);
    }

    public static URL createURL(String protocol, String host, String file) throws MalformedURLException {
        return URLFactory.createURL(protocol, host, -1, file);
    }

    public static URL createURL(String protocol, String host, int port, String file) throws MalformedURLException {
        URLStreamHandlerFactory factory = _factories.get(protocol);
        if (factory == null) {
            return new URL(protocol, host, port, file);
        }
        URLStreamHandler handler = factory.createURLStreamHandler(protocol);
        return new URL(protocol, host, port, file, handler);
    }

    static {
        Class<URLStreamHandlerFactorySpi> clazz = URLStreamHandlerFactorySpi.class;
        ServiceLoader<URLStreamHandlerFactorySpi> loader = ServiceLoader.load(clazz);
        _factories = new HashMap<String, URLStreamHandlerFactorySpi>();
        for (URLStreamHandlerFactorySpi factory : loader) {
            Collection<String> protocols = factory.getSupportedProtocols();
            if (protocols == null || protocols.isEmpty()) continue;
            for (String protocol : protocols) {
                _factories.put(protocol, factory);
            }
        }
    }
}

