/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.kaazing.gateway.client.util.URIUtils;

public abstract class GenericURI<T> {
    protected URI uri;

    protected GenericURI(String location) throws URISyntaxException {
        this(new URI(location));
    }

    protected GenericURI(URI uri) throws URISyntaxException {
        this.uri = uri;
        this.validateScheme();
    }

    protected abstract boolean isValidScheme(String var1);

    private void validateScheme() throws URISyntaxException {
        String scheme = this.getScheme();
        if (!this.isValidScheme(scheme)) {
            throw new URISyntaxException(this.uri.toString(), "Invalid scheme");
        }
    }

    protected abstract T duplicate(URI var1);

    public T replacePath(String path) {
        return this.duplicate(URIUtils.replacePath(this.uri, path));
    }

    public T addQueryParameter(String newParam) {
        String queryParams = this.uri.getQuery();
        queryParams = queryParams == null ? newParam : queryParams + "&" + newParam;
        return this.duplicate(URIUtils.replaceQueryParameters(this.uri, queryParams));
    }

    public URI getURI() {
        return this.uri;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String toString() {
        return this.uri.toString();
    }
}

