/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.kaazing.gateway.client.transport.Event;

public class ProgressEvent
extends Event {
    private static final String CLASS_NAME = ProgressEvent.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private int bytesTotal;
    private int bytesLoaded;
    private ByteBuffer payload;

    public ProgressEvent(ByteBuffer payload, int bytesLoaded, int bytesTotal) {
        super("progress");
        LOG.entering(CLASS_NAME, "<init>", new Object[]{payload, bytesLoaded, bytesTotal});
        this.payload = payload;
        this.bytesLoaded = bytesLoaded;
        this.bytesTotal = bytesTotal;
    }

    public int getBytesTotal() {
        LOG.exiting(CLASS_NAME, "getBytesTotal", this.bytesTotal);
        return this.bytesTotal;
    }

    public int getBytesLoaded() {
        LOG.exiting(CLASS_NAME, "getBytesLoaded", this.bytesLoaded);
        return this.bytesLoaded;
    }

    public ByteBuffer getPayload() {
        LOG.exiting(CLASS_NAME, "getPayload", this.payload);
        return this.payload;
    }

    @Override
    public String toString() {
        String ret = "ProgressEvent [type=" + this.type + " payload=" + this.payload + "{";
        for (Object a : this.params) {
            ret = ret + a + " ";
        }
        return ret + "}]";
    }
}

