/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import java.util.logging.Logger;

public class HttpRequestUtil {
    private static final String CLASS_NAME = HttpRequestUtil.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final String[] INVALID_HEADERS = new String[]{"Accept-Charset", "Accept-Encoding", "Connection", "Content-Length", "Content-Transfer-Encoding", "Date", "Expect", "Host", "Keep-Alive", "Referer", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "Via"};

    private HttpRequestUtil() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    public static void validateHeader(String header) {
        LOG.entering(CLASS_NAME, "validateHeader", header);
        if (header == null || header.length() == 0) {
            throw new IllegalArgumentException("Invalid header in the HTTP request");
        }
        String lowerCaseHeader = header.toLowerCase();
        if (lowerCaseHeader.startsWith("proxy-") || lowerCaseHeader.startsWith("sec-")) {
            throw new IllegalArgumentException("Headers starting with Proxy-* or Sec-* are prohibited");
        }
        for (String prohibited : INVALID_HEADERS) {
            if (!header.equalsIgnoreCase(prohibited)) continue;
            throw new IllegalArgumentException("Headers starting with Proxy-* or Sec-* are prohibited");
        }
    }
}

