/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.Channel;
import org.kaazing.gateway.client.impl.auth.AuthenticationUtil;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandlerAdapter;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedChannel;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.StringUtils;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.auth.ChallengeRequest;
import org.kaazing.net.auth.ChallengeResponse;
import org.kaazing.net.impl.util.ResumableTimer;

public class HttpRequestAuthenticationHandler
extends HttpRequestHandlerAdapter {
    private static final String CLASS_NAME = HttpRequestAuthenticationHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate: ";
    private static final String APPLICATION_PREFIX = "Application ";
    private static final String HTTP_1_1_START = "HTTP/1.1";
    private static final int HTTP_1_1_START_LEN = "HTTP/1.1".length();
    private static final byte[] HTTP_1_1_START_BYTES = StringUtils.getUtf8Bytes("HTTP/1.1");

    private void handleClearAuthenticationData(HttpRequest request) {
        Channel channel = this.getWebSocketChannel(request);
        if (channel == null) {
            return;
        }
        ChallengeHandler nextChallengeHandler = null;
        if (channel.challengeResponse != null) {
            nextChallengeHandler = channel.challengeResponse.getNextChallengeHandler();
            channel.challengeResponse.clearCredentials();
            channel.challengeResponse = null;
        }
        channel.challengeResponse = new ChallengeResponse(null, nextChallengeHandler);
    }

    private void handleRemoveAuthenticationData(HttpRequest request) {
        this.handleClearAuthenticationData(request);
    }

    protected static String[] getLines(WrappedByteBuffer buf) {
        ArrayList<String> lineList = new ArrayList<String>();
        while (buf.hasRemaining()) {
            byte next = buf.get();
            ArrayList<Byte> lineText = new ArrayList<Byte>();
            while (next != 13) {
                lineText.add(next);
                if (!buf.hasRemaining()) break;
                next = buf.get();
            }
            if (buf.hasRemaining()) {
                next = buf.get();
            }
            byte[] lineTextBytes = new byte[lineText.size()];
            int i = 0;
            for (Byte text : lineText) {
                lineTextBytes[i] = text;
                ++i;
            }
            lineList.add(new String(lineTextBytes, UTF_8));
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    public static boolean isHTTPResponse(WrappedByteBuffer buf) {
        if (buf.remaining() < HTTP_1_1_START_LEN) {
            return false;
        }
        for (int i = 0; i < HTTP_1_1_START_LEN; ++i) {
            if (buf.getAt(i) == HTTP_1_1_START_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    private void onLoadWrappedHTTPResponse(HttpRequest request, HttpResponse response) throws Exception {
        String wwwAuthenticate;
        LOG.entering(CLASS_NAME, "onLoadWrappedHTTPResponse");
        WrappedByteBuffer responseBody = response.getBody();
        String[] lines = HttpRequestAuthenticationHandler.getLines(responseBody);
        int statusCode = Integer.parseInt(lines[0].split(" ")[1]);
        if (statusCode == 401) {
            wwwAuthenticate = null;
            for (int i = 1; i < lines.length; ++i) {
                if (!lines[i].startsWith(WWW_AUTHENTICATE)) continue;
                wwwAuthenticate = lines[i].substring(WWW_AUTHENTICATE.length());
                break;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("connectToWebSocket.onLoadWrappedHTTPResponse: WWW-Authenticate: " + StringUtils.stripControlCharacters(wwwAuthenticate));
            }
            if (wwwAuthenticate == null || "".equals(wwwAuthenticate)) {
                throw new IllegalStateException("Missing authentication challenge in wrapped HTTP 401 response");
            }
            if (!wwwAuthenticate.startsWith(APPLICATION_PREFIX)) {
                throw new IllegalStateException("Only Application challenges are supported by the client");
            }
        } else {
            throw new IllegalStateException("Unsupported wrapped response with HTTP status code " + statusCode);
        }
        String rawChallenge = wwwAuthenticate.substring(APPLICATION_PREFIX.length());
        this.handle401(request, rawChallenge);
    }

    private void handle401(HttpRequest request, String challenge) throws Exception {
        WebSocketCompositeChannel parent;
        LOG.entering(CLASS_NAME, "handle401");
        HttpURI uri = request.getUri();
        WebSocketEmulatedChannel channel = (WebSocketEmulatedChannel)this.getWebSocketChannel(request);
        if (channel == null) {
            throw new IllegalStateException("There is no WebSocketChannel associated with this request");
        }
        if (this.isWebSocketClosing(request)) {
            return;
        }
        ResumableTimer connectTimer = null;
        if ((WebSocketCompositeChannel)channel.getParent() != null && (connectTimer = (parent = (WebSocketCompositeChannel)channel.getParent()).getConnectTimer()) != null) {
            connectTimer.pause();
        }
        channel.authenticationReceived = true;
        String challengeUrl = channel.getLocation().toString();
        if (channel.redirectUri != null) {
            String path = channel.redirectUri.getPath();
            if (path != null && path.contains("/;e/")) {
                int index = path.indexOf("/;e/");
                path = path.substring(0, index);
            }
            challengeUrl = channel.redirectUri.getScheme() + "://" + channel.redirectUri.getURI().getAuthority() + path;
        }
        ChallengeRequest challengeRequest = new ChallengeRequest(challengeUrl, challenge);
        try {
            channel.challengeResponse = AuthenticationUtil.getChallengeResponse(channel, challengeRequest, channel.challengeResponse);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage());
            this.handleClearAuthenticationData(request);
            throw new IllegalStateException("Unexpected error processing challenge " + challenge, e);
        }
        if (channel.challengeResponse == null || channel.challengeResponse.getCredentials() == null) {
            throw new IllegalStateException("No response possible for challenge " + challenge);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("response from challenge handler = " + StringUtils.stripControlCharacters(String.valueOf(channel.challengeResponse.getCredentials())));
        }
        try {
            HttpRequest newRequest = new HttpRequest(request.getMethod(), uri, request.isAsync());
            newRequest.parent = request.parent;
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                newRequest.setHeader(entry.getKey(), entry.getValue());
            }
            if (connectTimer != null) {
                connectTimer.resume();
            }
            this.processOpen(newRequest);
        }
        catch (Exception e1) {
            LOG.log(Level.FINE, e1.getMessage(), e1);
            throw new Exception("Unable to authenticate user", e1);
        }
    }

    @Override
    public void processOpen(HttpRequest request) {
        WebSocketEmulatedChannel channel = (WebSocketEmulatedChannel)this.getWebSocketChannel(request);
        if (channel != null) {
            if (this.isWebSocketClosing(request)) {
                return;
            }
            if (channel.challengeResponse.getCredentials() != null) {
                String credentials = new String(channel.challengeResponse.getCredentials());
                LOG.finest("requestOpened: Authorization: " + StringUtils.stripControlCharacters(credentials));
                request.setHeader(HEADER_AUTHORIZATION, credentials);
                this.handleClearAuthenticationData(request);
            }
        }
        this.nextHandler.processOpen(request);
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        super.setNextHandler(handler);
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.listener.requestReady(request);
            }

            @Override
            public void requestOpened(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.listener.requestOpened(request);
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
                HttpRequestAuthenticationHandler.this.listener.requestProgressed(request, payload);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                int responseCode = response.getStatusCode();
                switch (responseCode) {
                    case 200: {
                        WrappedByteBuffer responseBuffer = response.getBody();
                        if (HttpRequestAuthenticationHandler.isHTTPResponse(responseBuffer)) {
                            try {
                                HttpRequestAuthenticationHandler.this.onLoadWrappedHTTPResponse(request, response);
                            }
                            catch (Exception e) {
                                LOG.log(Level.FINE, e.getMessage(), e);
                                HttpRequestAuthenticationHandler.this.listener.errorOccurred(request, e);
                            }
                            break;
                        }
                        HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                        HttpRequestAuthenticationHandler.this.listener.requestLoaded(request, response);
                        break;
                    }
                    case 401: {
                        String challenge = response.getHeader(HttpRequestAuthenticationHandler.HEADER_WWW_AUTHENTICATE);
                        try {
                            HttpRequestAuthenticationHandler.this.handle401(request, challenge);
                        }
                        catch (Exception e) {
                            LOG.log(Level.FINE, e.getMessage());
                            HttpRequestAuthenticationHandler.this.listener.errorOccurred(request, e);
                        }
                        break;
                    }
                    default: {
                        HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                        HttpRequestAuthenticationHandler.this.listener.requestLoaded(request, response);
                    }
                }
            }

            @Override
            public void requestClosed(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                HttpRequestAuthenticationHandler.this.listener.errorOccurred(request, exception);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                HttpRequestAuthenticationHandler.this.listener.requestAborted(request);
            }
        });
    }

    @Override
    public void setListener(HttpRequestListener listener) {
        this.listener = listener;
    }
}

