/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.impl.util;

import java.util.concurrent.ArrayBlockingQueue;

public class BlockingQueueImpl<E>
extends ArrayBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    private static final int _QUEUE_CAPACITY = 32;
    private boolean _done = false;

    public BlockingQueueImpl() {
        super(32, true);
    }

    public synchronized void done() {
        this._done = true;
        this.notifyAll();
    }

    public boolean isDone() {
        return this._done;
    }

    public synchronized void reset() {
        this.notifyAll();
        this.clear();
        this._done = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object el;
        while ((el = super.peek()) == null && !this.isDone()) {
            BlockingQueueImpl blockingQueueImpl = this;
            synchronized (blockingQueueImpl) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    String s = "Reader has been interrupted maybe the connection is closed";
                    throw new RuntimeException(s);
                }
            }
        }
        if (el == null && this.isDone()) {
            String s = "Reader has been interrupted maybe the connection is closed";
            throw new RuntimeException(s);
        }
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E el) throws InterruptedException {
        BlockingQueueImpl blockingQueueImpl = this;
        synchronized (blockingQueueImpl) {
            while (this.size() == 32 && !this.isDone()) {
                this.wait();
            }
            if (this.isDone()) {
                this.notifyAll();
                return;
            }
        }
        super.put(el);
        blockingQueueImpl = this;
        synchronized (blockingQueueImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E el = null;
        BlockingQueueImpl blockingQueueImpl = this;
        synchronized (blockingQueueImpl) {
            while (this.isEmpty() && !this.isDone()) {
                this.wait();
            }
            if (this.isDone()) {
                this.notifyAll();
                if (this.size() == 0) {
                    String s = "Reader has been interrupted maybe the connection is closed";
                    throw new InterruptedException(s);
                }
            }
        }
        el = super.take();
        blockingQueueImpl = this;
        synchronized (blockingQueueImpl) {
            this.notifyAll();
        }
        return el;
    }
}

