/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.ws;

import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.Channel;
import org.kaazing.gateway.client.impl.Handler;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestAuthenticationHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestTransportHandler;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketReAuthenticateHandler
implements Handler {
    private static final String CLASS_NAME = WebSocketReAuthenticateHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_COOKIE = "Cookie";
    static final String HEADER_SET_COOKIE = "Set-Cookie";
    static final Charset UTF_8 = Charset.forName("UTF-8");
    HttpRequestHandler nextHandler;
    HttpRequestAuthenticationHandler authHandler = new HttpRequestAuthenticationHandler();
    HttpRequestHandler transportHandler = HttpRequestTransportHandler.DEFAULT_FACTORY.createHandler();

    public WebSocketReAuthenticateHandler() {
        this.setNextHandler(this.authHandler);
        this.authHandler.setNextHandler(this.transportHandler);
    }

    public void processOpen(Channel channel, HttpURI location) {
        LOG.entering(CLASS_NAME, "processOpen", location);
        HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.GET, location, false);
        request.parent = new Channel();
        request.parent.setParent(channel);
        this.nextHandler.processOpen(request);
    }

    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
            }

            @Override
            public void requestOpened(HttpRequest request) {
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer data) {
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
            }

            @Override
            public void requestAborted(HttpRequest request) {
            }

            @Override
            public void requestClosed(HttpRequest request) {
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
            }
        });
    }
}

