/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.support.annotation.CheckResult;
import android.support.annotation.Nullable;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.utils.Py;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class ParallelDeviceFetcher {
    private final ExecutorService executor;

    static ParallelDeviceFetcher newFetcherUsingExecutor(ExecutorService executor) {
        return new ParallelDeviceFetcher(executor);
    }

    private ParallelDeviceFetcher(ExecutorService executor) {
        this.executor = executor;
    }

    @CheckResult
    Collection<DeviceFetchResult> fetchDevicesInParallel(Collection<Responses.Models.SimpleDevice> simpleDevices, final ApiDefs.CloudApi cloudApi, int perDeviceTimeoutInSeconds) {
        List callables = Py.list();
        for (final Responses.Models.SimpleDevice device : simpleDevices) {
            callables.add(new Callable<DeviceFetchResult>(){

                @Override
                public DeviceFetchResult call() throws Exception {
                    return ParallelDeviceFetcher.this.getDevice(cloudApi, device.id);
                }
            });
        }
        List<Object> futures = Py.list();
        try {
            long timeout = perDeviceTimeoutInSeconds * simpleDevices.size();
            futures = this.executor.invokeAll(callables, timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List<DeviceFetchResult> results = Py.list();
        for (Future future : futures) {
            try {
                DeviceFetchResult result = (DeviceFetchResult)future.get();
                if (result == null) continue;
                results.add(result);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private DeviceFetchResult getDevice(ApiDefs.CloudApi cloudApi, String deviceID) {
        Responses.Models.CompleteDevice device = null;
        try {
            device = cloudApi.getDevice(deviceID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DeviceFetchResult(deviceID, device);
    }

    static class DeviceFetchResult {
        final String deviceId;
        @Nullable
        final Responses.Models.CompleteDevice fetchedDevice;

        DeviceFetchResult(String deviceId, @Nullable Responses.Models.CompleteDevice fetchedDevice) {
            this.deviceId = deviceId;
            this.fetchedDevice = fetchedDevice;
        }
    }
}

