/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.LongSparseArray;
import com.google.gson.Gson;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleEvent;
import io.particle.android.sdk.cloud.ParticleEventHandler;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.ParametersAreNonnullByDefault;
import org.kaazing.net.sse.SseEventReader;
import org.kaazing.net.sse.SseEventSource;
import org.kaazing.net.sse.SseEventSourceFactory;
import org.kaazing.net.sse.SseEventType;
import org.kaazing.net.sse.impl.AuthenticatedEventSourceFactory;
import retrofit.RetrofitError;

@ParametersAreNonnullByDefault
class EventsDelegate {
    private static final TLog log = TLog.get(EventsDelegate.class);
    private final ApiDefs.CloudApi cloudApi;
    private final EventApiUris uris;
    private final Gson gson;
    private final ExecutorService executor;
    private final SseEventSourceFactory eventSourceFactory;
    private final AtomicLong subscriptionIdGenerator = new AtomicLong(1L);
    private final LongSparseArray<EventReader> eventReaders = new LongSparseArray();

    EventsDelegate(ApiDefs.CloudApi cloudApi, Uri baseApiUri, Gson gson, ExecutorService executor, ParticleCloud cloud) {
        this.cloudApi = cloudApi;
        this.gson = gson;
        this.executor = executor;
        this.eventSourceFactory = new AuthenticatedEventSourceFactory(cloud);
        this.uris = new EventApiUris(baseApiUri);
    }

    @WorkerThread
    void publishEvent(String eventName, String event, int eventVisibility, int timeToLive) throws ParticleCloudException {
        boolean isPrivate = eventVisibility != 2;
        try {
            this.cloudApi.publishEvent(eventName, event, isPrivate, timeToLive);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    long subscribeToAllEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.subscribeToEventWithUri(this.uris.buildAllEventsUri(eventNamePrefix), handler);
    }

    @WorkerThread
    long subscribeToMyDevicesEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.subscribeToEventWithUri(this.uris.buildMyDevicesEventUri(eventNamePrefix), handler);
    }

    @WorkerThread
    long subscribeToDeviceEvents(@Nullable String eventNamePrefix, String deviceID, ParticleEventHandler eventHandler) throws IOException {
        return this.subscribeToEventWithUri(this.uris.buildSingleDeviceEventUri(eventNamePrefix, deviceID), eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void unsubscribeFromEventWithID(long eventListenerID) throws ParticleCloudException {
        LongSparseArray<EventReader> longSparseArray = this.eventReaders;
        synchronized (longSparseArray) {
            EventReader reader = (EventReader)this.eventReaders.get(eventListenerID);
            if (reader == null) {
                log.w("No event listener subscription found for ID '" + eventListenerID + "'!");
                return;
            }
            this.eventReaders.remove(eventListenerID);
            try {
                reader.stopListening();
            }
            catch (IOException e) {
                log.w("Error while trying to stop event listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long subscribeToEventWithUri(Uri uri, ParticleEventHandler handler) throws IOException {
        LongSparseArray<EventReader> longSparseArray = this.eventReaders;
        synchronized (longSparseArray) {
            long subscriptionId = this.subscriptionIdGenerator.getAndIncrement();
            EventReader reader = new EventReader(handler, this.executor, this.gson, uri, this.eventSourceFactory);
            this.eventReaders.put(subscriptionId, (Object)reader);
            log.d("Created event subscription with ID " + subscriptionId + " for URI " + uri);
            reader.startListening();
            return subscriptionId;
        }
    }

    private static class EventApiUris {
        private final String EVENTS = "events";
        private final Uri allEventsUri;
        private final Uri devicesBaseUri;
        private final Uri myDevicesEventsUri;

        EventApiUris(Uri baseUri) {
            this.allEventsUri = baseUri.buildUpon().path("/v1/events").build();
            this.devicesBaseUri = baseUri.buildUpon().path("/v1/devices").build();
            this.myDevicesEventsUri = this.devicesBaseUri.buildUpon().appendPath("events").build();
        }

        Uri buildAllEventsUri(@Nullable String eventNamePrefix) {
            if (Py.truthy(eventNamePrefix)) {
                return this.allEventsUri.buildUpon().appendPath(eventNamePrefix).build();
            }
            return this.allEventsUri;
        }

        Uri buildMyDevicesEventUri(@Nullable String eventNamePrefix) {
            if (Py.truthy(eventNamePrefix)) {
                return this.myDevicesEventsUri.buildUpon().appendPath(eventNamePrefix).build();
            }
            return this.myDevicesEventsUri;
        }

        Uri buildSingleDeviceEventUri(@Nullable String eventNamePrefix, String deviceId) {
            Uri.Builder builder = this.devicesBaseUri.buildUpon().appendPath(deviceId).appendPath("events");
            if (Py.truthy(eventNamePrefix)) {
                builder.appendPath(eventNamePrefix);
            }
            return builder.build();
        }
    }

    private static class EventReader {
        final ParticleEventHandler handler;
        final SseEventSource sseEventSource;
        final ExecutorService executor;
        final Gson gson;
        volatile Future<?> future;

        private EventReader(ParticleEventHandler handler, ExecutorService executor, Gson gson, Uri uri, SseEventSourceFactory factory) {
            this.handler = handler;
            this.executor = executor;
            this.gson = gson;
            try {
                this.sseEventSource = factory.createEventSource(URI.create(uri.toString()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        void startListening() throws IOException {
            this.sseEventSource.connect();
            final SseEventReader sseEventReader = this.sseEventSource.getEventReader();
            this.future = this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    EventReader.this.startHandlingEvents(sseEventReader);
                }
            });
        }

        void stopListening() throws IOException {
            this.future.cancel(false);
            this.sseEventSource.close();
        }

        private void startHandlingEvents(SseEventReader sseEventReader) {
            try {
                SseEventType type = sseEventReader.next();
                while (type != SseEventType.EOS) {
                    if (type != null && type.equals((Object)SseEventType.DATA)) {
                        CharSequence data = sseEventReader.getData();
                        String asStr = data.toString();
                        ParticleEvent event = (ParticleEvent)this.gson.fromJson(asStr, ParticleEvent.class);
                        this.handler.onEvent(sseEventReader.getName(), event);
                    } else {
                        log.w("type null or not data: " + (Object)((Object)type));
                    }
                    type = sseEventReader.next();
                }
            }
            catch (IOException e) {
                this.handler.onEventError(e);
            }
        }
    }
}

