/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.StringRes;
import android.util.Base64;
import com.google.gson.Gson;
import com.squareup.okhttp.OkHttpClient;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.R;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

@ParametersAreNonnullByDefault
public class ApiFactory {
    private static final int REGULAR_TIMEOUT = 35;
    private static final int PER_DEVICE_FAST_TIMEOUT = 5;
    private final Context ctx;
    private final TokenGetterDelegate tokenDelegate;
    private final OkHttpClient normalTimeoutClient;
    private final OkHttpClient fastTimeoutClient;
    private final OauthBasicAuthCredentialsProvider basicAuthCredentialsProvider;
    private final Gson gson;

    ApiFactory(Context ctx, TokenGetterDelegate tokenGetterDelegate, OauthBasicAuthCredentialsProvider basicAuthProvider) {
        this.ctx = ctx.getApplicationContext();
        this.tokenDelegate = tokenGetterDelegate;
        this.basicAuthCredentialsProvider = basicAuthProvider;
        this.gson = new Gson();
        this.normalTimeoutClient = ApiFactory.buildClientWithTimeout(35);
        this.fastTimeoutClient = ApiFactory.buildClientWithTimeout(5);
    }

    private static OkHttpClient buildClientWithTimeout(int timeoutInSeconds) {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout((long)timeoutInSeconds, TimeUnit.SECONDS);
        client.setReadTimeout((long)timeoutInSeconds, TimeUnit.SECONDS);
        client.setWriteTimeout((long)timeoutInSeconds, TimeUnit.SECONDS);
        return client;
    }

    ApiDefs.CloudApi buildNewCloudApi() {
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder(this.gson, this.normalTimeoutClient).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", "Bearer " + ApiFactory.this.tokenDelegate.getTokenValue());
            }
        }).build();
        return (ApiDefs.CloudApi)restAdapter.create(ApiDefs.CloudApi.class);
    }

    ApiDefs.CloudApi buildNewFastTimeoutCloudApi() {
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder(this.gson, this.fastTimeoutClient).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", "Bearer " + ApiFactory.this.tokenDelegate.getTokenValue());
            }
        }).build();
        return (ApiDefs.CloudApi)restAdapter.create(ApiDefs.CloudApi.class);
    }

    ApiDefs.IdentityApi buildNewIdentityApi() {
        final String basicAuthValue = this.getBasicAuthValue();
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder(this.gson, this.normalTimeoutClient).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", basicAuthValue);
            }
        }).build();
        return (ApiDefs.IdentityApi)restAdapter.create(ApiDefs.IdentityApi.class);
    }

    Uri getApiUri() {
        return Uri.parse((String)this.ctx.getString(R.string.api_base_uri));
    }

    Gson getGsonInstance() {
        return this.gson;
    }

    private String getBasicAuthValue() {
        String authString = String.format("%s:%s", this.basicAuthCredentialsProvider.getClientId(), this.basicAuthCredentialsProvider.getClientSecret());
        return "Basic " + Base64.encodeToString((byte[])authString.getBytes(), (int)2);
    }

    private RestAdapter.Builder buildCommonRestAdapterBuilder(Gson gson, OkHttpClient client) {
        return new RestAdapter.Builder().setClient((Client)new OkClient(client)).setConverter((Converter)new GsonConverter(gson)).setEndpoint(this.getApiUri().toString()).setLogLevel(RestAdapter.LogLevel.valueOf((String)this.ctx.getString(R.string.http_log_level)));
    }

    public static class ResourceValueBasicAuthCredentialsProvider
    implements OauthBasicAuthCredentialsProvider {
        private final String clientId;
        private final String clientSecret;

        public ResourceValueBasicAuthCredentialsProvider(Context ctx, @StringRes int clientIdResId, @StringRes int clientSecretResId) {
            this.clientId = ctx.getString(clientIdResId);
            this.clientSecret = ctx.getString(clientSecretResId);
        }

        @Override
        public String getClientId() {
            return this.clientId;
        }

        @Override
        public String getClientSecret() {
            return this.clientSecret;
        }
    }

    public static interface OauthBasicAuthCredentialsProvider {
        public String getClientId();

        public String getClientSecret();
    }

    public static interface TokenGetterDelegate {
        public String getTokenValue();
    }
}

