/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.url;

import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.kaazing.net.ws.impl.url.WsURLStreamHandlerFactorySpiImpl;
import org.kaazing.net.ws.impl.url.WssURLStreamHandlerImpl;

public class WssURLStreamHandlerFactorySpiImpl
extends WsURLStreamHandlerFactorySpiImpl {
    private static final Collection<String> _supportedProtocols = Collections.unmodifiableList(Arrays.asList("wss", "wse+ssl", "wssn"));

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (!_supportedProtocols.contains(protocol)) {
            throw new IllegalArgumentException(String.format("Protocol not supported '%s'", protocol));
        }
        return new WssURLStreamHandlerImpl(this.getExtensionFactories());
    }

    @Override
    public Collection<String> getSupportedProtocols() {
        return _supportedProtocols;
    }
}

