/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.util.ArrayMap;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.DeviceState;
import io.particle.android.sdk.cloud.EventsDelegate;
import io.particle.android.sdk.cloud.ParallelDeviceFetcher;
import io.particle.android.sdk.cloud.ParticleAccessToken;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.cloud.ParticleEventHandler;
import io.particle.android.sdk.cloud.ParticleEventVisibility;
import io.particle.android.sdk.cloud.ParticleUser;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.persistance.AppDataStorage;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;
import retrofit.RetrofitError;

@ParametersAreNonnullByDefault
public class ParticleCloud {
    private static final TLog log = TLog.get(ParticleCloud.class);
    private final ApiDefs.CloudApi mainApi;
    private final ApiDefs.IdentityApi identityApi;
    private final ApiDefs.CloudApi deviceFastTimeoutApi;
    private final AppDataStorage appDataStorage;
    private final TokenDelegate tokenDelegate = new TokenDelegate();
    private final LocalBroadcastManager broadcastManager;
    private final EventsDelegate eventsDelegate;
    private final ParallelDeviceFetcher parallelDeviceFetcher;
    private final Map<String, ParticleDevice> devices = new ArrayMap();
    private volatile ParticleAccessToken token;
    private volatile ParticleUser user;
    private static final Function<Responses.Models.SimpleDevice, String> toDeviceId = new Function<Responses.Models.SimpleDevice, String>(){

        public String apply(Responses.Models.SimpleDevice input) {
            return input.id;
        }
    };
    private static Maps.EntryTransformer<String, String, ParticleDevice.VariableType> sMapTransformer = new Maps.EntryTransformer<String, String, ParticleDevice.VariableType>(){

        public ParticleDevice.VariableType transformEntry(@Nullable String key, @Nullable String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "int32": {
                    return ParticleDevice.VariableType.INT;
                }
                case "double": {
                    return ParticleDevice.VariableType.DOUBLE;
                }
                case "string": {
                    return ParticleDevice.VariableType.STRING;
                }
            }
            return null;
        }
    };

    @Deprecated
    public static synchronized ParticleCloud get(Context context) {
        log.w("ParticleCloud.get() is deprecated and will be removed before the 1.0 release. Use ParticleCloudSDK.getCloud() instead!");
        if (!ParticleCloudSDK.isInitialized()) {
            ParticleCloudSDK.init(context);
        }
        return ParticleCloudSDK.getCloud();
    }

    ParticleCloud(Uri schemeAndHostname, ApiDefs.CloudApi mainApi, ApiDefs.IdentityApi identityApi, ApiDefs.CloudApi perDeviceFastTimeoutApi, AppDataStorage appDataStorage, LocalBroadcastManager broadcastManager, Gson gson, ExecutorService executor) {
        this.mainApi = mainApi;
        this.identityApi = identityApi;
        this.deviceFastTimeoutApi = perDeviceFastTimeoutApi;
        this.appDataStorage = appDataStorage;
        this.broadcastManager = broadcastManager;
        this.user = ParticleUser.fromSavedSession();
        this.token = ParticleAccessToken.fromSavedSession();
        if (this.token != null) {
            this.token.setDelegate(new TokenDelegate());
        }
        this.eventsDelegate = new EventsDelegate(mainApi, schemeAndHostname, gson, executor, this);
        this.parallelDeviceFetcher = ParallelDeviceFetcher.newFetcherUsingExecutor(executor);
    }

    @Nullable
    public String getAccessToken() {
        return this.token == null ? null : this.token.getAccessToken();
    }

    public void setAccessToken(String tokenString, Date expirationDate) {
        ParticleAccessToken.removeSession();
        this.token = ParticleAccessToken.fromTokenData(expirationDate, tokenString);
        this.token.setDelegate(this.tokenDelegate);
    }

    @Nullable
    public String getLoggedInUsername() {
        return Py.all(this.token, this.user) ? this.user.getUser() : null;
    }

    public boolean isLoggedIn() {
        return this.getLoggedInUsername() != null;
    }

    @WorkerThread
    public void logIn(String user, String password) throws ParticleCloudException {
        try {
            Responses.LogInResponse response = this.identityApi.logIn("password", user, password);
            this.onLogIn(response, user, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void signUpWithUser(String user, String password) throws ParticleCloudException {
        try {
            this.identityApi.signUp(user, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void signUpAndLogInWithCustomer(String email, String password, String orgSlug) throws ParticleCloudException {
        if (!Py.all(email, password, orgSlug)) {
            throw new IllegalArgumentException("Email, password, and organization must all be specified");
        }
        try {
            Responses.LogInResponse response = this.identityApi.signUpAndLogInWithCustomer("client_credentials", email, password, orgSlug);
            this.onLogIn(response, email, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    public void logOut() {
        if (this.token != null) {
            this.token.cancelExpiration();
        }
        ParticleUser.removeSession();
        ParticleAccessToken.removeSession();
        this.token = null;
        this.user = null;
    }

    @WorkerThread
    public List<ParticleDevice> getDevices() throws ParticleCloudException {
        try {
            List<Responses.Models.SimpleDevice> simpleDevices = this.mainApi.getDevices();
            this.appDataStorage.saveUserHasClaimedDevices(Py.truthy(simpleDevices));
            List<ParticleDevice> result = Py.list();
            for (Responses.Models.SimpleDevice simpleDevice : simpleDevices) {
                ParticleDevice device = simpleDevice.isConnected ? this.getDevice(simpleDevice.id, false) : this.getOfflineDevice(simpleDevice);
                result.add(device);
            }
            this.pruneDeviceMap(simpleDevices);
            return result;
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    List<ParticleDevice> getDevicesParallel(boolean useShortTimeout) throws PartialDeviceListResultException, ParticleCloudException {
        try {
            List<Responses.Models.SimpleDevice> simpleDevices = this.mainApi.getDevices();
            this.appDataStorage.saveUserHasClaimedDevices(Py.truthy(simpleDevices));
            List<Responses.Models.SimpleDevice> offlineDevices = Py.list();
            List<Responses.Models.SimpleDevice> onlineDevices = Py.list();
            for (Responses.Models.SimpleDevice simpleDevice : simpleDevices) {
                List<Object> targetList = simpleDevice.isConnected ? onlineDevices : offlineDevices;
                targetList.add(simpleDevice);
            }
            List<ParticleDevice> result = Py.list();
            for (Responses.Models.SimpleDevice offlineDevice : offlineDevices) {
                result.add(this.getOfflineDevice(offlineDevice));
            }
            ApiDefs.CloudApi cloudApi = useShortTimeout ? this.deviceFastTimeoutApi : this.mainApi;
            int timeoutInSecs = useShortTimeout ? 5 : 35;
            Collection<ParallelDeviceFetcher.DeviceFetchResult> results = this.parallelDeviceFetcher.fetchDevicesInParallel(onlineDevices, cloudApi, timeoutInSecs);
            boolean shouldThrowIncompleteException = false;
            for (ParallelDeviceFetcher.DeviceFetchResult fetchResult : results) {
                if (fetchResult == null || fetchResult.fetchedDevice == null) {
                    shouldThrowIncompleteException = true;
                    continue;
                }
                result.add(this.getDevice(fetchResult.fetchedDevice, false));
            }
            this.pruneDeviceMap(simpleDevices);
            if (shouldThrowIncompleteException) {
                throw new PartialDeviceListResultException(result);
            }
            return result;
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public ParticleDevice getDevice(String deviceID) throws ParticleCloudException {
        return this.getDevice(deviceID, true);
    }

    @WorkerThread
    public void claimDevice(String deviceID) throws ParticleCloudException {
        try {
            this.mainApi.claimDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCode() throws ParticleCloudException {
        try {
            return this.mainApi.generateClaimCode("okhttp_appeasement");
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCodeForOrg(String orgSlug, String productSlug) throws ParticleCloudException {
        try {
            return this.mainApi.generateClaimCodeForOrg("okhttp_appeasement", orgSlug, productSlug);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void requestPasswordReset(String email) throws ParticleCloudException {
        try {
            this.identityApi.requestPasswordReset(email);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void publishEvent(String eventName, String event, @ParticleEventVisibility int eventVisibility, int timeToLive) throws ParticleCloudException {
        this.eventsDelegate.publishEvent(eventName, event, eventVisibility, timeToLive);
    }

    @WorkerThread
    public long subscribeToAllEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.eventsDelegate.subscribeToAllEvents(eventNamePrefix, handler);
    }

    @WorkerThread
    public long subscribeToMyDevicesEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.eventsDelegate.subscribeToMyDevicesEvents(eventNamePrefix, handler);
    }

    @WorkerThread
    public long subscribeToDeviceEvents(@Nullable String eventNamePrefix, String deviceID, ParticleEventHandler eventHandler) throws IOException {
        return this.eventsDelegate.subscribeToDeviceEvents(eventNamePrefix, deviceID, eventHandler);
    }

    @WorkerThread
    public void unsubscribeFromEventWithID(long eventListenerID) throws ParticleCloudException {
        this.eventsDelegate.unsubscribeFromEventWithID(eventListenerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void unclaimDevice(String deviceId) {
        this.mainApi.unclaimDevice(deviceId);
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            this.devices.remove(deviceId);
        }
        this.sendUpdateBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void changeDeviceName(String deviceId, String newName) throws ParticleCloudException {
        ParticleDevice particleDevice;
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            particleDevice = this.devices.get(deviceId);
        }
        DeviceState originalDeviceState = particleDevice.deviceState;
        DeviceState stateWithNewName = DeviceState.withNewName(originalDeviceState, newName);
        this.updateDeviceState(stateWithNewName, true);
        try {
            this.mainApi.nameDevice(originalDeviceState.deviceId, newName);
        }
        catch (RetrofitError e) {
            this.updateDeviceState(originalDeviceState, true);
            throw new ParticleCloudException(e);
        }
    }

    @WorkerThread
    void onDeviceNotConnected(DeviceState deviceState) {
        DeviceState newState = DeviceState.withNewConnectedState(deviceState, false);
        this.updateDeviceState(newState, true);
    }

    void notifyDeviceChanged() {
        this.sendUpdateBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParticleDevice getDeviceFromState(DeviceState deviceState) {
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            if (this.devices.containsKey(deviceState.deviceId)) {
                return this.devices.get(deviceState.deviceId);
            }
            ParticleDevice device = new ParticleDevice(this.mainApi, this, deviceState);
            this.devices.put(deviceState.deviceId, device);
            return device;
        }
    }

    @WorkerThread
    private ParticleDevice getDevice(String deviceID, boolean sendUpdate) throws ParticleCloudException {
        Responses.Models.CompleteDevice deviceCloudModel;
        try {
            deviceCloudModel = this.mainApi.getDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
        return this.getDevice(deviceCloudModel, sendUpdate);
    }

    private ParticleDevice getDevice(Responses.Models.CompleteDevice deviceModel, boolean sendUpdate) {
        DeviceState newDeviceState = this.fromCompleteDevice(deviceModel);
        ParticleDevice device = this.getDeviceFromState(newDeviceState);
        this.updateDeviceState(newDeviceState, sendUpdate);
        return device;
    }

    private ParticleDevice getOfflineDevice(Responses.Models.SimpleDevice offlineDevice) {
        DeviceState newDeviceState = this.fromSimpleDeviceModel(offlineDevice);
        ParticleDevice device = this.getDeviceFromState(newDeviceState);
        this.updateDeviceState(newDeviceState, false);
        return device;
    }

    private void updateDeviceState(DeviceState newState, boolean sendUpdateBroadcast) {
        ParticleDevice device = this.getDeviceFromState(newState);
        device.deviceState = newState;
        if (sendUpdateBroadcast) {
            this.sendUpdateBroadcast();
        }
    }

    private void sendUpdateBroadcast() {
        this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
    }

    private void onLogIn(Responses.LogInResponse response, String user, String password) {
        ParticleAccessToken.removeSession();
        this.token = ParticleAccessToken.fromNewSession(response);
        this.token.setDelegate(this.tokenDelegate);
        this.user = ParticleUser.fromNewCredentials(user, password);
    }

    private DeviceState fromCompleteDevice(Responses.Models.CompleteDevice completeDevice) {
        List<Object> unfilteredFuncs = completeDevice.functions == null ? Collections.emptyList() : completeDevice.functions;
        ImmutableSet functions = FluentIterable.from(unfilteredFuncs).filter(Predicates.notNull()).toSet();
        ImmutableMap variables = ImmutableMap.of();
        if (completeDevice.variables != null) {
            variables = ImmutableMap.copyOf((Map)Maps.transformEntries(completeDevice.variables, sMapTransformer));
        }
        return new DeviceState(completeDevice.deviceId, completeDevice.name, completeDevice.isConnected, (ImmutableSet<String>)functions, (ImmutableMap<String, ParticleDevice.VariableType>)variables, completeDevice.version, ParticleDevice.ParticleDeviceType.fromInt(completeDevice.productId), completeDevice.requiresUpdate, completeDevice.lastHeard);
    }

    private DeviceState fromSimpleDeviceModel(Responses.Models.SimpleDevice offlineDevice) {
        ImmutableSet functions = ImmutableSet.of();
        ImmutableMap variables = ImmutableMap.of();
        return new DeviceState(offlineDevice.id, offlineDevice.name, offlineDevice.isConnected, (ImmutableSet<String>)functions, (ImmutableMap<String, ParticleDevice.VariableType>)variables, "", ParticleDevice.ParticleDeviceType.fromInt(offlineDevice.productId), false, offlineDevice.lastHeard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeviceMap(List<Responses.Models.SimpleDevice> latestCloudDeviceList) {
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            HashSet currentDeviceIds = Sets.newHashSet(this.devices.keySet());
            ImmutableSet newDeviceIds = FluentIterable.from(latestCloudDeviceList).transform(toDeviceId).toSet();
            Sets.SetView toRemove = Sets.difference((Set)currentDeviceIds, (Set)newDeviceIds);
            for (String deviceId : toRemove) {
                this.devices.remove(deviceId);
            }
        }
    }

    public class PartialDeviceListResultException
    extends Exception {
        final List<ParticleDevice> devices;

        public PartialDeviceListResultException(List<ParticleDevice> devices, Exception cause) {
            super(cause);
            this.devices = devices;
        }

        public PartialDeviceListResultException(List<ParticleDevice> devices, RetrofitError error) {
            super(error);
            this.devices = devices;
        }

        public PartialDeviceListResultException(List<ParticleDevice> devices) {
            super("Undefined error while fetching devices");
            this.devices = devices;
        }
    }

    private class TokenDelegate
    implements ParticleAccessToken.ParticleAccessTokenDelegate {
        private TokenDelegate() {
        }

        @Override
        public void accessTokenExpiredAt(ParticleAccessToken accessToken, Date expirationDate) {
            if (ParticleCloud.this.user != null) {
                try {
                    ParticleCloud.this.logIn(ParticleCloud.this.user.getUser(), ParticleCloud.this.user.getPassword());
                    return;
                }
                catch (ParticleCloudException e) {
                    log.e("Error while trying to log in: ", e);
                }
            }
            ParticleAccessToken.removeSession();
            ParticleCloud.this.token = null;
        }
    }
}

