/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.utils.Parcelables;
import java.util.Date;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class DeviceState
implements Parcelable {
    final String deviceId;
    final String name;
    final boolean isConnected;
    final ImmutableSet<String> functions;
    final ImmutableMap<String, ParticleDevice.VariableType> variables;
    final String version;
    final ParticleDevice.ParticleDeviceType deviceType;
    final boolean requiresUpdate;
    final Date lastHeard;
    public static final Parcelable.Creator<DeviceState> CREATOR = new Parcelable.Creator<DeviceState>(){

        public DeviceState createFromParcel(Parcel in) {
            return new DeviceState(in);
        }

        public DeviceState[] newArray(int size) {
            return new DeviceState[size];
        }
    };

    DeviceState(String deviceId, String name, boolean isConnected, ImmutableSet<String> functions, ImmutableMap<String, ParticleDevice.VariableType> variables, @Nullable String version, ParticleDevice.ParticleDeviceType deviceType, boolean requiresUpdate, Date lastHeard) {
        this.deviceId = deviceId;
        this.name = name;
        this.isConnected = isConnected;
        this.functions = functions;
        this.variables = variables;
        this.version = version == null ? "" : version;
        this.deviceType = deviceType;
        this.requiresUpdate = requiresUpdate;
        this.lastHeard = lastHeard;
    }

    static DeviceState withNewName(DeviceState other, String newName) {
        return new DeviceState(other.deviceId, newName, other.isConnected, other.functions, other.variables, other.version, other.deviceType, other.requiresUpdate, other.lastHeard);
    }

    static DeviceState withNewConnectedState(DeviceState other, boolean newConnectedState) {
        return new DeviceState(other.deviceId, other.name, newConnectedState, other.functions, other.variables, other.version, other.deviceType, other.requiresUpdate, other.lastHeard);
    }

    private DeviceState(Parcel in) {
        this.deviceId = in.readString();
        this.name = in.readString();
        this.isConnected = Parcelables.readBoolean(in);
        this.functions = ImmutableSet.copyOf(Parcelables.readStringList(in));
        this.variables = ImmutableMap.copyOf(Parcelables.readSerializableMap(in));
        this.version = in.readString();
        this.deviceType = ParticleDevice.ParticleDeviceType.valueOf(in.readString());
        this.requiresUpdate = Parcelables.readBoolean(in);
        this.lastHeard = new Date(in.readLong());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceId);
        dest.writeString(this.name);
        Parcelables.writeBoolean(dest, this.isConnected);
        dest.writeStringList((List)this.functions.asList());
        Parcelables.writeSerializableMap(dest, this.variables);
        dest.writeString(this.version);
        dest.writeString(this.deviceType.name());
        Parcelables.writeBoolean(dest, this.requiresUpdate);
        dest.writeLong(this.lastHeard.getTime());
    }

    public int describeContents() {
        return 0;
    }
}

