/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketMessageType;
import org.kaazing.net.ws.impl.io.WsMessageReaderAdapter;

public class WsReaderImpl
extends Reader {
    private WsMessageReaderAdapter _adapter;
    private CharBuffer _charBuffer;
    private boolean _closed = false;

    public WsReaderImpl(WsMessageReaderAdapter adapter) throws IOException {
        this._adapter = adapter;
    }

    @Override
    public void close() throws IOException {
        if (this._closed) {
            return;
        }
        if (this._charBuffer != null) {
            this._charBuffer.clear();
        }
        this._charBuffer = null;
        this._closed = true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.checkStreamClosed();
        super.mark(readAheadLimit);
    }

    @Override
    public int read() throws IOException {
        this.checkStreamClosed();
        return super.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.checkStreamClosed();
        return super.read(cbuf);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.checkStreamClosed();
        return super.read(target);
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int remaining;
        this.checkStreamClosed();
        if (this._charBuffer == null || this._charBuffer.remaining() == 0) {
            try {
                CharSequence text = this._adapter.readText();
                this._charBuffer = CharBuffer.wrap(((String)text).toCharArray());
            }
            catch (IOException ex) {
                WebSocketMessageType type = this._adapter.getType();
                if (type == WebSocketMessageType.EOS || type == null) {
                    return -1;
                }
                String s = "Invalid message type: Reader must be used to only receive text messages";
                throw new WebSocketException(s, ex);
            }
        }
        int retval = (remaining = this._charBuffer.remaining()) < len ? remaining : len;
        this._charBuffer.get(cbuf, off, retval);
        return retval;
    }

    @Override
    public boolean ready() throws IOException {
        this.checkStreamClosed();
        return this._charBuffer != null && this._charBuffer.hasRemaining();
    }

    @Override
    public void reset() throws IOException {
        this.checkStreamClosed();
        super.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkStreamClosed();
        return super.skip(n);
    }

    public boolean isClosed() {
        return this._closed;
    }

    private void checkStreamClosed() throws IOException {
        if (!this._closed) {
            return;
        }
        String s = "Cannot perform the operation as the Reader is closed";
        throw new WebSocketException(s);
    }
}

