/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl.legacy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.net.sse.impl.SseEventStream;
import org.kaazing.net.sse.impl.SseEventStreamListener;
import org.kaazing.net.sse.impl.legacy.EventSource;
import org.kaazing.net.sse.impl.legacy.EventSourceEvent;
import org.kaazing.net.sse.impl.legacy.EventSourceListener;

public class EventSourceImpl
extends EventSource {
    private static final String CLASS_NAME = EventSourceImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private SseEventStream stream = null;
    private final List<EventSourceListener> listeners = new ArrayList<EventSourceListener>();
    private SseEventStreamListener eventStreamListener = new SseEventStreamListener(){

        @Override
        public void streamOpened() {
            LOG.entering(CLASS_NAME, "streamOpened");
            EventSourceEvent event = new EventSourceEvent(this, EventSourceEvent.Type.OPEN);
            for (EventSourceListener listener : EventSourceImpl.this.listeners) {
                try {
                    listener.onOpen(event);
                }
                catch (RuntimeException e) {
                    LOG.logp(Level.WARNING, CLASS_NAME, "onOpen", "Application threw an exception during onOpen: " + e.getMessage(), e);
                }
            }
        }

        @Override
        public void messageReceived(String eventName, String message) {
            LOG.entering(CLASS_NAME, "fireMessageListeners", message);
            EventSourceEvent event = new EventSourceEvent(this, EventSourceEvent.Type.MESSAGE, message);
            for (EventSourceListener listener : EventSourceImpl.this.listeners) {
                try {
                    listener.onMessage(event);
                }
                catch (RuntimeException e) {
                    LOG.logp(Level.WARNING, CLASS_NAME, "onMessage", "Application threw an exception during onMessage: " + e.getMessage(), e);
                }
            }
        }

        @Override
        public void streamErrored(Exception exception) {
            LOG.entering(CLASS_NAME, "fireErrorListeners");
            EventSourceEvent event = new EventSourceEvent(this, EventSourceEvent.Type.ERROR);
            for (EventSourceListener listener : EventSourceImpl.this.listeners) {
                try {
                    listener.onError(event);
                }
                catch (RuntimeException e) {
                    LOG.logp(Level.WARNING, CLASS_NAME, "onError", "Application threw an exception during onError: " + e.getMessage(), e);
                }
            }
        }
    };

    public EventSourceImpl() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    @Override
    public EventSource.ReadyState getReadyState() {
        if (this.stream == null) {
            return EventSource.ReadyState.CONNECTING;
        }
        switch (this.stream.getReadyState()) {
            case CONNECTING: {
                return EventSource.ReadyState.CONNECTING;
            }
            case OPEN: {
                return EventSource.ReadyState.OPEN;
            }
        }
        return EventSource.ReadyState.CLOSED;
    }

    @Override
    public void connect(String eventSourceUrl) throws IOException {
        LOG.entering(CLASS_NAME, "connect", eventSourceUrl);
        if (this.stream != null) {
            LOG.warning("Reusing the same event source for a differnt URL, please create a new EventSource object");
            throw new IllegalArgumentException("Reusing the same event source for a differnt URL, please create a new EventSource object");
        }
        this.stream = new SseEventStream(eventSourceUrl);
        this.stream.setListener(this.eventStreamListener);
        this.stream.connect();
    }

    @Override
    public void disconnect() {
        LOG.entering(CLASS_NAME, "disconnect");
        this.stream.stop();
        this.stream = null;
    }

    @Override
    public void addEventSourceListener(EventSourceListener listener) {
        LOG.entering(CLASS_NAME, "addEventSourceListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeEventSourceListener(EventSourceListener listener) {
        LOG.entering(CLASS_NAME, "removeEventSourceListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.remove(listener);
    }
}

