/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.util;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class WrappedByteBuffer {
    static int INITIAL_CAPACITY = 128;
    ByteBuffer _buf;
    private final int _minimumCapacity;
    private boolean autoExpand = true;
    private boolean _isBigEndian = true;

    public WrappedByteBuffer() {
        this(INITIAL_CAPACITY);
    }

    WrappedByteBuffer(int capacity) {
        this(ByteBuffer.allocate(capacity));
    }

    public WrappedByteBuffer(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    WrappedByteBuffer(byte[] bytes, int offset, int length) {
        this(ByteBuffer.wrap(bytes, offset, length));
    }

    public WrappedByteBuffer(ByteBuffer buf) {
        this._buf = buf;
        this._minimumCapacity = buf.capacity();
    }

    public ByteBuffer getNioByteBuffer() {
        return this._buf;
    }

    public final WrappedByteBuffer setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
        return this;
    }

    public final boolean isAutoExpand() {
        return this.autoExpand;
    }

    public final int arrayOffset() {
        int ao = this._buf.arrayOffset();
        return ao;
    }

    public final byte[] array() {
        byte[] a = this._buf.array();
        return a;
    }

    public static WrappedByteBuffer allocate(int capacity) {
        return new WrappedByteBuffer(capacity);
    }

    public static WrappedByteBuffer wrap(byte[] bytes) {
        return new WrappedByteBuffer(bytes);
    }

    public static WrappedByteBuffer wrap(byte[] bytes, int offset, int length) {
        return new WrappedByteBuffer(bytes, offset, length);
    }

    public static WrappedByteBuffer wrap(ByteBuffer in) {
        return new WrappedByteBuffer(in);
    }

    public ByteOrder order() {
        ByteOrder bo = this._buf.order();
        return bo;
    }

    public ByteOrder order(ByteOrder o) {
        this._isBigEndian = "BIG_ENDIAN".equals(o.toString());
        this._buf.order(o);
        return o;
    }

    public WrappedByteBuffer mark() {
        this._buf.mark();
        return this;
    }

    public WrappedByteBuffer reset() {
        this._buf = (ByteBuffer)this._buf.reset();
        return this;
    }

    private static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public WrappedByteBuffer compact() {
        int remaining = this.remaining();
        int capacity = this.capacity();
        if (capacity == 0) {
            return this;
        }
        if (remaining <= capacity >>> 2 && capacity > this._minimumCapacity) {
            int newCapacity = capacity;
            int minCapacity = WrappedByteBuffer.max(this._minimumCapacity, remaining << 1);
            while (newCapacity >>> 1 >= minCapacity) {
                newCapacity >>>= 1;
            }
            newCapacity = WrappedByteBuffer.max(minCapacity, newCapacity);
            if (newCapacity == capacity) {
                if (this._buf.remaining() == 0) {
                    this._buf.position(0);
                    this._buf.limit(this._buf.capacity());
                } else {
                    ByteBuffer dup = this._buf.duplicate();
                    this._buf.position(0);
                    this._buf.limit(this._buf.capacity());
                    this._buf.put(dup);
                }
                return this;
            }
            ByteOrder bo = this.order();
            if (remaining > newCapacity) {
                throw new IllegalStateException("The amount of the remaining bytes is greater than the new capacity.");
            }
            ByteBuffer oldBuf = this._buf;
            ByteBuffer newBuf = ByteBuffer.allocate(newCapacity);
            newBuf.put(oldBuf);
            this._buf = newBuf;
            this._buf.order(bo);
        } else {
            this._buf.compact();
        }
        return this;
    }

    public WrappedByteBuffer duplicate() {
        return WrappedByteBuffer.wrap(this._buf.duplicate());
    }

    public WrappedByteBuffer fill(int size) {
        this._autoExpand(size);
        while (size-- > 0) {
            this._buf.put((byte)0);
        }
        return this;
    }

    public WrappedByteBuffer fillWith(byte b, int size) {
        this._autoExpand(size);
        while (size-- > 0) {
            this._buf.put(b);
        }
        return this;
    }

    public int indexOf(byte b) {
        if (this._buf.hasArray()) {
            byte[] array = this._buf.array();
            int arrayOffset = this._buf.arrayOffset();
            int startAt = arrayOffset + this.position();
            int endAt = arrayOffset + this.limit();
            for (int i = startAt; i < endAt; ++i) {
                if (array[i] != b) continue;
                return i - arrayOffset;
            }
            return -1;
        }
        int startAt = this._buf.position();
        int endAt = this._buf.limit();
        for (int i = startAt; i < endAt; ++i) {
            if (this._buf.get(i) != b) continue;
            return i;
        }
        return -1;
    }

    public WrappedByteBuffer put(byte v) {
        this._autoExpand(1);
        this._buf.put(v);
        return this;
    }

    public WrappedByteBuffer put(byte[] v, int offset, int length) {
        this._autoExpand(length);
        for (int i = 0; i < length; ++i) {
            this._buf.put(v[offset + i]);
        }
        return this;
    }

    public WrappedByteBuffer putAt(int index, byte v) {
        this._checkForWriteAt(index, 1);
        this._buf.put(index, v);
        return this;
    }

    public WrappedByteBuffer putUnsigned(int v) {
        byte b = (byte)(v & 0xFF);
        return this.put(b);
    }

    public WrappedByteBuffer putUnsignedAt(int index, int v) {
        this._checkForWriteAt(index, 1);
        byte b = (byte)(v & 0xFF);
        return this.putAt(index, b);
    }

    public WrappedByteBuffer putShort(short v) {
        this._autoExpand(2);
        this._buf.putShort(v);
        return this;
    }

    public WrappedByteBuffer putShortAt(int index, short v) {
        this._checkForWriteAt(index, 2);
        this._buf.putShort(index, v);
        return this;
    }

    public WrappedByteBuffer putUnsignedShort(int v) {
        this.putShort((short)(v & 0xFFFF));
        return this;
    }

    public WrappedByteBuffer putUnsignedShortAt(int index, int v) {
        this._checkForWriteAt(index, 2);
        this.putShortAt(index, (short)(v & 0xFFFF));
        return this;
    }

    public WrappedByteBuffer putInt(int v) {
        this._autoExpand(4);
        this._buf.putInt(v);
        return this;
    }

    public WrappedByteBuffer putIntAt(int index, int v) {
        this._checkForWriteAt(index, 4);
        this._buf.putInt(index, v);
        return this;
    }

    public WrappedByteBuffer putUnsignedInt(long value) {
        this.putInt((int)value & 0xFFFFFFFF);
        return this;
    }

    public WrappedByteBuffer putUnsignedIntAt(int index, long value) {
        this._checkForWriteAt(index, 4);
        this.putIntAt(index, (int)value & 0xFFFFFFFF);
        return this;
    }

    public WrappedByteBuffer putLong(long v) {
        this._autoExpand(8);
        this._buf.putLong(v);
        return this;
    }

    public WrappedByteBuffer putLongAt(int index, long v) {
        this._checkForWriteAt(index, 8);
        this._buf.putLong(index, v);
        return this;
    }

    public WrappedByteBuffer putString(String v, Charset cs) {
        ByteBuffer strBuf = cs.encode(v);
        this._autoExpand(strBuf.limit());
        this._buf.put(strBuf);
        return this;
    }

    public WrappedByteBuffer putPrefixedString(int fieldSize, String v, Charset cs) {
        if (fieldSize == 0) {
            return this;
        }
        boolean utf16 = cs.name().startsWith("UTF-16");
        if (utf16 && fieldSize == 1) {
            throw new IllegalArgumentException("fieldSize is not even for UTF-16 character set");
        }
        ByteBuffer strBuf = cs.encode(v);
        this._autoExpand(fieldSize + strBuf.limit());
        int len = strBuf.remaining();
        switch (fieldSize) {
            case 1: {
                this.put((byte)len);
                break;
            }
            case 2: {
                this.putShort((short)len);
                break;
            }
            case 4: {
                this.putInt(len);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument, field size should be 1,2 or 4 and fieldSize is: " + fieldSize);
            }
        }
        this._buf.put(strBuf);
        return this;
    }

    public WrappedByteBuffer putBytes(byte[] b) {
        this._autoExpand(b.length);
        this._buf.put(b);
        return this;
    }

    public WrappedByteBuffer putBytesAt(int index, byte[] b) {
        this._checkForWriteAt(index, b.length);
        int pos = this._buf.position();
        this._buf.position(index);
        this._buf.put(b, 0, b.length);
        this._buf.position(pos);
        return this;
    }

    public WrappedByteBuffer putBuffer(WrappedByteBuffer v) {
        this._autoExpand(v.remaining());
        this._buf.put(v._buf);
        return this;
    }

    public WrappedByteBuffer putBufferAt(int index, WrappedByteBuffer v) {
        int pos = this._buf.position();
        this._buf.position(index);
        this._buf.put(v._buf);
        this._buf.position(pos);
        return this;
    }

    public byte get() {
        this._checkForRead(1);
        byte v = this._buf.get();
        return v;
    }

    public WrappedByteBuffer get(byte[] dst, int offset, int length) {
        this._checkForRead(length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this._buf.get();
        }
        return this;
    }

    public WrappedByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public byte getAt(int index) {
        this._checkForReadAt(index, 1);
        byte v = this._buf.get(index);
        return v;
    }

    public int getUnsigned() {
        this._checkForRead(1);
        int val = this._buf.get() & 0xFF;
        return val;
    }

    public int getUnsignedAt(int index) {
        this._checkForReadAt(index, 1);
        int val = this._buf.get(index) & 0xFF;
        return val;
    }

    public byte[] getBytes(int size) {
        this._checkForRead(size);
        byte[] dst = new byte[size];
        this._buf.get(dst, 0, size);
        return dst;
    }

    public byte[] getBytesAt(int index, int size) {
        this._checkForReadAt(index, size);
        byte[] dst = new byte[size];
        int i = 0;
        int j = index;
        while (i < size) {
            dst[i++] = this._buf.get(j++);
        }
        return dst;
    }

    public short getShort() {
        this._checkForRead(2);
        short v = this._buf.getShort();
        return v;
    }

    public short getShortAt(int index) {
        this._checkForReadAt(index, 2);
        short v = this._buf.getShort(index);
        return v;
    }

    public int getUnsignedShort() {
        this._checkForRead(2);
        int val = this._buf.getShort() & 0xFFFF;
        return val;
    }

    public int getUnsignedShortAt(int index) {
        this._checkForReadAt(index, 2);
        int val = this._buf.getShort(index) & 0xFFFF;
        return val;
    }

    public int getUnsignedMediumInt() {
        int b1 = this.getUnsigned();
        int b2 = this.getUnsigned();
        int b3 = this.getUnsigned();
        if (this._isBigEndian) {
            return b1 << 16 | b2 << 8 | b3;
        }
        return b3 << 16 | b2 << 8 | b1;
    }

    public int getInt() {
        this._checkForRead(4);
        int v = this._buf.getInt();
        return v;
    }

    public int getIntAt(int index) {
        this._checkForReadAt(index, 4);
        int v = this._buf.getInt(index);
        return v;
    }

    public long getUnsignedInt() {
        this._checkForRead(4);
        long val = (long)this._buf.getInt() & 0xFFFFFFFFL;
        return val;
    }

    public long getUnsignedIntAt(int index) {
        this._checkForReadAt(index, 4);
        long val = (long)this._buf.getInt(index) & 0xFFFFFFFFL;
        return val;
    }

    public long getLong() {
        this._checkForRead(8);
        long v = this._buf.getLong();
        return v;
    }

    public long getLongAt(int index) {
        this._checkForReadAt(index, 8);
        long v = this._buf.getLong(index);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefixedString(int fieldSize, Charset cs) {
        int len = 0;
        switch (fieldSize) {
            case 1: {
                len = this._buf.get();
                break;
            }
            case 2: {
                len = this._buf.getShort();
                break;
            }
            case 4: {
                len = this._buf.getInt();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument, field size should be 1,2 or 4 and fieldSize is: " + fieldSize);
            }
        }
        if (len == 0) {
            return "";
        }
        int oldLimit = this._buf.limit();
        try {
            String retVal;
            this._buf.limit(this._buf.position() + len);
            byte[] bytes = new byte[len];
            this._buf.get(bytes, 0, len);
            String string = retVal = cs.decode(ByteBuffer.wrap(bytes)).toString();
            return string;
        }
        finally {
            this._buf.limit(oldLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Charset cs) {
        int nullAt = this.indexOf((byte)0);
        boolean utf16 = cs.name().startsWith("UTF-16");
        if (utf16) {
            int oldPos = this._buf.position();
            boolean nullFound = false;
            while (!nullFound && nullAt != -1) {
                if (this._buf.get(nullAt + 1) == 0) {
                    nullFound = true;
                    break;
                }
                this._buf.position(nullAt + 1);
                nullAt = this.indexOf((byte)0);
            }
            if (!nullFound) {
                throw new IllegalStateException("The string being read is not UTF-16");
            }
            this._buf.position(oldPos);
        }
        int newLimit = nullAt != -1 ? nullAt : this._buf.limit();
        int numBytes = newLimit - this._buf.position();
        int oldLimit = this._buf.limit();
        try {
            String retVal;
            this._buf.limit(newLimit);
            byte[] bytes = new byte[numBytes];
            this._buf.get(bytes, 0, numBytes);
            String string = retVal = cs.decode(ByteBuffer.wrap(bytes)).toString();
            return string;
        }
        finally {
            this._buf.limit(oldLimit);
            if (nullAt != -1) {
                this._buf.get();
                if (utf16) {
                    this._buf.get();
                }
            }
        }
    }

    public WrappedByteBuffer slice() {
        return WrappedByteBuffer.wrap(this._buf.slice());
    }

    public WrappedByteBuffer flip() {
        this._buf = (ByteBuffer)this._buf.flip();
        return this;
    }

    public WrappedByteBuffer rewind() {
        this._buf = (ByteBuffer)this._buf.rewind();
        return this;
    }

    public WrappedByteBuffer clear() {
        this._buf = (ByteBuffer)this._buf.clear();
        return this;
    }

    public int remaining() {
        int rem = this._buf.remaining();
        return rem;
    }

    public int capacity() {
        int cap = this._buf.capacity();
        return cap;
    }

    public int position() {
        int pos = this._buf.position();
        return pos;
    }

    public WrappedByteBuffer position(int position) {
        this._autoExpandAt(position, 0);
        this._buf.position(position);
        return this;
    }

    public int limit() {
        return this._buf.limit();
    }

    public WrappedByteBuffer limit(int limit) {
        this._autoExpandAt(limit, 0);
        this._buf.limit(limit);
        return this;
    }

    public boolean hasRemaining() {
        boolean rem = this._buf.hasRemaining();
        return rem;
    }

    public WrappedByteBuffer skip(int size) {
        this._autoExpand(size);
        this._buf.position(this._buf.position() + size);
        return this;
    }

    public String getHexDump() {
        if (this._buf.position() == this._buf.limit()) {
            return "empty";
        }
        StringBuilder hexDump = new StringBuilder();
        for (int i = this._buf.position(); i < this._buf.limit(); ++i) {
            hexDump.append(Integer.toHexString(this._buf.get(i) & 0xFF)).append(' ');
        }
        return hexDump.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[position:" + this.position() + " limit: " + this.limit() + " capacity:" + this.capacity() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WrappedByteBuffer)) {
            return false;
        }
        WrappedByteBuffer that = (WrappedByteBuffer)obj;
        return this._buf.equals(that._buf);
    }

    public int hashCode() {
        return this._buf.hashCode();
    }

    WrappedByteBuffer expand(int expectedRemaining) {
        return this.expandAt(this._buf.position(), expectedRemaining);
    }

    WrappedByteBuffer expandAt(int i, int expectedRemaining) {
        if (i + expectedRemaining <= this._buf.limit()) {
            return this;
        }
        if (i + expectedRemaining <= this._buf.capacity()) {
            this._buf.limit(i + expectedRemaining);
        } else {
            int newCapacity = this._buf.capacity() + (expectedRemaining > INITIAL_CAPACITY ? expectedRemaining : INITIAL_CAPACITY);
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            this._buf.flip();
            newBuffer.put(this._buf);
            this._buf = newBuffer;
        }
        return this;
    }

    private void _autoExpandAt(int i, int expectedRemaining) {
        if (this.autoExpand) {
            this.expandAt(i, expectedRemaining);
        }
    }

    private void _autoExpand(int expectedRemaining) {
        if (this.autoExpand) {
            this.expand(expectedRemaining);
        }
    }

    private void _checkForRead(int expected) {
        int end = this._buf.position() + expected;
        if (end > this._buf.limit()) {
            throw new BufferUnderflowException();
        }
    }

    private void _checkForReadAt(int index, int expected) {
        int end = index + expected;
        if (index < 0 || end > this._buf.limit()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void _checkForWriteAt(int index, int expected) {
        int end = index + expected;
        if (index < 0 || end > this._buf.limit()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

