/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.persistance.SensitiveDataStorage;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.lang.ref.WeakReference;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ParticleAccessToken {
    private static final TLog log = TLog.get(ParticleAccessToken.class);
    private static final int ACCESS_TOKEN_EXPIRY_MARGIN = 0;
    private final Handler handler;
    private String accessToken;
    private Date expiryDate;
    private volatile Runnable expirationRunnable;
    private volatile ParticleAccessTokenDelegate delegate;

    public static synchronized ParticleAccessToken fromNewSession(Responses.LogInResponse logInResponse) {
        if (logInResponse == null || !Py.truthy(logInResponse.accessToken) || !"bearer".equalsIgnoreCase(logInResponse.tokenType)) {
            throw new IllegalArgumentException("Invalid LogInResponse: " + logInResponse);
        }
        long expirationMillis = logInResponse.expiresInSeconds * 1000L;
        Date expirationDate = new Date(System.currentTimeMillis() + expirationMillis);
        return ParticleAccessToken.fromTokenData(expirationDate, logInResponse.accessToken);
    }

    @Nullable
    public static synchronized ParticleAccessToken fromSavedSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        String accessToken = sensitiveDataStorage.getToken();
        Date expirationDate = sensitiveDataStorage.getTokenExpirationDate();
        if (!Py.truthy(accessToken) || !Py.truthy(expirationDate) || expirationDate.before(new Date())) {
            return null;
        }
        ParticleAccessToken token = new ParticleAccessToken(accessToken, expirationDate, new Handler(Looper.getMainLooper()));
        token.scheduleExpiration();
        return token;
    }

    public static synchronized ParticleAccessToken fromTokenData(Date expirationDate, String accessToken) {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.saveToken(accessToken);
        sensitiveDataStorage.saveTokenExpirationDate(expirationDate);
        ParticleAccessToken token = new ParticleAccessToken(accessToken, expirationDate, new Handler(Looper.getMainLooper()));
        token.scheduleExpiration();
        return token;
    }

    public static synchronized void removeSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.resetToken();
        sensitiveDataStorage.resetTokenExpirationDate();
    }

    private ParticleAccessToken(String accessToken, Date expiryDate, Handler handler) {
        this.accessToken = accessToken;
        this.expiryDate = expiryDate;
        this.handler = handler;
    }

    public String getAccessToken() {
        if (this.expiryDate.getTime() + 0L < System.currentTimeMillis()) {
            return null;
        }
        return this.accessToken;
    }

    public ParticleAccessTokenDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ParticleAccessTokenDelegate delegate) {
        this.delegate = delegate;
    }

    private void onExpiration() {
        log.d("Entering onExpiration()");
        this.expirationRunnable = null;
        if (this.delegate == null) {
            log.w("Token expiration delegate is null");
            this.accessToken = null;
            return;
        }
        EZ.runAsync(new Runnable(){

            @Override
            public void run() {
                ParticleAccessToken.this.delegate.accessTokenExpiredAt(ParticleAccessToken.this, ParticleAccessToken.this.expiryDate);
            }
        });
    }

    private void scheduleExpiration() {
        long delay = this.expiryDate.getTime() - System.currentTimeMillis();
        log.d("Scheduling token expiration for " + this.expiryDate + " (" + delay + "ms.");
        this.handler.postDelayed((Runnable)new ExpirationHandler(this), delay);
    }

    void cancelExpiration() {
        if (this.expirationRunnable != null) {
            this.handler.removeCallbacks(this.expirationRunnable);
            this.expirationRunnable = null;
        }
    }

    protected void finalize() throws Throwable {
        this.cancelExpiration();
        super.finalize();
    }

    private static class ExpirationHandler
    implements Runnable {
        final WeakReference<ParticleAccessToken> tokenRef;

        private ExpirationHandler(ParticleAccessToken token) {
            this.tokenRef = new WeakReference<ParticleAccessToken>(token);
        }

        @Override
        public void run() {
            log.d("Running token expiration handler...");
            ParticleAccessToken token = (ParticleAccessToken)this.tokenRef.get();
            if (token == null) {
                log.d("...but the token was null, doing nothing.");
                return;
            }
            token.onExpiration();
            this.tokenRef.clear();
        }
    }

    public static interface ParticleAccessTokenDelegate {
        public void accessTokenExpiredAt(ParticleAccessToken var1, Date var2);
    }
}

