/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.StringRes;
import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.squareup.okhttp.OkHttpClient;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.R;
import java.lang.reflect.Type;
import java.util.Date;
import org.joda.time.DateTime;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class ApiFactory {
    private final Context ctx;
    private final TokenGetterDelegate tokenDelegate;
    private final OkHttpClient okHttpClient;
    private final OauthBasicAuthCredentialsProvider basicAuthCredentialsProvider;
    private final Gson gson;

    ApiFactory(Context ctx, TokenGetterDelegate tokenGetterDelegate, OauthBasicAuthCredentialsProvider basicAuthProvider) {
        this.ctx = ctx.getApplicationContext();
        this.tokenDelegate = tokenGetterDelegate;
        this.okHttpClient = new OkHttpClient();
        this.basicAuthCredentialsProvider = basicAuthProvider;
        this.gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new StringlyTypedDateAdapter()).create();
    }

    ApiDefs.CloudApi buildNewCloudApi() {
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder(this.gson).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", "Bearer " + ApiFactory.this.tokenDelegate.getTokenValue());
            }
        }).build();
        return (ApiDefs.CloudApi)restAdapter.create(ApiDefs.CloudApi.class);
    }

    ApiDefs.IdentityApi buildNewIdentityApi() {
        final String basicAuthValue = this.getBasicAuthValue();
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder(this.gson).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", basicAuthValue);
            }
        }).build();
        return (ApiDefs.IdentityApi)restAdapter.create(ApiDefs.IdentityApi.class);
    }

    Uri getApiUri() {
        return Uri.parse((String)this.ctx.getString(R.string.api_base_uri));
    }

    Gson getGsonInstance() {
        return this.gson;
    }

    private String getBasicAuthValue() {
        String authString = String.format("%s:%s", this.basicAuthCredentialsProvider.getClientId(), this.basicAuthCredentialsProvider.getClientSecret());
        return "Basic " + Base64.encodeToString((byte[])authString.getBytes(), (int)2);
    }

    private RestAdapter.Builder buildCommonRestAdapterBuilder(Gson gson) {
        return new RestAdapter.Builder().setClient((Client)new OkClient(this.okHttpClient)).setConverter((Converter)new GsonConverter(gson)).setEndpoint(this.getApiUri().toString()).setLogLevel(RestAdapter.LogLevel.valueOf((String)this.ctx.getString(R.string.http_log_level)));
    }

    private static class StringlyTypedDateAdapter
    implements JsonDeserializer<Date> {
        private StringlyTypedDateAdapter() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String asStr = json.getAsString();
            return new DateTime((Object)asStr).toDate();
        }
    }

    public static class ResourceValueBasicAuthCredentialsProvider
    implements OauthBasicAuthCredentialsProvider {
        private final String clientId;
        private final String clientSecret;

        public ResourceValueBasicAuthCredentialsProvider(Context ctx, @StringRes int clientIdResId, @StringRes int clientSecretResId) {
            this.clientId = ctx.getString(clientIdResId);
            this.clientSecret = ctx.getString(clientSecretResId);
        }

        @Override
        public String getClientId() {
            return this.clientId;
        }

        @Override
        public String getClientSecret() {
            return this.clientSecret;
        }
    }

    public static interface OauthBasicAuthCredentialsProvider {
        public String getClientId();

        public String getClientSecret();
    }

    public static interface TokenGetterDelegate {
        public String getTokenValue();
    }
}

