/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.url;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Map;
import org.kaazing.net.ws.WsURLConnection;
import org.kaazing.net.ws.impl.WsURLConnectionImpl;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionFactorySpi;

class WsURLStreamHandlerImpl
extends URLStreamHandler {
    private final Map<String, WebSocketExtensionFactorySpi> _extensionFactories;
    private String _scheme;

    public WsURLStreamHandlerImpl(Map<String, WebSocketExtensionFactorySpi> extensionFactories) {
        this._extensionFactories = extensionFactories;
    }

    @Override
    protected int getDefaultPort() {
        return 80;
    }

    @Override
    protected WsURLConnection openConnection(URL location) throws IOException {
        return new WsURLConnectionImpl(location, this._extensionFactories);
    }

    @Override
    protected void parseURL(URL location, String spec, int start, int limit) {
        this._scheme = spec.substring(0, spec.indexOf("://"));
        URI specURI = this._getSpecURI(spec);
        String host = specURI.getHost();
        int port = specURI.getPort();
        String authority = specURI.getAuthority();
        String userInfo = specURI.getUserInfo();
        String path = specURI.getPath();
        String query = specURI.getQuery();
        this.setURL(location, this._scheme, host, port, authority, userInfo, path, query, null);
    }

    @Override
    protected String toExternalForm(URL location) {
        return super.toExternalForm(location);
    }

    private URI _getSpecURI(String spec) {
        URI specURI = URI.create(spec);
        if (this._scheme.indexOf(58) == -1) {
            return specURI;
        }
        String schemeSpecificPart = specURI.getSchemeSpecificPart();
        return URI.create(schemeSpecificPart);
    }
}

